/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.flink.api.common.accumulators.LongCounter;
import org.apache.flink.runtime.accumulators.AccumulatorRegistry;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.instance.InstanceConnectionInfo;
import org.apache.flink.runtime.webmonitor.ExecutionGraphHolder;
import org.apache.flink.runtime.webmonitor.handlers.AbstractJobVertexRequestHandler;
import org.apache.flink.runtime.webmonitor.handlers.JsonFactory;
import org.apache.flink.runtime.webmonitor.handlers.RequestHandler;

public class JobVertexDetailsHandler
extends AbstractJobVertexRequestHandler
implements RequestHandler.JsonResponse {
    public JobVertexDetailsHandler(ExecutionGraphHolder executionGraphHolder) {
        super(executionGraphHolder);
    }

    @Override
    public String handleRequest(ExecutionJobVertex jobVertex, Map<String, String> params) throws Exception {
        long now = System.currentTimeMillis();
        StringWriter writer = new StringWriter();
        JsonGenerator gen = JsonFactory.jacksonFactory.createJsonGenerator((Writer)writer);
        gen.writeStartObject();
        gen.writeStringField("id", jobVertex.getJobVertexId().toString());
        gen.writeStringField("name", jobVertex.getJobVertex().getName());
        gen.writeNumberField("parallelism", jobVertex.getParallelism());
        gen.writeNumberField("now", now);
        gen.writeArrayFieldStart("subtasks");
        int num = 0;
        for (ExecutionVertex vertex : jobVertex.getTaskVertices()) {
            LongCounter writeRecords;
            LongCounter readRecords;
            LongCounter writeBytes;
            LongCounter readBytes;
            long endTime;
            ExecutionState status = vertex.getExecutionState();
            InstanceConnectionInfo location = vertex.getCurrentAssignedResourceLocation();
            String locationString = location == null ? "(unassigned)" : location.getHostname();
            long startTime = vertex.getStateTimestamp(ExecutionState.DEPLOYING);
            if (startTime == 0L) {
                startTime = -1L;
            }
            long l = endTime = status.isTerminal() ? vertex.getStateTimestamp(status) : -1L;
            long duration = startTime > 0L ? (endTime > 0L ? endTime : now) - startTime : -1L;
            Map metrics = vertex.getCurrentExecutionAttempt().getFlinkAccumulators();
            if (metrics != null) {
                readBytes = (LongCounter)metrics.get(AccumulatorRegistry.Metric.NUM_BYTES_IN);
                writeBytes = (LongCounter)metrics.get(AccumulatorRegistry.Metric.NUM_BYTES_OUT);
                readRecords = (LongCounter)metrics.get(AccumulatorRegistry.Metric.NUM_RECORDS_IN);
                writeRecords = (LongCounter)metrics.get(AccumulatorRegistry.Metric.NUM_RECORDS_OUT);
            } else {
                readBytes = null;
                writeBytes = null;
                readRecords = null;
                writeRecords = null;
            }
            gen.writeStartObject();
            gen.writeNumberField("subtask", num);
            gen.writeStringField("status", status.name());
            gen.writeNumberField("attempt", vertex.getCurrentExecutionAttempt().getAttemptNumber());
            gen.writeStringField("host", locationString);
            gen.writeNumberField("start-time", startTime);
            gen.writeNumberField("end-time", endTime);
            gen.writeNumberField("duration", duration);
            gen.writeObjectFieldStart("metrics");
            gen.writeNumberField("read-bytes", readBytes != null ? readBytes.getLocalValuePrimitive() : -1L);
            gen.writeNumberField("write-bytes", writeBytes != null ? writeBytes.getLocalValuePrimitive() : -1L);
            gen.writeNumberField("read-records", readRecords != null ? readRecords.getLocalValuePrimitive() : -1L);
            gen.writeNumberField("write-records", writeRecords != null ? writeRecords.getLocalValuePrimitive() : -1L);
            gen.writeEndObject();
            gen.writeEndObject();
            ++num;
        }
        gen.writeEndArray();
        gen.writeEndObject();
        gen.close();
        return writer.toString();
    }
}

