/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.webmonitor.handlers.JsonFactory;
import org.apache.flink.runtime.webmonitor.handlers.RequestHandler;

public class JobManagerConfigHandler
implements RequestHandler,
RequestHandler.JsonResponse {
    private final Configuration config;

    public JobManagerConfigHandler(Configuration config) {
        this.config = config;
    }

    @Override
    public String handleRequest(Map<String, String> params, ActorGateway jobManagerGateway) throws Exception {
        StringWriter writer = new StringWriter();
        JsonGenerator gen = JsonFactory.jacksonFactory.createJsonGenerator((Writer)writer);
        gen.writeStartArray();
        for (String key : this.config.keySet()) {
            gen.writeStartObject();
            gen.writeStringField("key", key);
            gen.writeStringField("value", this.config.getString(key, null));
            gen.writeEndObject();
        }
        gen.writeEndArray();
        gen.close();
        return writer.toString();
    }
}

