/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.webmonitor.files.MimeTypes;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Tuple2;

public class HandlerRedirectUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HandlerRedirectUtils.class);
    private static final Pattern LeaderAddressHostPattern = Pattern.compile("^.+@(.+):([0-9]+)/user/.+$");

    public static String getRedirectAddress(String localJobManagerAddress, Tuple2<ActorGateway, Integer> leader) throws Exception {
        String leaderAddress = ((ActorGateway)leader._1()).path();
        int webMonitorPort = (Integer)leader._2();
        String jobManagerName = localJobManagerAddress.substring(localJobManagerAddress.lastIndexOf("/") + 1);
        if (!localJobManagerAddress.equals(leaderAddress) && !leaderAddress.equals(JobManager.getLocalJobManagerAkkaURL((Option)Option.apply((Object)jobManagerName)))) {
            Matcher matcher = LeaderAddressHostPattern.matcher(leaderAddress);
            if (matcher.matches()) {
                String redirectAddress = String.format("%s:%d", matcher.group(1), webMonitorPort);
                return redirectAddress;
            }
            LOG.warn("Unexpected leader address pattern {}. Cannot extract host.", (Object)leaderAddress);
        }
        return null;
    }

    public static HttpResponse getRedirectResponse(String redirectAddress, String path) throws Exception {
        Preconditions.checkNotNull(redirectAddress, "Redirect address");
        Preconditions.checkNotNull(path, "Path");
        String newLocation = String.format("http://%s%s", redirectAddress, path);
        DefaultFullHttpResponse redirectResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.TEMPORARY_REDIRECT);
        redirectResponse.headers().set("Location", (Object)newLocation);
        redirectResponse.headers().set("Content-Encoding", (Object)"utf-8");
        redirectResponse.headers().set("Content-Length", (Object)0);
        return redirectResponse;
    }

    public static HttpResponse getUnavailableResponse() throws UnsupportedEncodingException {
        String result = "Service temporarily unavailable due to an ongoing leader election. Please refresh.";
        byte[] bytes = result.getBytes(Charset.forName("UTF-8"));
        DefaultFullHttpResponse unavailableResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SERVICE_UNAVAILABLE, Unpooled.wrappedBuffer((byte[])bytes));
        unavailableResponse.headers().set("Content-Encoding", (Object)"utf-8");
        unavailableResponse.headers().set("Content-Length", (Object)bytes.length);
        unavailableResponse.headers().set("Content-Type", (Object)MimeTypes.getMimeTypeForExtension("txt"));
        return unavailableResponse;
    }
}

