/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import java.util.Map;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.webmonitor.ExecutionGraphHolder;
import org.apache.flink.runtime.webmonitor.handlers.AbstractJobVertexRequestHandler;

public abstract class AbstractSubtaskRequestHandler
extends AbstractJobVertexRequestHandler {
    public AbstractSubtaskRequestHandler(ExecutionGraphHolder executionGraphHolder) {
        super(executionGraphHolder);
    }

    @Override
    public final String handleRequest(ExecutionJobVertex jobVertex, Map<String, String> params) throws Exception {
        int subtask;
        String subtaskNumberString = params.get("subtasknum");
        if (subtaskNumberString == null) {
            throw new RuntimeException("Subtask number parameter missing");
        }
        try {
            subtask = Integer.parseInt(subtaskNumberString);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid subtask number parameter");
        }
        if (subtask < 0 || subtask >= jobVertex.getParallelism()) {
            throw new RuntimeException("subtask does not exist: " + subtask);
        }
        ExecutionVertex vertex = jobVertex.getTaskVertices()[subtask];
        return this.handleRequest(vertex, params);
    }

    public abstract String handleRequest(ExecutionVertex var1, Map<String, String> var2) throws Exception;
}

