/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor;

import java.util.WeakHashMap;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.runtime.webmonitor.WebRuntimeMonitor;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class ExecutionGraphHolder {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionGraphHolder.class);
    private final FiniteDuration timeout;
    private final WeakHashMap<JobID, ExecutionGraph> cache = new WeakHashMap();

    public ExecutionGraphHolder() {
        this(WebRuntimeMonitor.DEFAULT_REQUEST_TIMEOUT);
    }

    public ExecutionGraphHolder(FiniteDuration timeout) {
        this.timeout = Preconditions.checkNotNull(timeout);
    }

    public ExecutionGraph getExecutionGraph(JobID jid, ActorGateway jobManager) {
        ExecutionGraph cached = this.cache.get(jid);
        if (cached != null) {
            return cached;
        }
        try {
            if (jobManager != null) {
                Future future = jobManager.ask((Object)new JobManagerMessages.RequestJob(jid), this.timeout);
                Object result = Await.result((Awaitable)future, (Duration)this.timeout);
                if (result instanceof JobManagerMessages.JobNotFound) {
                    return null;
                }
                if (result instanceof JobManagerMessages.JobFound) {
                    ExecutionGraph eg = ((JobManagerMessages.JobFound)result).executionGraph();
                    this.cache.put(jid, eg);
                    return eg;
                }
                throw new RuntimeException("Unknown response from JobManager / Archive: " + result);
            }
            LOG.warn("No connection to the leading JobManager.");
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Error requesting execution graph", e);
        }
    }
}

