/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.stream.impl.io.OutputStreamSourceStage;
import org.apache.pekko.stream.impl.io.OutputStreamSourceStage$Close$;
import org.apache.pekko.stream.stage.AsyncCallback;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.Option;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Await$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Numeric$IntIsIntegral$;
import scala.reflect.ScalaSignature;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a!\u0002\u0006\f\u0001E9\u0002\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\t\u0011%\u0002!\u0011!Q\u0001\n)B\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\u0006\u0015\u0002!\ta\u0013\u0005\u0007#\u0002\u0001K\u0011\u0002*\t\u000b\u0019\u0004A\u0011I4\t\u000b\u0019\u0004A\u0011\t8\t\u000bm\u0004A\u0011\t?\t\u000by\u0004A\u0011\t?\u0003'=+H\u000f];u'R\u0014X-Y7BI\u0006\u0004H/\u001a:\u000b\u00051i\u0011AA5p\u0015\tqq\"\u0001\u0003j[Bd'B\u0001\t\u0012\u0003\u0019\u0019HO]3b[*\u0011!cE\u0001\u0006a\u0016\\7n\u001c\u0006\u0003)U\ta!\u00199bG\",'\"\u0001\f\u0002\u0007=\u0014xm\u0005\u0002\u00011A\u0011\u0011$H\u0007\u00025)\u0011Ab\u0007\u0006\u00029\u0005!!.\u0019<b\u0013\tq\"D\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW.A\tv]\u001a,HNZ5mY\u0016$G)Z7b]\u0012\u001c\u0001\u0001\u0005\u0002#O5\t1E\u0003\u0002%K\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\u0019Z\u0012\u0001B;uS2L!\u0001K\u0012\u0003\u0013M+W.\u00199i_J,\u0017aC:f]\u0012$vn\u0015;bO\u0016\u00042a\u000b\u00181\u001b\u0005a#BA\u0017\u0010\u0003\u0015\u0019H/Y4f\u0013\tyCFA\u0007Bgft7mQ1mY\n\f7m\u001b\t\u0003cur!AM\u001e\u000f\u0005MRdB\u0001\u001b:\u001d\t)\u0004H\u0004\u00027o5\t1#\u0003\u0002\u0013'%\u0011\u0001#E\u0005\u0003\u001d=I!\u0001D\u0007\n\u0005qZ\u0011aF(viB,Ho\u0015;sK\u0006l7k\\;sG\u0016\u001cF/Y4f\u0013\tqtHA\u000bBI\u0006\u0004H/\u001a:U_N#\u0018mZ3NKN\u001c\u0018mZ3\u000b\u0005qZ\u0011\u0001D<sSR,G+[7f_V$\bC\u0001\"I\u001b\u0005\u0019%B\u0001#F\u0003!!WO]1uS>t'B\u0001\u0013G\u0015\u00059\u0015!B:dC2\f\u0017BA%D\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\fa\u0001P5oSRtD\u0003\u0002'O\u001fB\u0003\"!\u0014\u0001\u000e\u0003-AQa\b\u0003A\u0002\u0005BQ!\u000b\u0003A\u0002)BQ\u0001\u0011\u0003A\u0002\u0005\u000b\u0001b]3oI\u0012\u000bG/\u0019\u000b\u0003'^\u0003\"\u0001V+\u000e\u0003\u0019K!A\u0016$\u0003\tUs\u0017\u000e\u001e\u0005\u00061\u0016\u0001\r!W\u0001\u0005I\u0006$\u0018\r\u0005\u0002[96\t1L\u0003\u0002'#%\u0011Ql\u0017\u0002\u000b\u0005f$Xm\u0015;sS:<\u0007fA\u0003`KB\u0019A\u000b\u00192\n\u0005\u00054%A\u0002;ie><8\u000f\u0005\u0002\u001aG&\u0011AM\u0007\u0002\f\u0013>+\u0005pY3qi&|gnI\u0001c\u0003\u00159(/\u001b;f)\t\u0019\u0006\u000eC\u0003j\r\u0001\u0007!.A\u0001c!\t!6.\u0003\u0002m\r\n\u0019\u0011J\u001c;)\u0007\u0019yV\r\u0006\u0003T_ZD\b\"B5\b\u0001\u0004\u0001\bc\u0001+rg&\u0011!O\u0012\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003)RL!!\u001e$\u0003\t\tKH/\u001a\u0005\u0006o\u001e\u0001\rA[\u0001\u0004_\u001a4\u0007\"B=\b\u0001\u0004Q\u0017a\u00017f]\"\u001aqaX3\u0002\u000b\u0019dWo\u001d5\u0015\u0003MC3\u0001C0f\u0003\u0015\u0019Gn\\:fQ\rIq,\u001a")
public class OutputStreamAdapter
extends OutputStream {
    private final Semaphore unfulfilledDemand;
    private final AsyncCallback<OutputStreamSourceStage.AdapterToStageMessage> sendToStage;
    private final FiniteDuration writeTimeout;

    private void sendData(ByteString data) throws IOException {
        if (!this.unfulfilledDemand.tryAcquire(this.writeTimeout.toMillis(), TimeUnit.MILLISECONDS)) {
            throw new IOException("Timed out trying to write data to stream");
        }
        try {
            Await$.MODULE$.result(this.sendToStage.invokeWithFeedback(new OutputStreamSourceStage.Send(data)), this.writeTimeout);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = option.get();
                throw new IOException(e);
            }
            throw throwable;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.sendData(ByteString$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{b}), Numeric$IntIsIntegral$.MODULE$));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(b)).nonEmpty()) {
            this.sendData(ByteString$.MODULE$.fromArray(b, off, len));
            return;
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        try {
            Await$.MODULE$.result(this.sendToStage.invokeWithFeedback(OutputStreamSourceStage$Close$.MODULE$), this.writeTimeout);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = option.get();
                throw new IOException(e);
            }
            throw throwable;
        }
    }

    public OutputStreamAdapter(Semaphore unfulfilledDemand, AsyncCallback<OutputStreamSourceStage.AdapterToStageMessage> sendToStage, FiniteDuration writeTimeout) {
        this.unfulfilledDemand = unfulfilledDemand;
        this.sendToStage = sendToStage;
        this.writeTimeout = writeTimeout;
    }
}

