/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import java.util.Arrays;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.impl.Buffer;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001\u0005%vA\u0002\u0016,\u0011\u0003ySG\u0002\u00048W!\u0005q\u0006\u000f\u0005\u0006\u007f\u0005!\t!\u0011\u0005\u0007\u0005\u0006!\taL\"\u0007\u000b]\n\u0011\u0011E$\t\u0011]#!Q1A\u0005\u0002aC\u0001\u0002\u0018\u0003\u0003\u0002\u0003\u0006I!\u0017\u0005\u0006\u007f\u0011!\t!\u0018\u0005\u0006A\u0012!\t%\u0019\u0005\b[\u0012\u0011\r\u0011\"\u0003o\u0011\u0019\u0011H\u0001)A\u0005_\"91\u000f\u0002a\u0001\n#!\bb\u0002=\u0005\u0001\u0004%\t\"\u001f\u0005\u0007\u007f\u0012\u0001\u000b\u0015B;\t\u0011\u0005\u0005A\u00011A\u0005\u0012QD\u0011\"a\u0001\u0005\u0001\u0004%\t\"!\u0002\t\u000f\u0005%A\u0001)Q\u0005k\"1\u00111\u0002\u0003\u0005\u0002aCq!!\u0004\u0005\t\u0003\ty\u0001C\u0004\u0002\u0018\u0011!\t!a\u0004\t\r\u0005eA\u0001\"\u0001Y\u0011\u001d\tY\u0002\u0002C\u0001\u0003\u001fAq!!\b\u0005\t\u0003\ty\u0001C\u0004\u0002 \u0011!\t!!\t\t\u000f\u0005\u001dBA\"\u0005\u0002*!9\u00111\u0007\u0003\u0005\n\u0005U\u0002bBA\u001f\t\u0011%\u0011q\b\u0005\b\u0003\u0007\"A\u0011AA#\u0011\u001d\t9\u0005\u0002C\u0001\u0003\u000bBq!!\u0013\u0005\t\u0003\tY\u0005C\u0004\u0002N\u0011!\t!a\u0013\t\u000f\u0005=C\u0001\"\u0001\u0002L\u00199\u00111K\u0001\u0003_\u0005U\u0003BCA0A\t\u0005\t\u0015!\u0003Z\u000b!1q\b\tC\u0001\u0003CBq!a\n!\t#\n9GB\u0004\u0002n\u0005\u0011q&a\u001c\t\u0015\u0005}CE!A!\u0002\u0013IV\u0001\u0003\u0004@I\u0011\u0005\u0011\u0011\u0010\u0005\t\u0003\u007f\"#\u0019!C\u00051\"9\u0011\u0011\u0011\u0013!\u0002\u0013I\u0006bBA\u0014I\u0011E\u00131Q\u0001\u0010\r&DX\rZ*ju\u0016\u0014UO\u001a4fe*\u0011A&L\u0001\u0005S6\u0004HN\u0003\u0002/_\u000511\u000f\u001e:fC6T!\u0001M\u0019\u0002\u000bA,7n[8\u000b\u0005I\u001a\u0014AB1qC\u000eDWMC\u00015\u0003\ry'o\u001a\t\u0003m\u0005i\u0011a\u000b\u0002\u0010\r&DX\rZ*ju\u0016\u0014UO\u001a4feN\u0011\u0011!\u000f\t\u0003uuj\u0011a\u000f\u0006\u0002y\u0005)1oY1mC&\u0011ah\u000f\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012!N\u0001\u0006CB\u0004H._\u000b\u0004\t\u0006-EcA#\u0002\u000eB!a\tBAE\u001b\u0005\tQC\u0001%O'\r!\u0011(\u0013\t\u0004m)c\u0015BA&,\u0005\u0019\u0011UO\u001a4feB\u0011QJ\u0014\u0007\u0001\t\u0015yEA1\u0001Q\u0005\u0005!\u0016CA)U!\tQ$+\u0003\u0002Tw\t9aj\u001c;iS:<\u0007C\u0001\u001eV\u0013\t16HA\u0002B]f\f\u0001bY1qC\u000eLG/_\u000b\u00023B\u0011!HW\u0005\u00037n\u00121!\u00138u\u0003%\u0019\u0017\r]1dSRL\b\u0005\u0006\u0002_?B\u0019a\t\u0002'\t\u000b];\u0001\u0019A-\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012A\u0019\t\u0003G*t!\u0001\u001a5\u0011\u0005\u0015\\T\"\u00014\u000b\u0005\u001d\u0004\u0015A\u0002\u001fs_>$h(\u0003\u0002jw\u00051\u0001K]3eK\u001aL!a\u001b7\u0003\rM#(/\u001b8h\u0015\tI7(\u0001\u0004ck\u001a4WM]\u000b\u0002_B\u0019!\b]\u001d\n\u0005E\\$!B!se\u0006L\u0018a\u00022vM\u001a,'\u000fI\u0001\be\u0016\fG-\u00133y+\u0005)\bC\u0001\u001ew\u0013\t98H\u0001\u0003M_:<\u0017a\u0003:fC\u0012LE\r_0%KF$\"A_?\u0011\u0005iZ\u0018B\u0001?<\u0005\u0011)f.\u001b;\t\u000fyd\u0011\u0011!a\u0001k\u0006\u0019\u0001\u0010J\u0019\u0002\u0011I,\u0017\rZ%eq\u0002\n\u0001b\u001e:ji\u0016LE\r_\u0001\roJLG/Z%eq~#S-\u001d\u000b\u0004u\u0006\u001d\u0001b\u0002@\u0010\u0003\u0003\u0005\r!^\u0001\noJLG/Z%eq\u0002\nA!^:fI\u00061\u0011n\u001d$vY2,\"!!\u0005\u0011\u0007i\n\u0019\"C\u0002\u0002\u0016m\u0012qAQ8pY\u0016\fg.A\u0004o_:4U\u000f\u001c7\u0002#I,W.Y5oS:<7)\u00199bG&$\u00180A\u0004jg\u0016k\u0007\u000f^=\u0002\u00119|g.R7qif\fq!\u001a8rk\u0016,X\rF\u0002{\u0003GAa!!\n\u0018\u0001\u0004a\u0015\u0001B3mK6\f\u0001\u0002^8PM\u001a\u001cX\r\u001e\u000b\u00063\u0006-\u0012q\u0006\u0005\u0007\u0003[A\u0002\u0019A;\u0002\u0007%$\u0007\u0010C\u0004\u00022a\u0001\r!!\u0005\u0002\u00175\f\u0017N\u001c;f]\u0006t7-Z\u0001\u0004aV$Hc\u0002>\u00028\u0005e\u00121\b\u0005\u0007\u0003[I\u0002\u0019A;\t\r\u0005\u0015\u0012\u00041\u0001M\u0011\u001d\t\t$\u0007a\u0001\u0003#\t1aZ3u)\ra\u0015\u0011\t\u0005\u0007\u0003[Q\u0002\u0019A;\u0002\tA,Wm\u001b\u000b\u0002\u0019\u00069A-Z9vKV,\u0017!B2mK\u0006\u0014H#\u0001>\u0002\u0011\u0011\u0014x\u000e\u001d%fC\u0012\f\u0001\u0002\u001a:paR\u000b\u0017\u000e\\\u0015\u0004\t\u0001\"#!F'pIVdwNR5yK\u0012\u001c\u0016N_3Ck\u001a4WM]\u000b\u0005\u0003/\nifE\u0002!\u00033\u0002BA\u0012\u0003\u0002\\A\u0019Q*!\u0018\u0005\u000b=\u0003#\u0019\u0001)\u0002\u000b}\u001b\u0018N_3\u0015\t\u0005\r\u0014Q\r\t\u0005\r\u0002\nY\u0006\u0003\u0004\u0002`\t\u0002\r!\u0017\u000b\u00063\u0006%\u00141\u000e\u0005\u0007\u0003[\u0019\u0003\u0019A;\t\u000f\u0005E2\u00051\u0001\u0002\u0012\tI\u0002k\\<fe>3Gk^8GSb,GmU5{K\n+hMZ3s+\u0011\t\t(a\u001e\u0014\u0007\u0011\n\u0019\b\u0005\u0003G\t\u0005U\u0004cA'\u0002x\u0011)q\n\nb\u0001!R!\u00111PA?!\u00111E%!\u001e\t\r\u0005}c\u00051\u0001Z\u0003\u0011i\u0015m]6\u0002\u000b5\u000b7o\u001b\u0011\u0015\u000be\u000b))a\"\t\r\u00055\u0012\u00061\u0001v\u0011\u001d\t\t$\u000ba\u0001\u0003#\u00012!TAF\t\u0015y5A1\u0001Q\u0011\u0019\tyi\u0001a\u00013\u0006!1/\u001b>fQ\r\u0019\u00111\u0013\t\u0005\u0003+\u000bY*\u0004\u0002\u0002\u0018*\u0019\u0011\u0011T\u0018\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001e\u0006]%!E%oi\u0016\u0014h.\u00197Ti\u0006\u0014G.Z!qS\"\u001a\u0011!!)\u0011\t\u0005U\u00151U\u0005\u0005\u0003K\u000b9JA\u0006J]R,'O\\1m\u0003BL\u0007f\u0001\u0001\u0002\"\u0002")
@InternalApi
public final class FixedSizeBuffer {

    public static abstract class FixedSizeBuffer<T>
    implements Buffer<T> {
        private final int capacity;
        private final Object[] buffer;
        private long readIdx;
        private long writeIdx;

        @Override
        public int capacity() {
            return this.capacity;
        }

        public String toString() {
            return new StringBuilder(14).append("Buffer(").append(this.capacity()).append(", ").append(this.readIdx()).append(", ").append(this.writeIdx()).append(")(").append(((TraversableOnce)new RichLong(Predef$.MODULE$.longWrapper(this.readIdx())).until(BoxesRunTime.boxToLong(this.writeIdx())).map((Function1<Object, Object> & java.io.Serializable & Serializable)idx -> this.get(BoxesRunTime.unboxToLong(idx)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(", ")).append(")").toString();
        }

        private Object[] buffer() {
            return this.buffer;
        }

        public long readIdx() {
            return this.readIdx;
        }

        public void readIdx_$eq(long x$1) {
            this.readIdx = x$1;
        }

        public long writeIdx() {
            return this.writeIdx;
        }

        public void writeIdx_$eq(long x$1) {
            this.writeIdx = x$1;
        }

        @Override
        public int used() {
            return (int)(this.writeIdx() - this.readIdx());
        }

        @Override
        public boolean isFull() {
            return this.used() == this.capacity();
        }

        public boolean nonFull() {
            return this.used() < this.capacity();
        }

        public int remainingCapacity() {
            return this.capacity() - this.used();
        }

        @Override
        public boolean isEmpty() {
            return this.used() == 0;
        }

        @Override
        public boolean nonEmpty() {
            return this.used() != 0;
        }

        @Override
        public void enqueue(T elem) {
            this.put(this.writeIdx(), elem, false);
            this.writeIdx_$eq(this.writeIdx() + 1L);
        }

        public abstract int toOffset(long var1, boolean var3);

        private void put(long idx, T elem, boolean maintenance) {
            this.buffer()[this.toOffset((long)idx, (boolean)maintenance)] = elem;
        }

        private T get(long idx) {
            return (T)this.buffer()[this.toOffset(idx, false)];
        }

        @Override
        public T peek() {
            return this.get(this.readIdx());
        }

        @Override
        public T dequeue() {
            T result = this.get(this.readIdx());
            this.dropHead();
            return result;
        }

        @Override
        public void clear() {
            Arrays.fill(this.buffer(), null);
            this.readIdx_$eq(0L);
            this.writeIdx_$eq(0L);
        }

        @Override
        public void dropHead() {
            this.put(this.readIdx(), null, true);
            this.readIdx_$eq(this.readIdx() + 1L);
        }

        @Override
        public void dropTail() {
            this.writeIdx_$eq(this.writeIdx() - 1L);
            this.put(this.writeIdx(), null, false);
        }

        public FixedSizeBuffer(int capacity) {
            this.capacity = capacity;
            this.buffer = new Object[capacity];
            this.readIdx = 0L;
            this.writeIdx = 0L;
        }
    }

    public static final class ModuloFixedSizeBuffer<T>
    extends FixedSizeBuffer<T> {
        @Override
        public int toOffset(long idx, boolean maintenance) {
            block0: {
                if (!maintenance || this.readIdx() <= Integer.MAX_VALUE) break block0;
                int shift = Integer.MAX_VALUE - Integer.MAX_VALUE % this.capacity();
                this.readIdx_$eq(this.readIdx() - (long)shift);
                this.writeIdx_$eq(this.writeIdx() - (long)shift);
            }
            return (int)(idx % (long)this.capacity());
        }

        public ModuloFixedSizeBuffer(int _size) {
            super(_size);
        }
    }

    public static final class PowerOfTwoFixedSizeBuffer<T>
    extends FixedSizeBuffer<T> {
        private final int Mask = this.capacity() - 1;

        private int Mask() {
            return this.Mask;
        }

        @Override
        public int toOffset(long idx, boolean maintenance) {
            return (int)idx & this.Mask();
        }

        public PowerOfTwoFixedSizeBuffer(int _size) {
            super(_size);
        }
    }
}

