/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport.netty;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pekko.ConfigurationException;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Address$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.dispatch.Dispatchers;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.remote.RARP;
import org.apache.pekko.remote.RARP$;
import org.apache.pekko.remote.transport.AssociationHandle;
import org.apache.pekko.remote.transport.Transport;
import org.apache.pekko.remote.transport.netty.ClientHandler;
import org.apache.pekko.remote.transport.netty.NettyFutureBridge$;
import org.apache.pekko.remote.transport.netty.NettySSLSupport$;
import org.apache.pekko.remote.transport.netty.NettyTransport$;
import org.apache.pekko.remote.transport.netty.NettyTransportException;
import org.apache.pekko.remote.transport.netty.NettyTransportExceptionNoStack;
import org.apache.pekko.remote.transport.netty.NettyTransportSettings;
import org.apache.pekko.remote.transport.netty.SSLEngineProvider;
import org.apache.pekko.remote.transport.netty.TcpClientHandler;
import org.apache.pekko.remote.transport.netty.TcpServerHandler;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.OptionVal$Some$;
import org.jboss.netty.bootstrap.Bootstrap;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.DefaultChannelPipeline;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.LengthFieldPrepender;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.util.HashedWheelTimer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction1$mcVI$sp;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r5rA\u0002\u001e<\u0011\u0003itI\u0002\u0004Jw!\u0005QH\u0013\u0005\u0006#\u0006!\ta\u0015\u0005\b)\u0006\u0011\r\u0011\"\u0001V\u0011\u0019I\u0016\u0001)A\u0005-\")!,\u0001C\u00017\"9!/\u0001b\u0001\n\u0003\u0019\bBB@\u0002A\u0003%A\u000fC\u0004\u0002\u0002\u0005!\t!a\u0001\t\u000f\u0005\u0005\u0011\u0001\"\u0001\u0002R\u0019)\u0011j\u000f\u0001\u0002l!Q\u0011Q\u000f\u0006\u0003\u0006\u0004%\t!a\u001e\t\u0015\u0005}$B!A!\u0002\u0013\tI\b\u0003\u0006\u0002\u0002*\u0011)\u0019!C\u0001\u0003\u0007C!\"a#\u000b\u0005\u0003\u0005\u000b\u0011BAC\u0011\u0019\t&\u0002\"\u0001\u0002\u000e\"1\u0011K\u0003C\u0001\u0003+C\u0011\"!-\u000b\u0005\u0004%\u0019!a-\t\u000f\u0005U&\u0002)A\u0005E\"I\u0011\u0011\u0006\u0006C\u0002\u0013\u0005\u0013q\u0017\u0005\t\u0003sS\u0001\u0015!\u0003\u0002,!1\u00111\u0018\u0006\u0005BUC1\"!0\u000b\u0001\u0004\u0005\r\u0011\"\u0003\u0002@\"Y\u0011\u0011\u0019\u0006A\u0002\u0003\u0007I\u0011BAb\u0011-\tIM\u0003a\u0001\u0002\u0003\u0006K!a\u0003\t\u0017\u0005M'\u00021AA\u0002\u0013%\u0011Q\u001b\u0005\f\u0003/T\u0001\u0019!a\u0001\n\u0013\tI\u000e\u0003\u0006\u0002^*\u0001\r\u0011!Q!\n)D\u0011\"!9\u000b\u0005\u0004%I!a9\t\u0011\u0005E(\u0002)A\u0005\u0003KD!\"a=\u000b\u0005\u0004%)aOA{\u0011!\u0011YB\u0003Q\u0001\u000e\u0005]\bb\u0002B\u000f\u0015\u0011%!q\u0004\u0005\n\u0005OQ!\u0019!C\u0001\u0005SA\u0001Ba\u000e\u000bA\u0003%!1\u0006\u0005\n\u0005sQ!\u0019!C\u0005\u0005wA\u0001Ba\u0011\u000bA\u0003%!Q\b\u0005\n\u0005\u000bR!\u0019!C\u0005\u0005wA\u0001Ba\u0012\u000bA\u0003%!Q\b\u0005\b\u0005\u0013RA\u0011\u0002B&\u0011%\u0011\u0019F\u0003b\u0001\n\u0013\u0011)\u0006\u0003\u0005\u0003l)\u0001\u000b\u0011\u0002B,\u0011%\u0011iG\u0003b\u0001\n\u0013\u0011y\u0007\u0003\u0005\u0003\u0002*\u0001\u000b\u0011\u0002B9\u0011\u001d\u0011\u0019I\u0003C\u0005\u0005\u000bC\u0011B!)\u000b\u0005\u0004%IAa)\t\u0011\t-&\u0002)A\u0005\u0005KCqA!,\u000b\t\u0013\u0011y\u000bC\u0004\u00036*!IAa.\t\u0013\tu'B1A\u0005\n\t}\u0007\u0002\u0003Bq\u0015\u0001\u0006IAa3\t\u000f\t\r(\u0002\"\u0003\u0003f\"9!q\u001e\u0006\u0005B\tE\bb\u0002B|\u0015\u0011\u0005!\u0011 \u0005\b\u0007\u0013QA\u0011IB\u0006\u0011!\u0019)B\u0003C\u0001\u0003\u0006}\u0006bBB\f\u0015\u0011\u00053\u0011\u0004\u0005\b\u0007KQA\u0011IB\u0014\u00039qU\r\u001e;z)J\fgn\u001d9peRT!\u0001P\u001f\u0002\u000b9,G\u000f^=\u000b\u0005yz\u0014!\u0003;sC:\u001c\bo\u001c:u\u0015\t\u0001\u0015)\u0001\u0004sK6|G/\u001a\u0006\u0003\u0005\u000e\u000bQ\u0001]3lW>T!\u0001R#\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0015aA8sOB\u0011\u0001*A\u0007\u0002w\tqa*\u001a;usR\u0013\u0018M\\:q_J$8CA\u0001L!\tau*D\u0001N\u0015\u0005q\u0015!B:dC2\f\u0017B\u0001)N\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001H\u0003Y1%/Y7f\u0019\u0016tw\r\u001e5GS\u0016dG\rT3oORDW#\u0001,\u0011\u00051;\u0016B\u0001-N\u0005\rIe\u000e^\u0001\u0018\rJ\fW.\u001a'f]\u001e$\bNR5fY\u0012dUM\\4uQ\u0002\nQb\u001a:bG\u00164W\u000f\\\"m_N,GC\u0001/i)\ti\u0006\r\u0005\u0002M=&\u0011q,\u0014\u0002\u0005+:LG\u000fC\u0003b\u000b\u0001\u000f!-\u0001\u0002fGB\u00111MZ\u0007\u0002I*\u0011Q-T\u0001\u000bG>t7-\u001e:sK:$\u0018BA4e\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000fC\u0003j\u000b\u0001\u0007!.A\u0004dQ\u0006tg.\u001a7\u0011\u0005-\u0004X\"\u00017\u000b\u0005%l'B\u0001\u001fo\u0015\tyW)A\u0003kE>\u001c8/\u0003\u0002rY\n91\t[1o]\u0016d\u0017aD;oSF,X-\u00133D_VtG/\u001a:\u0016\u0003Q\u0004\"!^?\u000e\u0003YT!a\u001e=\u0002\r\u0005$x.\\5d\u0015\t)\u0017P\u0003\u0002{w\u0006!Q\u000f^5m\u0015\u0005a\u0018\u0001\u00026bm\u0006L!A <\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0003A)h.[9vK&#7i\\;oi\u0016\u0014\b%\u0001\rbI\u0012\u0014Xm]:Ge>l7k\\2lKR\fE\r\u001a:fgN$B\"!\u0002\u0002\u0018\u0005\u001d\u0012\u0011IA#\u0003\u0017\u0002R\u0001TA\u0004\u0003\u0017I1!!\u0003N\u0005\u0019y\u0005\u000f^5p]B!\u0011QBA\n\u001b\t\tyAC\u0002\u0002\u0012\u0005\u000bQ!Y2u_JLA!!\u0006\u0002\u0010\t9\u0011\t\u001a3sKN\u001c\bbBA\r\u0011\u0001\u0007\u00111D\u0001\u0005C\u0012$'\u000f\u0005\u0003\u0002\u001e\u0005\rRBAA\u0010\u0015\r\t\tc_\u0001\u0004]\u0016$\u0018\u0002BA\u0013\u0003?\u0011QbU8dW\u0016$\u0018\t\u001a3sKN\u001c\bbBA\u0015\u0011\u0001\u0007\u00111F\u0001\u0011g\u000eDW-\\3JI\u0016tG/\u001b4jKJ\u0004B!!\f\u0002<9!\u0011qFA\u001c!\r\t\t$T\u0007\u0003\u0003gQ1!!\u000eS\u0003\u0019a$o\\8u}%\u0019\u0011\u0011H'\u0002\rA\u0013X\rZ3g\u0013\u0011\ti$a\u0010\u0003\rM#(/\u001b8h\u0015\r\tI$\u0014\u0005\b\u0003\u0007B\u0001\u0019AA\u0016\u0003)\u0019\u0018p\u001d;f[:\u000bW.\u001a\u0005\b\u0003\u000fB\u0001\u0019AA%\u0003!Awn\u001d;OC6,\u0007#\u0002'\u0002\b\u0005-\u0002bBA'\u0011\u0001\u0007\u0011qJ\u0001\u0005a>\u0014H\u000f\u0005\u0003M\u0003\u000f1FCCA\u0003\u0003'\n)&a\u0016\u0002Z!9\u0011\u0011D\u0005A\u0002\u0005m\u0001bBA\u0015\u0013\u0001\u0007\u00111\u0006\u0005\b\u0003\u0007J\u0001\u0019AA\u0016\u0011\u001d\t9%\u0003a\u0001\u0003\u0013Bs!AA/\u0003G\n9\u0007E\u0002M\u0003?J1!!\u0019N\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0003\u0003K\n!f\u00117bgNL7\r\t:f[>$\u0018N\\4!SN\u0004C-\u001a9sK\u000e\fG/\u001a3-AU\u001cX\rI!si\u0016\u0014\u00180\t\u0002\u0002j\u0005Q\u0011i[6bAIrcG\f\u0019\u0014\t)Y\u0015Q\u000e\t\u0005\u0003_\n\t(D\u0001>\u0013\r\t\u0019(\u0010\u0002\n)J\fgn\u001d9peR\f\u0001b]3ui&twm]\u000b\u0003\u0003s\u00022\u0001SA>\u0013\r\tih\u000f\u0002\u0017\u001d\u0016$H/\u001f+sC:\u001c\bo\u001c:u'\u0016$H/\u001b8hg\u0006I1/\u001a;uS:<7\u000fI\u0001\u0007gf\u001cH/Z7\u0016\u0005\u0005\u0015\u0005\u0003BA\u0007\u0003\u000fKA!!#\u0002\u0010\t\u0019R\t\u001f;f]\u0012,G-Q2u_J\u001c\u0016p\u001d;f[\u000691/_:uK6\u0004CCBAH\u0003#\u000b\u0019\n\u0005\u0002I\u0015!9\u0011QO\bA\u0002\u0005e\u0004bBAA\u001f\u0001\u0007\u0011Q\u0011\u000b\u0007\u0003\u001f\u000b9*!'\t\u000f\u0005\u0005\u0005\u00031\u0001\u0002\u0006\"9\u00111\u0014\tA\u0002\u0005u\u0015\u0001B2p]\u001a\u0004B!a(\u0002.6\u0011\u0011\u0011\u0015\u0006\u0005\u0003G\u000b)+\u0001\u0004d_:4\u0017n\u001a\u0006\u0005\u0003O\u000bI+\u0001\u0005usB,7/\u00194f\u0015\t\tY+A\u0002d_6LA!a,\u0002\"\n11i\u001c8gS\u001e\f\u0001#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0016\u0003\t\f\u0011#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;!+\t\tY#A\ttG\",W.Z%eK:$\u0018NZ5fe\u0002\n1#\\1yS6,X\u000eU1zY>\fGMQ=uKN\fqAY8v]\u0012$v.\u0006\u0002\u0002\f\u0005Y!m\\;oIR{w\fJ3r)\ri\u0016Q\u0019\u0005\n\u0003\u000f<\u0012\u0011!a\u0001\u0003\u0017\t1\u0001\u001f\u00132\u0003!\u0011w.\u001e8e)>\u0004\u0003f\u0001\r\u0002NB\u0019A*a4\n\u0007\u0005EWJ\u0001\u0005w_2\fG/\u001b7f\u00035\u0019XM\u001d<fe\u000eC\u0017M\u001c8fYV\t!.A\ttKJ4XM]\"iC:tW\r\\0%KF$2!XAn\u0011!\t9MGA\u0001\u0002\u0004Q\u0017AD:feZ,'o\u00115b]:,G\u000e\t\u0015\u00047\u00055\u0017a\u00017pOV\u0011\u0011Q\u001d\t\u0005\u0003O\fi/\u0004\u0002\u0002j*\u0019\u00111^!\u0002\u000b\u00154XM\u001c;\n\t\u0005=\u0018\u0011\u001e\u0002\u0015\u001b\u0006\u00148.\u001a:M_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\u0002\t1|w\rI\u0001\u0013k\u0012\u00048i\u001c8oK\u000e$\u0018n\u001c8UC\ndW-\u0006\u0002\u0002xBA\u0011\u0011`A~\u00037\ty0D\u0001y\u0013\r\ti\u0010\u001f\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\b\u0003\u0002B\u0001\u0005+qAAa\u0001\u0003\u00129!!Q\u0001B\b\u001d\u0011\u00119A!\u0004\u000f\t\t%!1B\u0007\u0002\u0007&\u0011!iQ\u0005\u0003\u0001\u0006K!AP \n\u0007\tMQ(A\tBgN|7-[1uS>t\u0007*\u00198eY\u0016LAAa\u0006\u0003\u001a\t\u0019\u0002*\u00198eY\u0016,e/\u001a8u\u0019&\u001cH/\u001a8fe*\u0019!1C\u001f\u0002'U$\u0007oQ8o]\u0016\u001cG/[8o)\u0006\u0014G.\u001a\u0011\u0002+\r\u0014X-\u0019;f\u000bb,7-\u001e;peN+'O^5dKR\u0011!\u0011\u0005\t\u0005\u0003s\u0014\u0019#C\u0002\u0003&a\u0014\u0001\"\u0012=fGV$xN]\u0001\rG\"\fgN\\3m\u000fJ|W\u000f]\u000b\u0003\u0005W\u0001BA!\f\u000345\u0011!q\u0006\u0006\u0004\u0005ca\u0017!B4s_V\u0004\u0018\u0002\u0002B\u001b\u0005_\u00111\u0003R3gCVdGo\u00115b]:,Gn\u0012:pkB\fQb\u00195b]:,Gn\u0012:pkB\u0004\u0013\u0001F2mS\u0016tGo\u00115b]:,GNR1di>\u0014\u00180\u0006\u0002\u0003>A\u00191Na\u0010\n\u0007\t\u0005CN\u0001\bDQ\u0006tg.\u001a7GC\u000e$xN]=\u0002+\rd\u0017.\u001a8u\u0007\"\fgN\\3m\r\u0006\u001cGo\u001c:zA\u0005!2/\u001a:wKJ\u001c\u0005.\u00198oK24\u0015m\u0019;pef\fQc]3sm\u0016\u00148\t[1o]\u0016dg)Y2u_JL\b%A\u0006oK^\u0004\u0016\u000e]3mS:,WC\u0001B'!\rY'qJ\u0005\u0004\u0005#b'A\u0006#fM\u0006,H\u000e^\"iC:tW\r\u001c)ja\u0016d\u0017N\\3\u00025\u0005\u001c8o\\2jCRLwN\u001c'jgR,g.\u001a:Qe>l\u0017n]3\u0016\u0005\t]\u0003#B2\u0003Z\tu\u0013b\u0001B.I\n9\u0001K]8nSN,\u0007\u0003\u0002B0\u0005KrAAa\u0001\u0003b%\u0019!1M\u001f\u0002\u0013Q\u0013\u0018M\\:q_J$\u0018\u0002\u0002B4\u0005S\u0012\u0001$Q:t_\u000eL\u0017\r^5p]\u00163XM\u001c;MSN$XM\\3s\u0015\r\u0011\u0019'P\u0001\u001cCN\u001cxnY5bi&|g\u000eT5ti\u0016tWM\u001d)s_6L7/\u001a\u0011\u0002#M\u001cH.\u00128hS:,\u0007K]8wS\u0012,'/\u0006\u0002\u0003rA1!1\u000fB<\u0005wj!A!\u001e\u000b\u0005i\f\u0015\u0002\u0002B=\u0005k\u0012\u0011b\u00149uS>tg+\u00197\u0011\u0007!\u0013i(C\u0002\u0003\u0000m\u0012\u0011cU*M\u000b:<\u0017N\\3Qe>4\u0018\u000eZ3s\u0003I\u00198\u000f\\#oO&tW\r\u0015:pm&$WM\u001d\u0011\u0002\u0015M\u001cH\u000eS1oI2,'\u000f\u0006\u0003\u0003\b\n]\u0005\u0003\u0002BE\u0005'k!Aa#\u000b\t\t5%qR\u0001\u0004gNd'b\u0001BI[\u00069\u0001.\u00198eY\u0016\u0014\u0018\u0002\u0002BK\u0005\u0017\u0013!bU:m\u0011\u0006tG\r\\3s\u0011\u001d\u0011I\n\fa\u0001\u00057\u000b\u0001\"[:DY&,g\u000e\u001e\t\u0004\u0019\nu\u0015b\u0001BP\u001b\n9!i\\8mK\u0006t\u0017!F:feZ,'\u000fU5qK2Lg.\u001a$bGR|'/_\u000b\u0003\u0005K\u00032a\u001bBT\u0013\r\u0011I\u000b\u001c\u0002\u0017\u0007\"\fgN\\3m!&\u0004X\r\\5oK\u001a\u000b7\r^8ss\u000612/\u001a:wKJ\u0004\u0016\u000e]3mS:,g)Y2u_JL\b%A\u000bdY&,g\u000e\u001e)ja\u0016d\u0017N\\3GC\u000e$xN]=\u0015\t\t\u0015&\u0011\u0017\u0005\b\u0005g{\u0003\u0019AA\u0006\u00035\u0011X-\\8uK\u0006#GM]3tg\u0006q1/\u001a;va\n{w\u000e^:ue\u0006\u0004X\u0003\u0002B]\u0005\u007f#bAa/\u0003X\ne\u0007\u0003\u0002B_\u0005\u007fc\u0001\u0001B\u0004\u0003BB\u0012\rAa1\u0003\u0003\t\u000bBA!2\u0003LB\u0019AJa2\n\u0007\t%WJA\u0004O_RD\u0017N\\4\u0011\t\t5'1[\u0007\u0003\u0005\u001fT1A!5n\u0003%\u0011wn\u001c;tiJ\f\u0007/\u0003\u0003\u0003V\n='!\u0003\"p_R\u001cHO]1q\u0011\u001d\u0011\t\u000e\ra\u0001\u0005wCqAa71\u0001\u0004\u0011)+A\bqSB,G.\u001b8f\r\u0006\u001cGo\u001c:z\u0003AIgNY8v]\u0012\u0014un\u001c;tiJ\f\u0007/\u0006\u0002\u0003L\u0006\t\u0012N\u001c2pk:$'i\\8ugR\u0014\u0018\r\u001d\u0011\u0002#=,HOY8v]\u0012\u0014un\u001c;tiJ\f\u0007\u000f\u0006\u0003\u0003h\n5\b\u0003\u0002Bg\u0005SLAAa;\u0003P\ny1\t\\5f]R\u0014un\u001c;tiJ\f\u0007\u000fC\u0004\u00034N\u0002\r!a\u0003\u0002!%\u001c(+Z:q_:\u001c\u0018N\u00197f\r>\u0014H\u0003\u0002BN\u0005gDqA!>5\u0001\u0004\tY!A\u0004bI\u0012\u0014Xm]:\u0002-\u0005$GM]3tgR{7k\\2lKR\fE\r\u001a:fgN$BAa?\u0004\bA)1M!@\u0004\u0002%\u0019!q 3\u0003\r\u0019+H/\u001e:f!\u0011\tiba\u0001\n\t\r\u0015\u0011q\u0004\u0002\u0012\u0013:,GoU8dW\u0016$\u0018\t\u001a3sKN\u001c\bbBA\rk\u0001\u0007\u00111B\u0001\u0007Y&\u001cH/\u001a8\u0016\u0005\r5\u0001#B2\u0003~\u000e=\u0001c\u0002'\u0004\u0012\u0005-!qK\u0005\u0004\u0007'i%A\u0002+va2,''\u0001\u0007c_VtG-\u00113ee\u0016\u001c8/A\u0005bgN|7-[1uKR!11DB\u0012!\u0015\u0019'Q`B\u000f!\u0011\tyga\b\n\u0007\r\u0005RHA\tBgN|7-[1uS>t\u0007*\u00198eY\u0016DqAa-9\u0001\u0004\tY!\u0001\u0005tQV$Hm\\<o)\t\u0019I\u0003E\u0003d\u0005{\u0014Y\nK\u0004\u000b\u0003;\n\u0019'a\u001a")
public class NettyTransport
implements Transport {
    private final NettyTransportSettings settings;
    private final ExtendedActorSystem system;
    private final ExecutionContext executionContext;
    private final String schemeIdentifier;
    private volatile Address boundTo;
    private volatile Channel serverChannel;
    private final MarkerLoggingAdapter org$apache$pekko$remote$transport$netty$NettyTransport$$log;
    private final ConcurrentHashMap<SocketAddress, AssociationHandle.HandleEventListener> udpConnectionTable;
    private final DefaultChannelGroup channelGroup;
    private final ChannelFactory clientChannelFactory;
    private final ChannelFactory serverChannelFactory;
    private final Promise<Transport.AssociationEventListener> org$apache$pekko$remote$transport$netty$NettyTransport$$associationListenerPromise;
    private final SSLEngineProvider sslEngineProvider;
    private final ChannelPipelineFactory serverPipelineFactory;
    private final Bootstrap inboundBootstrap;

    public static Option<Address> addressFromSocketAddress(SocketAddress socketAddress, String string, String string2, Option<String> option) {
        return NettyTransport$.MODULE$.addressFromSocketAddress(socketAddress, string, string2, option);
    }

    public static Option<Address> addressFromSocketAddress(SocketAddress socketAddress, String string, String string2, Option<String> option, Option<Object> option2) {
        return NettyTransport$.MODULE$.addressFromSocketAddress(socketAddress, string, string2, option, option2);
    }

    public static AtomicInteger uniqueIdCounter() {
        return NettyTransport$.MODULE$.uniqueIdCounter();
    }

    public static void gracefulClose(Channel channel, ExecutionContext executionContext) {
        NettyTransport$.MODULE$.gracefulClose(channel, executionContext);
    }

    public static int FrameLengthFieldLength() {
        return NettyTransport$.MODULE$.FrameLengthFieldLength();
    }

    @Override
    public Future<Object> managementCommand(Object cmd) {
        return Transport.managementCommand$(this, cmd);
    }

    public NettyTransportSettings settings() {
        return this.settings;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public String schemeIdentifier() {
        return this.schemeIdentifier;
    }

    @Override
    public int maximumPayloadBytes() {
        return this.settings().MaxFrameSize();
    }

    private Address boundTo() {
        return this.boundTo;
    }

    private void boundTo_$eq(Address x$1) {
        this.boundTo = x$1;
    }

    private Channel serverChannel() {
        return this.serverChannel;
    }

    private void serverChannel_$eq(Channel x$1) {
        this.serverChannel = x$1;
    }

    public MarkerLoggingAdapter org$apache$pekko$remote$transport$netty$NettyTransport$$log() {
        return this.org$apache$pekko$remote$transport$netty$NettyTransport$$log;
    }

    public final ConcurrentHashMap<SocketAddress, AssociationHandle.HandleEventListener> udpConnectionTable() {
        return this.udpConnectionTable;
    }

    private Executor createExecutorService() {
        Dispatchers dispatchers = this.system().dispatchers();
        return (Executor)this.settings().UseDispatcherForIo().map((Function1<String, MessageDispatcher> & Serializable & scala.Serializable)id -> dispatchers.lookup((String)id)).getOrElse((Function0<ExecutorService> & Serializable & scala.Serializable)() -> Executors.newCachedThreadPool(this.system().threadFactory()));
    }

    public DefaultChannelGroup channelGroup() {
        return this.channelGroup;
    }

    private ChannelFactory clientChannelFactory() {
        return this.clientChannelFactory;
    }

    private ChannelFactory serverChannelFactory() {
        return this.serverChannelFactory;
    }

    public DefaultChannelPipeline org$apache$pekko$remote$transport$netty$NettyTransport$$newPipeline() {
        DefaultChannelPipeline pipeline = new DefaultChannelPipeline();
        pipeline.addLast("FrameDecoder", new LengthFieldBasedFrameDecoder(this.maximumPayloadBytes(), 0, NettyTransport$.MODULE$.FrameLengthFieldLength(), 0, NettyTransport$.MODULE$.FrameLengthFieldLength(), true));
        pipeline.addLast("FrameEncoder", new LengthFieldPrepender(NettyTransport$.MODULE$.FrameLengthFieldLength()));
        return pipeline;
    }

    public Promise<Transport.AssociationEventListener> org$apache$pekko$remote$transport$netty$NettyTransport$$associationListenerPromise() {
        return this.org$apache$pekko$remote$transport$netty$NettyTransport$$associationListenerPromise;
    }

    private SSLEngineProvider sslEngineProvider() {
        return this.sslEngineProvider;
    }

    public SslHandler org$apache$pekko$remote$transport$netty$NettyTransport$$sslHandler(boolean isClient) {
        SSLEngineProvider sSLEngineProvider = this.sslEngineProvider();
        SSLEngineProvider sSLEngineProvider2 = OptionVal$Some$.MODULE$.unapply(sSLEngineProvider);
        if (!OptionVal$.MODULE$.isEmpty$extension(sSLEngineProvider2)) {
            SSLEngineProvider sslProvider = OptionVal$.MODULE$.get$extension(sSLEngineProvider2);
            SslHandler handler = NettySSLSupport$.MODULE$.apply(sslProvider, isClient);
            handler.setCloseOnSSLException(true);
            return handler;
        }
        throw new IllegalStateException("Expected enable-ssl=on");
    }

    private ChannelPipelineFactory serverPipelineFactory() {
        return this.serverPipelineFactory;
    }

    private ChannelPipelineFactory clientPipelineFactory(Address remoteAddress) {
        return new ChannelPipelineFactory(this, remoteAddress){
            private final /* synthetic */ NettyTransport $outer;
            private final Address remoteAddress$1;

            public ChannelPipeline getPipeline() {
                DefaultChannelPipeline pipeline = this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$newPipeline();
                if (this.$outer.settings().EnableSsl()) {
                    pipeline.addFirst("SslHandler", this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$sslHandler(true));
                }
                TcpClientHandler handler = new TcpClientHandler(this.$outer, this.remoteAddress$1, this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$log());
                pipeline.addLast("clienthandler", handler);
                return pipeline;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.remoteAddress$1 = remoteAddress$1;
            }
        };
    }

    private <B extends Bootstrap> B setupBootstrap(B bootstrap, ChannelPipelineFactory pipelineFactory) {
        bootstrap.setPipelineFactory(pipelineFactory);
        bootstrap.setOption("backlog", BoxesRunTime.boxToInteger(this.settings().Backlog()));
        bootstrap.setOption("child.tcpNoDelay", BoxesRunTime.boxToBoolean(this.settings().TcpNodelay()));
        bootstrap.setOption("child.keepAlive", BoxesRunTime.boxToBoolean(this.settings().TcpKeepalive()));
        bootstrap.setOption("reuseAddress", BoxesRunTime.boxToBoolean(this.settings().TcpReuseAddr()));
        this.settings().ReceiveBufferSize().foreach((JFunction1$mcVI$sp & scala.Serializable)sz -> bootstrap.setOption("receiveBufferSize", BoxesRunTime.boxToInteger(sz)));
        this.settings().SendBufferSize().foreach((JFunction1$mcVI$sp & scala.Serializable)sz -> bootstrap.setOption("sendBufferSize", BoxesRunTime.boxToInteger(sz)));
        this.settings().WriteBufferHighWaterMark().foreach((JFunction1$mcVI$sp & scala.Serializable)sz -> bootstrap.setOption("writeBufferHighWaterMark", BoxesRunTime.boxToInteger(sz)));
        this.settings().WriteBufferLowWaterMark().foreach((JFunction1$mcVI$sp & scala.Serializable)sz -> bootstrap.setOption("writeBufferLowWaterMark", BoxesRunTime.boxToInteger(sz)));
        return bootstrap;
    }

    private Bootstrap inboundBootstrap() {
        return this.inboundBootstrap;
    }

    private ClientBootstrap outboundBootstrap(Address remoteAddress) {
        ClientBootstrap bootstrap = this.setupBootstrap(new ClientBootstrap(this.clientChannelFactory()), this.clientPipelineFactory(remoteAddress));
        bootstrap.setOption("connectTimeoutMillis", BoxesRunTime.boxToLong(this.settings().ConnectionTimeout().toMillis()));
        bootstrap.setOption("tcpNoDelay", BoxesRunTime.boxToBoolean(this.settings().TcpNodelay()));
        bootstrap.setOption("keepAlive", BoxesRunTime.boxToBoolean(this.settings().TcpKeepalive()));
        this.settings().ReceiveBufferSize().foreach((JFunction1$mcVI$sp & scala.Serializable)sz -> bootstrap.setOption("receiveBufferSize", BoxesRunTime.boxToInteger(sz)));
        this.settings().SendBufferSize().foreach((JFunction1$mcVI$sp & scala.Serializable)sz -> bootstrap.setOption("sendBufferSize", BoxesRunTime.boxToInteger(sz)));
        this.settings().WriteBufferHighWaterMark().foreach((JFunction1$mcVI$sp & scala.Serializable)sz -> bootstrap.setOption("writeBufferHighWaterMark", BoxesRunTime.boxToInteger(sz)));
        this.settings().WriteBufferLowWaterMark().foreach((JFunction1$mcVI$sp & scala.Serializable)sz -> bootstrap.setOption("writeBufferLowWaterMark", BoxesRunTime.boxToInteger(sz)));
        return bootstrap;
    }

    @Override
    public boolean isResponsibleFor(Address address) {
        return true;
    }

    public Future<InetSocketAddress> addressToSocketAddress(Address addr) {
        Address address = addr;
        if (address != null) {
            Option<String> option = address.host();
            Option<Object> option2 = address.port();
            if (option instanceof Some) {
                Some some = (Some)option;
                String host = (String)some.value();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    int port = BoxesRunTime.unboxToInt(some2.value());
                    return Future$.MODULE$.apply((Function0<InetSocketAddress> & Serializable & scala.Serializable)() -> (InetSocketAddress)package$.MODULE$.blocking((Function0<InetSocketAddress> & Serializable & scala.Serializable)() -> new InetSocketAddress(InetAddress.getByName(host), port)), this.executionContext());
                }
            }
        }
        return Future$.MODULE$.failed(new IllegalArgumentException(new StringBuilder(53).append("Address [").append(addr).append("] does not contain host or port information.").toString()));
    }

    @Override
    public Future<Tuple2<Address, Promise<Transport.AssociationEventListener>>> listen() {
        int bindPort = this.settings().BindPortSelector();
        return this.addressToSocketAddress(Address$.MODULE$.apply("", "", this.settings().BindHostname(), bindPort)).map((Function1<InetSocketAddress, Tuple2> & Serializable & scala.Serializable)address -> {
            Tuple2<Address, Promise<Transport.AssociationEventListener>> tuple2;
            try {
                Address address2;
                Channel channel;
                Bootstrap bootstrap = this.inboundBootstrap();
                if (bootstrap instanceof ServerBootstrap) {
                    ServerBootstrap serverBootstrap = (ServerBootstrap)bootstrap;
                    channel = serverBootstrap.bind((SocketAddress)address);
                } else if (bootstrap instanceof ConnectionlessBootstrap) {
                    ConnectionlessBootstrap connectionlessBootstrap = (ConnectionlessBootstrap)bootstrap;
                    channel = connectionlessBootstrap.bind((SocketAddress)address);
                } else {
                    throw new IllegalStateException();
                }
                Channel newServerChannel = channel;
                newServerChannel.setReadable(false);
                this.channelGroup().add(newServerChannel);
                this.serverChannel_$eq(newServerChannel);
                Option port = this.settings().PortSelector() == 0 ? None$.MODULE$ : new Some<Integer>(BoxesRunTime.boxToInteger(this.settings().PortSelector()));
                Option<Address> option = NettyTransport$.MODULE$.addressFromSocketAddress(newServerChannel.getLocalAddress(), this.schemeIdentifier(), this.system().name(), new Some<String>(this.settings().Hostname()), port);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    address2 = (Address)some.value();
                    Option<Address> option2 = NettyTransport$.MODULE$.addressFromSocketAddress(newServerChannel.getLocalAddress(), this.schemeIdentifier(), this.system().name(), None$.MODULE$, None$.MODULE$);
                    if (!(option2 instanceof Some)) {
                        if (None$.MODULE$.equals(option2)) {
                            throw new NettyTransportException(new StringBuilder(29).append("Unknown local address type [").append(newServerChannel.getLocalAddress().getClass().getName()).append("]").toString());
                        }
                        throw new MatchError(option2);
                    }
                    Some some2 = (Some)option2;
                    Address address3 = (Address)some2.value();
                    this.boundTo_$eq(address3);
                } else {
                    if (None$.MODULE$.equals(option)) {
                        throw new NettyTransportException(new StringBuilder(29).append("Unknown local address type [").append(newServerChannel.getLocalAddress().getClass().getName()).append("]").toString());
                    }
                    throw new MatchError(option);
                }
                this.org$apache$pekko$remote$transport$netty$NettyTransport$$associationListenerPromise().future().foreach((Function1<Transport.AssociationEventListener, ChannelFuture> & Serializable & scala.Serializable)x$2 -> newServerChannel.setReadable(true), this.executionContext());
                tuple2 = new Tuple2<Address, Promise<Transport.AssociationEventListener>>(address2, this.org$apache$pekko$remote$transport$netty$NettyTransport$$associationListenerPromise());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e;
                    block15: {
                        Object object;
                        e = option.get();
                        this.org$apache$pekko$remote$transport$netty$NettyTransport$$log().error("failed to bind to {}, shutting down Netty transport", address);
                        try {
                            object = this.shutdown();
                        }
                        catch (Throwable throwable3) {
                            Throwable throwable4 = throwable3;
                            Option<Throwable> option3 = NonFatal$.MODULE$.unapply(throwable4);
                            if (!option3.isEmpty()) {
                                object = BoxedUnit.UNIT;
                                break block15;
                            }
                            throw throwable3;
                        }
                    }
                    throw e;
                }
                throw throwable;
            }
            return tuple2;
        }, this.executionContext());
    }

    public Address boundAddress() {
        return this.boundTo();
    }

    @Override
    public Future<AssociationHandle> associate(Address remoteAddress) {
        if (!this.serverChannel().isBound()) {
            return Future$.MODULE$.failed(new NettyTransportException("Transport is not bound"));
        }
        ClientBootstrap bootstrap = this.outboundBootstrap(remoteAddress);
        return this.addressToSocketAddress(remoteAddress).flatMap((Function1<InetSocketAddress, Future> & Serializable & scala.Serializable)socketAddress -> NettyFutureBridge$.MODULE$.apply(bootstrap.connect((SocketAddress)socketAddress)).map((Function1<Channel, Channel> & Serializable & scala.Serializable)channel -> {
            BoxedUnit boxedUnit = this.settings().EnableSsl() ? package$.MODULE$.blocking((Function0<ChannelFuture> & Serializable & scala.Serializable)() -> channel.getPipeline().get(SslHandler.class).handshake().awaitUninterruptibly()) : BoxedUnit.UNIT;
            channel.setReadable(false);
            return channel;
        }, this.executionContext()).flatMap((Function1<Channel, Future> & Serializable & scala.Serializable)readyChannel -> readyChannel.getPipeline().get(ClientHandler.class).statusFuture().map((Function1<AssociationHandle, AssociationHandle> & Serializable & scala.Serializable)handle -> handle, this.executionContext()), this.executionContext()), this.executionContext()).recover(new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof CancellationException) {
                    throw new NettyTransportExceptionNoStack("Connection was cancelled");
                }
                Option<Throwable> option = NonFatal$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    Throwable t = option.get();
                    String msg = t.getCause() == null ? t.getMessage() : (t.getCause().getCause() == null ? new StringBuilder(13).append(t.getMessage()).append(", caused by: ").append(t.getCause()).toString() : new StringBuilder(26).append(t.getMessage()).append(", caused by: ").append(t.getCause()).append(", caused by: ").append(t.getCause().getCause()).toString());
                    throw new NettyTransportExceptionNoStack(new StringBuilder(2).append(t.getClass().getName()).append(": ").append(msg).toString(), t.getCause());
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                if (throwable instanceof CancellationException) {
                    return true;
                }
                Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable);
                return !option.isEmpty();
            }
        }, this.executionContext());
    }

    @Override
    public Future<Object> shutdown() {
        return this.always$2(this.channelGroup().unbind()).flatMap((Function1<Object, Future> & Serializable & scala.Serializable)unbindStatus -> NettyTransport.$anonfun$shutdown$2(this, BoxesRunTime.unboxToBoolean(unbindStatus)), this.executionContext());
    }

    public static final /* synthetic */ boolean $anonfun$shutdown$1(ChannelGroup x$3) {
        return true;
    }

    private final Future always$2(ChannelGroupFuture c) {
        return NettyFutureBridge$.MODULE$.apply(c).map((Function1<ChannelGroup, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean(NettyTransport.$anonfun$shutdown$1(x$3)), this.executionContext()).recover(new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                return (B1)BoxesRunTime.boxToBoolean(false);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
        }, this.executionContext());
    }

    public static final /* synthetic */ boolean $anonfun$shutdown$5(NettyTransport $this, boolean lastWriteStatus$1, boolean unbindStatus$1, boolean disconnectStatus$1, boolean closeStatus) {
        if ($this.settings().UseDispatcherForIo().isDefined()) {
            $this.clientChannelFactory().shutdown();
            $this.serverChannelFactory().shutdown();
        } else {
            $this.clientChannelFactory().releaseExternalResources();
            $this.serverChannelFactory().releaseExternalResources();
        }
        return lastWriteStatus$1 && unbindStatus$1 && disconnectStatus$1 && closeStatus;
    }

    public static final /* synthetic */ Future $anonfun$shutdown$4(NettyTransport $this, boolean lastWriteStatus$1, boolean unbindStatus$1, boolean disconnectStatus) {
        return $this.always$2($this.channelGroup().close()).map((Function1<Object, Object> & Serializable & scala.Serializable)closeStatus -> BoxesRunTime.boxToBoolean(NettyTransport.$anonfun$shutdown$5($this, lastWriteStatus$1, unbindStatus$1, disconnectStatus, BoxesRunTime.unboxToBoolean(closeStatus))), $this.executionContext());
    }

    public static final /* synthetic */ Future $anonfun$shutdown$3(NettyTransport $this, boolean unbindStatus$1, boolean lastWriteStatus) {
        return $this.always$2($this.channelGroup().disconnect()).flatMap((Function1<Object, Future> & Serializable & scala.Serializable)disconnectStatus -> NettyTransport.$anonfun$shutdown$4($this, lastWriteStatus, unbindStatus$1, BoxesRunTime.unboxToBoolean(disconnectStatus)), $this.executionContext());
    }

    public static final /* synthetic */ Future $anonfun$shutdown$2(NettyTransport $this, boolean unbindStatus) {
        return $this.always$2($this.channelGroup().write(ChannelBuffers.buffer(0))).flatMap((Function1<Object, Future> & Serializable & scala.Serializable)lastWriteStatus -> NettyTransport.$anonfun$shutdown$3($this, unbindStatus, BoxesRunTime.unboxToBoolean(lastWriteStatus)), $this.executionContext());
    }

    public NettyTransport(NettyTransportSettings settings, ExtendedActorSystem system) {
        SSLEngineProvider sSLEngineProvider;
        this.settings = settings;
        this.system = system;
        Transport.$init$(this);
        Dispatchers dispatchers = system.dispatchers();
        this.executionContext = (ExecutionContext)settings.UseDispatcherForIo().orElse((Function0<Option> & Serializable & scala.Serializable)() -> {
            String string = ((RARP)RARP$.MODULE$.apply(this.system())).provider().remoteSettings().Dispatcher();
            if ("".equals(string)) {
                return None$.MODULE$;
            }
            return new Some<String>(string);
        }).map((Function1<String, MessageDispatcher> & Serializable & scala.Serializable)id -> dispatchers.lookup((String)id)).getOrElse((Function0<ExecutionContextExecutor> & Serializable & scala.Serializable)() -> this.system().dispatcher());
        this.schemeIdentifier = new StringBuilder(3).append(settings.EnableSsl() ? "ssl." : "").append("tcp").toString();
        this.org$apache$pekko$remote$transport$netty$NettyTransport$$log = Logging$.MODULE$.withMarker(system, NettyTransport.class, LogSource$.MODULE$.fromAnyClass());
        this.udpConnectionTable = new ConcurrentHashMap();
        this.channelGroup = new DefaultChannelGroup(new StringBuilder(42).append("pekko-netty-transport-driver-channelgroup-").append(NettyTransport$.MODULE$.uniqueIdCounter().getAndIncrement()).toString());
        Executor boss = this.createExecutorService();
        Executor worker = this.createExecutorService();
        this.clientChannelFactory = new NioClientSocketChannelFactory(boss, 1, new NioWorkerPool(worker, settings.ClientSocketWorkerPoolSize()), new HashedWheelTimer(system.threadFactory()));
        Executor boss2 = this.createExecutorService();
        Executor worker2 = this.createExecutorService();
        this.serverChannelFactory = new NioServerSocketChannelFactory(boss2, worker2, settings.ServerSocketWorkerPoolSize());
        this.org$apache$pekko$remote$transport$netty$NettyTransport$$associationListenerPromise = Promise$.MODULE$.apply();
        if (settings.EnableSsl()) {
            sSLEngineProvider = (SSLEngineProvider)((Object)OptionVal$Some$.MODULE$.apply(system.dynamicAccess().createInstanceFor(settings.SSLEngineProviderClassName(), new $colon$colon<Nothing$>((Nothing$)((Object)new Tuple2<Class<ActorSystem>, ExtendedActorSystem>(ActorSystem.class, system)), Nil$.MODULE$), ClassTag$.MODULE$.apply(SSLEngineProvider.class)).recover(new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ NettyTransport $outer;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    throw new ConfigurationException(new StringBuilder(37).append("Could not create SSLEngineProvider [").append(this.$outer.settings().SSLEngineProviderClassName()).append("]").toString(), A1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    return true;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }).get()));
        } else {
            OptionVal$.MODULE$.None();
            sSLEngineProvider = null;
        }
        this.sslEngineProvider = sSLEngineProvider;
        this.serverPipelineFactory = new ChannelPipelineFactory(this){
            private final /* synthetic */ NettyTransport $outer;

            public ChannelPipeline getPipeline() {
                DefaultChannelPipeline pipeline = this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$newPipeline();
                if (this.$outer.settings().EnableSsl()) {
                    pipeline.addFirst("SslHandler", this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$sslHandler(false));
                }
                TcpServerHandler handler = new TcpServerHandler(this.$outer, this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$associationListenerPromise().future(), this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$log());
                pipeline.addLast("ServerHandler", handler);
                return pipeline;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.inboundBootstrap = this.setupBootstrap(new ServerBootstrap(this.serverChannelFactory()), this.serverPipelineFactory());
    }

    public NettyTransport(ExtendedActorSystem system, Config conf) {
        this(new NettyTransportSettings(conf), system);
    }
}

