/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.serialization;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LogMarker$;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.remote.WireFormats;
import org.apache.pekko.remote.serialization.ProtobufSerializer$;
import org.apache.pekko.serialization.BaseSerializer;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.util.ccompat.package$JavaConverters$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenMap;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005}x!B\u000e\u001d\u0011\u00039c!B\u0015\u001d\u0011\u0003Q\u0003\"B\u0019\u0002\t\u0003\u0011\u0004bB\u001a\u0002\u0005\u0004%I\u0001\u000e\u0005\u0007\u000b\u0006\u0001\u000b\u0011B\u001b\t\u000b5\u000bA\u0011\u0001(\t\u000b\r\fA\u0011\u00013\u0007\t%b\u0002\u0001\u001c\u0005\tM\u001e\u0011)\u0019!C\u0001e\"A1o\u0002B\u0001B\u0003%q\rC\u00032\u000f\u0011\u0005A\u000fC\u0004x\u000f\t\u0007I\u0011\u0002=\t\u000f\u0005\u0005r\u0001)A\u0005s\"I\u0011qF\u0004C\u0002\u0013%\u0011\u0011\u0007\u0005\t\u0003\u0003:\u0001\u0015!\u0003\u00024!I\u00111I\u0004C\u0002\u0013%\u0011Q\t\u0005\t\u0003G:\u0001\u0015!\u0003\u0002H!IQd\u0002EC\u0002\u0013%\u0011Q\r\u0005\n\u0003[:!\u0019!C\u0005\u0003_B\u0001\"! \bA\u0003%\u0011\u0011\u000f\u0005\b\u0003\u007f:A\u0011IAA\u0011\u001d\tIi\u0002C!\u0003\u0017Cq!a,\b\t\u0003\n\t\fC\u0004\u00028\u001e!I!!/\t\u000f\u0005=w\u0001\"\u0003\u0002R\"9\u0011q\\\u0004\u0005\n\u0005\u0005\bbBAx\u000f\u0011%\u0011\u0011_\u0001\u0013!J|Go\u001c2vMN+'/[1mSj,'O\u0003\u0002\u001e=\u0005i1/\u001a:jC2L'0\u0019;j_:T!a\b\u0011\u0002\rI,Wn\u001c;f\u0015\t\t#%A\u0003qK.\\wN\u0003\u0002$I\u00051\u0011\r]1dQ\u0016T\u0011!J\u0001\u0004_J<7\u0001\u0001\t\u0003Q\u0005i\u0011\u0001\b\u0002\u0013!J|Go\u001c2vMN+'/[1mSj,'o\u0005\u0002\u0002WA\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0014\u0002'\u0005\u0013&+Q-`\u001f\u001a{&)\u0017+F?\u0006\u0013&+Q-\u0016\u0003U\u00022\u0001\f\u001c9\u0013\t9TFA\u0003BeJ\f\u0017\u0010\r\u0002:\u0007B\u0019!hP!\u000e\u0003mR!\u0001P\u001f\u0002\t1\fgn\u001a\u0006\u0002}\u0005!!.\u0019<b\u0013\t\u00015HA\u0003DY\u0006\u001c8\u000f\u0005\u0002C\u00072\u0001A!\u0003#\u0005\u0003\u0003\u0005\tQ!\u0001G\u0005\ryF%M\u0001\u0015\u0003J\u0013\u0016)W0P\r~\u0013\u0015\fV#`\u0003J\u0013\u0016)\u0017\u0011\u0012\u0005\u001dS\u0005C\u0001\u0017I\u0013\tIUFA\u0004O_RD\u0017N\\4\u0011\u00051Z\u0015B\u0001'.\u0005\r\te._\u0001\u0012g\u0016\u0014\u0018.\u00197ju\u0016\f5\r^8s%\u00164GCA(\\!\t\u0001\u0006L\u0004\u0002R-:\u0011!+\u0016\b\u0003'Rk\u0011AI\u0005\u0003C\tJ!a\b\u0011\n\u0005]s\u0012aC,je\u00164uN]7biNL!!\u0017.\u0003\u0019\u0005\u001bGo\u001c:SK\u001a$\u0015\r^1\u000b\u0005]s\u0002\"\u0002/\u0006\u0001\u0004i\u0016a\u0001:fMB\u0011a,Y\u0007\u0002?*\u0011\u0001\rI\u0001\u0006C\u000e$xN]\u0005\u0003E~\u0013\u0001\"Q2u_J\u0014VMZ\u0001\u0014I\u0016\u001cXM]5bY&TX-Q2u_J\u0014VM\u001a\u000b\u0004;\u0016T\u0007\"\u00024\u0007\u0001\u00049\u0017AB:zgR,W\u000e\u0005\u0002_Q&\u0011\u0011n\u0018\u0002\u0014\u000bb$XM\u001c3fI\u0006\u001bGo\u001c:TsN$X-\u001c\u0005\u0006W\u001a\u0001\raT\u0001\fe\u00164\u0007K]8u_\u000e|GnE\u0002\bW5\u0004\"A\u001c9\u000e\u0003=T!!\b\u0011\n\u0005E|'A\u0004\"bg\u0016\u001cVM]5bY&TXM]\u000b\u0002O\u000691/_:uK6\u0004CCA;w!\tAs\u0001C\u0003g\u0015\u0001\u0007q-A\fqCJ\u001c\u0018N\\4NKRDw\u000e\u001a\"j]\u0012Lgn\u001a*fMV\t\u0011\u0010E\u0003{\u0003\u0007\t9!D\u0001|\u0015\taX0\u0001\u0004bi>l\u0017n\u0019\u0006\u0003}~\f!bY8oGV\u0014(/\u001a8u\u0015\r\t\t!P\u0001\u0005kRLG.C\u0002\u0002\u0006m\u0014q\"\u0011;p[&\u001c'+\u001a4fe\u0016t7-\u001a\t\t\u0003\u0013\t\u0019\"a\u0006\u0002$5\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!A\u0005j[6,H/\u00192mK*\u0019\u0011\u0011C\u0017\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0016\u0005-!aA'baB\"\u0011\u0011DA\u000f!\u0011Qt(a\u0007\u0011\u0007\t\u000bi\u0002\u0002\u0006\u0002 1\t\t\u0011!A\u0003\u0002\u0019\u00131a\u0018\u00133\u0003a\u0001\u0018M]:j]\u001elU\r\u001e5pI\nKg\u000eZ5oOJ+g\r\t\t\u0005\u0003K\tY#\u0004\u0002\u0002()\u0019\u0011\u0011F\u001e\u0002\u000fI,g\r\\3di&!\u0011QFA\u0014\u0005\u0019iU\r\u001e5pI\u0006YBo\u001c\"zi\u0016\f%O]1z\u001b\u0016$\bn\u001c3CS:$\u0017N\\4SK\u001a,\"!a\r\u0011\u000bi\f\u0019!!\u000e\u0011\u0011\u0005%\u00111CA\u001c\u0003G\u0001D!!\u000f\u0002>A!!hPA\u001e!\r\u0011\u0015Q\b\u0003\u000b\u0003\u007fq\u0011\u0011!A\u0001\u0006\u00031%aA0%g\u0005aBo\u001c\"zi\u0016\f%O]1z\u001b\u0016$\bn\u001c3CS:$\u0017N\\4SK\u001a\u0004\u0013!E1mY><X\rZ\"mCN\u001ch*Y7fgV\u0011\u0011q\t\t\u0007\u0003\u0013\n9&!\u0018\u000f\t\u0005-\u00131\u000b\t\u0004\u0003\u001bjSBAA(\u0015\r\t\tFJ\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005US&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00033\nYFA\u0002TKRT1!!\u0016.!\u0011\tI%a\u0018\n\t\u0005\u0005\u00141\f\u0002\u0007'R\u0014\u0018N\\4\u0002%\u0005dGn\\<fI\u000ec\u0017m]:OC6,7\u000fI\u000b\u0003\u0003O\u00022A\\A5\u0013\r\tYg\u001c\u0002\u000e'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u0002\u00071|w-\u0006\u0002\u0002rA!\u00111OA=\u001b\t\t)HC\u0002\u0002x\u0001\nQ!\u001a<f]RLA!a\u001f\u0002v\t!R*\u0019:lKJdunZ4j]\u001e\fE-\u00199uKJ\fA\u0001\\8hA\u0005y\u0011N\\2mk\u0012,W*\u00198jM\u0016\u001cH/\u0006\u0002\u0002\u0004B\u0019A&!\"\n\u0007\u0005\u001dUFA\u0004C_>dW-\u00198\u0002\u0015\u0019\u0014x.\u001c\"j]\u0006\u0014\u0018\u0010F\u0003,\u0003\u001b\u000bI\nC\u0004\u0002\u0010V\u0001\r!!%\u0002\u000b\tLH/Z:\u0011\t12\u00141\u0013\t\u0004Y\u0005U\u0015bAAL[\t!!)\u001f;f\u0011\u001d\tY*\u0006a\u0001\u0003;\u000b\u0001\"\\1oS\u001a,7\u000f\u001e\t\u0006Y\u0005}\u00151U\u0005\u0004\u0003Ck#AB(qi&|g\u000e\r\u0003\u0002&\u0006-\u0006CBA%\u0003O\u000bI+C\u0002A\u00037\u00022AQAV\t-\ti+!'\u0002\u0002\u0003\u0005)\u0011\u0001$\u0003\u0007}#C'\u0001\u0005u_\nKg.\u0019:z)\u0011\t\t*a-\t\r\u0005Uf\u00031\u0001,\u0003\ry'M[\u0001\u0012G\",7m[!mY><X\rZ\"mCN\u001cH\u0003BA^\u0003\u0003\u00042\u0001LA_\u0013\r\ty,\f\u0002\u0005+:LG\u000fC\u0004\u0002D^\u0001\r!!2\u0002\u000b\rd\u0017M\u001f>1\t\u0005\u001d\u00171\u001a\t\u0007\u0003\u0013\n9+!3\u0011\u0007\t\u000bY\rB\u0006\u0002N\u0006\u0005\u0017\u0011!A\u0001\u0006\u00031%aA0%k\u0005i\u0011n]%o\u00032dwn\u001e'jgR$B!a!\u0002T\"9\u00111\u0019\rA\u0002\u0005U\u0007\u0007BAl\u00037\u0004b!!\u0013\u0002(\u0006e\u0007c\u0001\"\u0002\\\u0012Y\u0011Q\\Aj\u0003\u0003\u0005\tQ!\u0001G\u0005\ryFEN\u0001\u001cSN\u0014u.\u001e8e)>\u0004&o\u001c;pEV47+\u001a:jC2L'0\u001a:\u0015\t\u0005\r\u00151\u001d\u0005\b\u0003\u0007L\u0002\u0019AAsa\u0011\t9/a;\u0011\r\u0005%\u0013qUAu!\r\u0011\u00151\u001e\u0003\f\u0003[\f\u0019/!A\u0001\u0002\u000b\u0005aIA\u0002`I]\na#[:J]\u0006cGn\\<MSN$8\t\\1tg:\u000bW.\u001a\u000b\u0005\u0003\u0007\u000b\u0019\u0010C\u0004\u0002Dj\u0001\r!!>1\t\u0005]\u00181 \t\u0007\u0003\u0013\n9+!?\u0011\u0007\t\u000bY\u0010B\u0006\u0002~\u0006M\u0018\u0011!A\u0001\u0006\u00031%aA0%q\u0001")
public class ProtobufSerializer
implements BaseSerializer {
    private Serialization serialization;
    private final ExtendedActorSystem system;
    private final AtomicReference<Map<Class<?>, Method>> parsingMethodBindingRef;
    private final AtomicReference<Map<Class<?>, Method>> toByteArrayMethodBindingRef;
    private final Set<String> allowedClassNames;
    private final MarkerLoggingAdapter log;
    private final int identifier;
    private volatile boolean bitmap$0;

    public static ActorRef deserializeActorRef(ExtendedActorSystem extendedActorSystem, WireFormats.ActorRefData actorRefData) {
        return ProtobufSerializer$.MODULE$.deserializeActorRef(extendedActorSystem, actorRefData);
    }

    public static WireFormats.ActorRefData serializeActorRef(ActorRef actorRef2) {
        return ProtobufSerializer$.MODULE$.serializeActorRef(actorRef2);
    }

    @Override
    @InternalApi
    public int identifierFromConfig() {
        return BaseSerializer.identifierFromConfig$(this);
    }

    @Override
    public final Object fromBinary(byte[] bytes) {
        return Serializer.fromBinary$(this, bytes);
    }

    @Override
    public final Object fromBinary(byte[] bytes, Class<?> clazz) throws NotSerializableException {
        return Serializer.fromBinary$(this, bytes, clazz);
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public void org$apache$pekko$serialization$BaseSerializer$_setter_$identifier_$eq(int x$1) {
        this.identifier = x$1;
    }

    @Override
    public ExtendedActorSystem system() {
        return this.system;
    }

    private AtomicReference<Map<Class<?>, Method>> parsingMethodBindingRef() {
        return this.parsingMethodBindingRef;
    }

    private AtomicReference<Map<Class<?>, Method>> toByteArrayMethodBindingRef() {
        return this.toByteArrayMethodBindingRef;
    }

    private Set<String> allowedClassNames() {
        return this.allowedClassNames;
    }

    private Serialization serialization$lzycompute() {
        ProtobufSerializer protobufSerializer = this;
        synchronized (protobufSerializer) {
            if (!this.bitmap$0) {
                this.serialization = (Serialization)SerializationExtension$.MODULE$.apply(this.system());
                this.bitmap$0 = true;
            }
        }
        return this.serialization;
    }

    private Serialization serialization() {
        if (!this.bitmap$0) {
            return this.serialization$lzycompute();
        }
        return this.serialization;
    }

    private MarkerLoggingAdapter log() {
        return this.log;
    }

    @Override
    public boolean includeManifest() {
        return true;
    }

    @Override
    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        Option<Class<?>> option = manifest;
        if (option instanceof Some) {
            Some some = (Some)option;
            Class clazz = (Class)some.value();
            return this.parsingMethod$1(ProtobufSerializer.parsingMethod$default$1$1(), clazz).invoke(null, new Object[]{bytes});
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException("Need a protobuf message class to be able to serialize bytes using protobuf");
        }
        throw new MatchError(option);
    }

    @Override
    public byte[] toBinary(Object obj) {
        Class<?> clazz = obj.getClass();
        return (byte[])this.toByteArrayMethod$1(ProtobufSerializer.toByteArrayMethod$default$1$1(), clazz).invoke(obj, new Object[0]);
    }

    private void checkAllowedClass(Class<?> clazz) {
        if (!this.isInAllowList(clazz)) {
            String warnMsg = new StringBuilder(230).append("Can't deserialize object of type [").append(clazz.getName()).append("] in [").append(this.getClass().getName()).append("]. ").append("Only classes that are on the allow list are allowed for security reasons. ").append("Configure allowed classes with pekko.actor.serialization-bindings or ").append("pekko.serialization.protobuf.allowed-classes").toString();
            this.log().warning(LogMarker$.MODULE$.Security(), warnMsg);
            throw new IllegalArgumentException(warnMsg);
        }
    }

    private boolean isInAllowList(Class<?> clazz) {
        return this.isBoundToProtobufSerializer(clazz) || this.isInAllowListClassName(clazz);
    }

    private boolean isBoundToProtobufSerializer(Class<?> clazz) {
        boolean bl;
        try {
            Serializer boundSerializer = this.serialization().serializerFor(clazz);
            bl = boundSerializer instanceof ProtobufSerializer;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    private boolean isInAllowListClassName(Class<?> clazz) {
        return this.allowedClassNames().apply(clazz.getName()) || this.allowedClassNames().apply(clazz.getSuperclass().getName()) || new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])clazz.getInterfaces())).exists((Function1<Object, Object>)(Function1<Class, Object> & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean(ProtobufSerializer.$anonfun$isInAllowListClassName$1(this, c)));
    }

    private final Method parsingMethod$1(Method method, Class clazz$1) {
        Option option;
        while (true) {
            Method unCachedParsingMethod;
            Map<Class<?>, Method> parsingMethodBinding;
            if ((option = (parsingMethodBinding = this.parsingMethodBindingRef().get()).get(clazz$1)) instanceof Some) {
                Some some = (Some)option;
                Method cachedParsingMethod = (Method)some.value();
                return cachedParsingMethod;
            }
            if (!None$.MODULE$.equals(option)) break;
            this.checkAllowedClass(clazz$1);
            Method method2 = unCachedParsingMethod = method == null ? clazz$1.getDeclaredMethod("parseFrom", ProtobufSerializer$.MODULE$.org$apache$pekko$remote$serialization$ProtobufSerializer$$ARRAY_OF_BYTE_ARRAY()) : method;
            if (this.parsingMethodBindingRef().compareAndSet(parsingMethodBinding, parsingMethodBinding.updated(clazz$1, unCachedParsingMethod))) {
                return unCachedParsingMethod;
            }
            method = unCachedParsingMethod;
        }
        throw new MatchError(option);
    }

    private static final Method parsingMethod$default$1$1() {
        return null;
    }

    private final Method toByteArrayMethod$1(Method method, Class clazz$2) {
        Option option;
        while (true) {
            Method unCachedtoByteArrayMethod;
            Map<Class<?>, Method> toByteArrayMethodBinding;
            if ((option = (toByteArrayMethodBinding = this.toByteArrayMethodBindingRef().get()).get(clazz$2)) instanceof Some) {
                Some some = (Some)option;
                Method cachedtoByteArrayMethod = (Method)some.value();
                return cachedtoByteArrayMethod;
            }
            if (!None$.MODULE$.equals(option)) break;
            Method method2 = unCachedtoByteArrayMethod = method == null ? clazz$2.getMethod("toByteArray", new Class[0]) : method;
            if (this.toByteArrayMethodBindingRef().compareAndSet(toByteArrayMethodBinding, toByteArrayMethodBinding.updated(clazz$2, unCachedtoByteArrayMethod))) {
                return unCachedtoByteArrayMethod;
            }
            method = unCachedtoByteArrayMethod;
        }
        throw new MatchError(option);
    }

    private static final Method toByteArrayMethod$default$1$1() {
        return null;
    }

    public static final /* synthetic */ boolean $anonfun$isInAllowListClassName$1(ProtobufSerializer $this, Class c) {
        return $this.allowedClassNames().apply(c.getName());
    }

    public ProtobufSerializer(ExtendedActorSystem system) {
        this.system = system;
        Serializer.$init$(this);
        BaseSerializer.$init$(this);
        this.parsingMethodBindingRef = new AtomicReference<GenMap>(Predef$.MODULE$.Map().empty());
        this.toByteArrayMethodBindingRef = new AtomicReference<GenMap>(Predef$.MODULE$.Map().empty());
        this.allowedClassNames = ((TraversableOnce)package$JavaConverters$.MODULE$.asScalaBufferConverter(system.settings().config().getStringList("pekko.serialization.protobuf.allowed-classes")).asScala()).toSet();
        this.log = Logging$.MODULE$.withMarker(system, ProtobufSerializer.class, LogSource$.MODULE$.fromAnyClass());
    }
}

