/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.artery.EnvelopeBuffer$;
import org.apache.pekko.remote.artery.InboundEnvelope;
import org.apache.pekko.remote.artery.OutboundEnvelope;
import org.apache.pekko.remote.artery.RemoteInstrument;
import org.apache.pekko.remote.artery.RemoteInstruments$;
import org.apache.pekko.util.OptionVal$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$Byte$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005}g!\u0002\u0013&\u0005\u001dz\u0003\u0002\u0003\u001c\u0001\u0005\u000b\u0007I\u0011\u0002\u001d\t\u0011}\u0002!\u0011!Q\u0001\neB\u0001\u0002\u0011\u0001\u0003\u0006\u0004%I!\u0011\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0005\"A\u0011\n\u0001B\u0001B\u0003%!\nC\u0003[\u0001\u0011\u00051\fC\u0003[\u0001\u0011\u0005\u0001\rC\u0003[\u0001\u0011\u00051\rC\u0004f\u0001\t\u0007I\u0011\u00024\t\r\u001d\u0004\u0001\u0015!\u0003K\u0011\u001dA\u0007A1A\u0005\n%Da!\u001c\u0001!\u0002\u0013Q\u0007\"\u00028\u0001\t\u0003y\u0007bBA\t\u0001\u0011%\u00111\u0003\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u001d\tY\u0003\u0001C\u0001\u0003[Aq!!\r\u0001\t\u0013\t\u0019\u0004C\u0004\u0002<\u0001!\t!!\u0010\t\u000f\u0005U\u0003\u0001\"\u0003\u0002X!9\u0011\u0011\r\u0001\u0005\u0002\u0005\r\u0004bBA6\u0001\u0011%\u0011Q\u000e\u0005\b\u0003o\u0002A\u0011BA=\u0011\u0019\t9\t\u0001C\u0001S\"1\u0011\u0011\u0012\u0001\u0005\u0002%Da!a#\u0001\t\u0003Iw\u0001CAGK!\u0005q%a$\u0007\u000f\u0011*\u0003\u0012A\u0014\u0002\u0012\"1!l\u0007C\u0001\u0003'Cq!!&\u001c\t\u0003\t9\nC\u0005\u0002\u001cn\u0011\r\u0011\"\u0004\u0002\u001e\"A\u0011qT\u000e!\u0002\u001b\t)\u0005C\u0004\u0002\"n!\t!a)\t\u000f\u0005M6\u0004\"\u0001\u00026\"9\u00111X\u000e\u0005\u0002\u0005u\u0006bBAa7\u0011\u0005\u00111\u0019\u0002\u0012%\u0016lw\u000e^3J]N$(/^7f]R\u001c(B\u0001\u0014(\u0003\u0019\t'\u000f^3ss*\u0011\u0001&K\u0001\u0007e\u0016lw\u000e^3\u000b\u0005)Z\u0013!\u00029fW.|'B\u0001\u0017.\u0003\u0019\t\u0007/Y2iK*\ta&A\u0002pe\u001e\u001c\"\u0001\u0001\u0019\u0011\u0005E\"T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\r\u0005s\u0017PU3g\u0003\u0019\u0019\u0018p\u001d;f[\u000e\u0001Q#A\u001d\u0011\u0005ijT\"A\u001e\u000b\u0005qJ\u0013!B1di>\u0014\u0018B\u0001 <\u0005M)\u0005\u0010^3oI\u0016$\u0017i\u0019;peNK8\u000f^3n\u0003\u001d\u0019\u0018p\u001d;f[\u0002\n1\u0001\\8h+\u0005\u0011\u0005CA\"G\u001b\u0005!%BA#*\u0003\u0015)g/\u001a8u\u0013\t9EI\u0001\bM_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\u0002\t1|w\rI\u0001\r?&t7\u000f\u001e:v[\u0016tGo\u001d\t\u0004\u0017N3fB\u0001'R\u001d\ti\u0005+D\u0001O\u0015\tyu'\u0001\u0004=e>|GOP\u0005\u0002g%\u0011!KM\u0001\ba\u0006\u001c7.Y4f\u0013\t!VK\u0001\u0004WK\u000e$xN\u001d\u0006\u0003%J\u0002\"a\u0016-\u000e\u0003\u0015J!!W\u0013\u0003!I+Wn\u001c;f\u0013:\u001cHO];nK:$\u0018A\u0002\u001fj]&$h\b\u0006\u0003];z{\u0006CA,\u0001\u0011\u00151d\u00011\u0001:\u0011\u0015\u0001e\u00011\u0001C\u0011\u0015Ie\u00011\u0001K)\ra\u0016M\u0019\u0005\u0006m\u001d\u0001\r!\u000f\u0005\u0006\u0001\u001e\u0001\rA\u0011\u000b\u00039\u0012DQA\u000e\u0005A\u0002e\n1\"\u001b8tiJ,X.\u001a8ugV\t!*\u0001\u0007j]N$(/^7f]R\u001c\b%\u0001\u000etKJL\u0017\r\\5{CRLwN\u001c+j[&tw-\u00128bE2,G-F\u0001k!\t\t4.\u0003\u0002me\t9!i\\8mK\u0006t\u0017aG:fe&\fG.\u001b>bi&|g\u000eV5nS:<WI\\1cY\u0016$\u0007%A\u0005tKJL\u0017\r\\5{KR\u0019\u0001o\u001d@\u0011\u0005E\n\u0018B\u0001:3\u0005\u0011)f.\u001b;\t\u000bQl\u0001\u0019A;\u0002!=,HOY8v]\u0012,eN^3m_B,\u0007c\u0001<zw6\tqO\u0003\u0002yS\u0005!Q\u000f^5m\u0013\tQxOA\u0005PaRLwN\u001c,bYB\u0011q\u000b`\u0005\u0003{\u0016\u0012\u0001cT;uE>,h\u000eZ#om\u0016dw\u000e]3\t\r}l\u0001\u0019AA\u0001\u0003\u0019\u0011WO\u001a4feB!\u00111AA\u0007\u001b\t\t)A\u0003\u0003\u0002\b\u0005%\u0011a\u00018j_*\u0011\u00111B\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0010\u0005\u0015!A\u0003\"zi\u0016\u0014UO\u001a4fe\u0006\u00192/\u001a:jC2L'0Z%ogR\u0014X/\\3oiR9\u0001/!\u0006\u0002\u001a\u0005m\u0001BBA\f\u001d\u0001\u0007a+\u0001\u0006j]N$(/^7f]RDQ\u0001\u001e\bA\u0002mDaa \bA\u0002\u0005\u0005\u0011a\u00033fg\u0016\u0014\u0018.\u00197ju\u0016$2\u0001]A\u0011\u0011\u001d\t\u0019c\u0004a\u0001\u0003K\tq\"\u001b8c_VtG-\u00128wK2|\u0007/\u001a\t\u0004/\u0006\u001d\u0012bAA\u0015K\ty\u0011J\u001c2pk:$WI\u001c<fY>\u0004X-\u0001\beKN,'/[1mSj,'+Y<\u0015\u0007A\fy\u0003C\u0004\u0002$A\u0001\r!!\n\u0002+\u0011,7/\u001a:jC2L'0Z%ogR\u0014X/\\3oiR9\u0001/!\u000e\u00028\u0005e\u0002BBA\f#\u0001\u0007a\u000bC\u0004\u0002$E\u0001\r!!\n\t\r}\f\u0002\u0019AA\u0001\u0003-iWm]:bO\u0016\u001cVM\u001c;\u0015\u000fA\fy$!\u0011\u0002L!)AO\u0005a\u0001w\"9\u00111\t\nA\u0002\u0005\u0015\u0013\u0001B:ju\u0016\u00042!MA$\u0013\r\tIE\r\u0002\u0004\u0013:$\bbBA'%\u0001\u0007\u0011qJ\u0001\u0005i&lW\rE\u00022\u0003#J1!a\u00153\u0005\u0011auN\\4\u0002+5,7o]1hKN+g\u000e^%ogR\u0014X/\\3oiRI\u0001/!\u0017\u0002\\\u0005u\u0013q\f\u0005\u0007\u0003/\u0019\u0002\u0019\u0001,\t\u000bQ\u001c\u0002\u0019A>\t\u000f\u0005\r3\u00031\u0001\u0002F!9\u0011QJ\nA\u0002\u0005=\u0013aD7fgN\fw-\u001a*fG\u0016Lg/\u001a3\u0015\u000fA\f)'a\u001a\u0002j!9\u00111\u0005\u000bA\u0002\u0005\u0015\u0002bBA\")\u0001\u0007\u0011Q\t\u0005\b\u0003\u001b\"\u0002\u0019AA(\u0003eiWm]:bO\u0016\u0014VmY3jm\u0016$\u0017J\\:ueVlWM\u001c;\u0015\u0013A\fy'!\u001d\u0002t\u0005U\u0004BBA\f+\u0001\u0007a\u000bC\u0004\u0002$U\u0001\r!!\n\t\u000f\u0005\rS\u00031\u0001\u0002F!9\u0011QJ\u000bA\u0002\u0005=\u0013!\b:f[>$X-\u00138tiJ,X.\u001a8u\u0013\u0012LE/\u001a:bi>\u0014(+Y<\u0015\r\u0005m\u0014\u0011QAB!\u0015Y\u0015QPA#\u0013\r\ty(\u0016\u0002\t\u0013R,'/\u0019;pe\"1qP\u0006a\u0001\u0003\u0003Aq!!\"\u0017\u0001\u0004\t)%\u0001\u0004f]\u0012\u0004vn]\u0001\bSN,U\u000e\u001d;z\u0003!qwN\\#naRL\u0018!\u0005;j[\u0016\u001cVM]5bY&T\u0018\r^5p]\u0006\t\"+Z7pi\u0016Len\u001d;sk6,g\u000e^:\u0011\u0005][2CA\u000e1)\t\ty)A\u0003baBd\u0017\u0010F\u0002]\u00033CQAN\u000fA\u0002e\n!\u0002\\3oORDW*Y:l+\t\t)%A\u0006mK:<G\u000f['bg.\u0004\u0013\u0001E2p[\nLg.Z&fs2+gn\u001a;i)\u0019\t)%!*\u00020\"9\u0011q\u0015\u0011A\u0002\u0005%\u0016!A6\u0011\u0007E\nY+C\u0002\u0002.J\u0012AAQ=uK\"9\u0011\u0011\u0017\u0011A\u0002\u0005\u0015\u0013!\u00017\u0002\r\u001d,GoS3z)\u0011\tI+a.\t\u000f\u0005e\u0016\u00051\u0001\u0002F\u0005\u00111\u000e\\\u0001\nO\u0016$H*\u001a8hi\"$B!!\u0012\u0002@\"9\u0011\u0011\u0018\u0012A\u0002\u0005\u0015\u0013AB2sK\u0006$X\rF\u0003K\u0003\u000b\f9\rC\u00037G\u0001\u0007\u0011\bC\u0003AG\u0001\u0007!\t\u000b\u0003\u0002H\u0006-\u0007c\u0001<\u0002N&\u0019\u0011qZ<\u0003\rUtWo]3eQ\r\u0019\u00131\u001b\t\u0005\u0003+\fY.\u0004\u0002\u0002X*\u0019\u0011\u0011\\\u0015\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002^\u0006]'!E%oi\u0016\u0014h.\u00197Ti\u0006\u0014G.Z!qS\u0002")
public final class RemoteInstruments {
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private final Vector<RemoteInstrument> instruments;
    private final boolean serializationTimingEnabled;

    @InternalStableApi
    public static Vector<RemoteInstrument> create(ExtendedActorSystem extendedActorSystem, LoggingAdapter loggingAdapter) {
        return RemoteInstruments$.MODULE$.create(extendedActorSystem, loggingAdapter);
    }

    public static int getLength(int n) {
        return RemoteInstruments$.MODULE$.getLength(n);
    }

    public static byte getKey(int n) {
        return RemoteInstruments$.MODULE$.getKey(n);
    }

    public static int combineKeyLength(byte by, int n) {
        return RemoteInstruments$.MODULE$.combineKeyLength(by, n);
    }

    public static RemoteInstruments apply(ExtendedActorSystem extendedActorSystem) {
        return RemoteInstruments$.MODULE$.apply(extendedActorSystem);
    }

    private ExtendedActorSystem system() {
        return this.system;
    }

    private LoggingAdapter log() {
        return this.log;
    }

    private Vector<RemoteInstrument> instruments() {
        return this.instruments;
    }

    private boolean serializationTimingEnabled() {
        return this.serializationTimingEnabled;
    }

    public void serialize(OutboundEnvelope outboundEnvelope, ByteBuffer buffer) {
        if (this.instruments().nonEmpty() && OptionVal$.MODULE$.isDefined$extension(outboundEnvelope)) {
            int startPos = buffer.position();
            OutboundEnvelope oe = OptionVal$.MODULE$.get$extension(outboundEnvelope);
            try {
                buffer.putInt(0);
                int dataPos = buffer.position();
                for (int i = 0; i < this.instruments().length(); ++i) {
                    Object object;
                    int rewindPos = buffer.position();
                    RemoteInstrument instrument = this.instruments().apply(i);
                    try {
                        this.serializeInstrument(instrument, oe, buffer);
                        object = BoxedUnit.UNIT;
                        continue;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            Throwable t = option.get();
                            this.log().debug("Skipping serialization of RemoteInstrument {} since it failed with {}", BoxesRunTime.boxToByte(instrument.identifier()), t.getMessage());
                            object = buffer.position(rewindPos);
                            continue;
                        }
                        throw throwable;
                    }
                }
                int endPos = buffer.position();
                if (endPos == dataPos) {
                    buffer.position(startPos);
                } else {
                    buffer.putInt(startPos, endPos - dataPos);
                }
            }
            catch (Throwable throwable) {
                Throwable throwable3 = throwable;
                Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable3);
                if (!option.isEmpty()) {
                    Throwable t = option.get();
                    this.log().debug("Skipping serialization of all RemoteInstruments due to unhandled failure {}", t);
                    buffer.position(startPos);
                }
                throw throwable;
            }
            return;
        }
    }

    private void serializeInstrument(RemoteInstrument instrument, OutboundEnvelope outboundEnvelope, ByteBuffer buffer) {
        int startPos = buffer.position();
        buffer.putInt(0);
        int dataPos = buffer.position();
        instrument.remoteWriteMetadata((ActorRef)OptionVal$.MODULE$.orNull$extension(outboundEnvelope.recipient(), Predef$.MODULE$.$conforms()), outboundEnvelope.message(), (ActorRef)OptionVal$.MODULE$.orNull$extension(outboundEnvelope.sender(), Predef$.MODULE$.$conforms()), buffer);
        int endPos = buffer.position();
        if (endPos == dataPos) {
            buffer.position(startPos);
            return;
        }
        buffer.putInt(startPos, RemoteInstruments$.MODULE$.combineKeyLength(instrument.identifier(), endPos - dataPos));
    }

    public void deserialize(InboundEnvelope inboundEnvelope) {
        if (inboundEnvelope.flag(EnvelopeBuffer$.MODULE$.MetadataPresentFlag())) {
            inboundEnvelope.envelopeBuffer().byteBuffer().position(EnvelopeBuffer$.MODULE$.MetadataContainerAndLiteralSectionOffset());
            this.deserializeRaw(inboundEnvelope);
            return;
        }
    }

    public void deserializeRaw(InboundEnvelope inboundEnvelope) {
        block16: {
            ByteBuffer buffer = inboundEnvelope.envelopeBuffer().byteBuffer();
            int length = buffer.getInt();
            int endPos = buffer.position() + length;
            try {
                try {
                    if (this.instruments().nonEmpty()) {
                        int i = 0;
                        while (i < this.instruments().length() && buffer.position() < endPos) {
                            RemoteInstrument instrument = this.instruments().apply(i);
                            int startPos = buffer.position();
                            int keyAndLength = buffer.getInt();
                            int dataPos = buffer.position();
                            byte key = RemoteInstruments$.MODULE$.getKey(keyAndLength);
                            int length2 = RemoteInstruments$.MODULE$.getLength(keyAndLength);
                            int nextPos = dataPos + length2;
                            byte identifier = instrument.identifier();
                            if (key == identifier) {
                                try {
                                    this.deserializeInstrument(instrument, inboundEnvelope, buffer);
                                }
                                catch (Throwable throwable) {
                                    Throwable throwable2 = throwable;
                                    Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                                    if (!option.isEmpty()) {
                                        Throwable t = option.get();
                                        this.log().debug("Skipping deserialization of RemoteInstrument {} since it failed with {}", BoxesRunTime.boxToByte(instrument.identifier()), t.getMessage());
                                    }
                                    throw throwable;
                                }
                                ++i;
                            } else if (key > identifier) {
                                this.log().debug("Skipping local RemoteInstrument {} that has no matching data in the message", BoxesRunTime.boxToByte(identifier));
                                nextPos = startPos;
                                ++i;
                            } else {
                                this.log().debug("Skipping serialized data in message for RemoteInstrument {} that has no local match", BoxesRunTime.boxToByte(key));
                            }
                            buffer.position(nextPos);
                        }
                        break block16;
                    }
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("Skipping serialized data in message for RemoteInstrument(s) {} that has no local match", this.remoteInstrumentIdIteratorRaw(buffer, endPos).mkString("[", ", ", "]"));
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = throwable;
                    Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable3);
                    if (!option.isEmpty()) {
                        Throwable t = option.get();
                        this.log().debug("Skipping further deserialization of remaining RemoteInstruments due to unhandled failure {}", t);
                        break block16;
                    }
                    throw throwable;
                }
            }
            finally {
                buffer.position(endPos);
            }
        }
    }

    private void deserializeInstrument(RemoteInstrument instrument, InboundEnvelope inboundEnvelope, ByteBuffer buffer) {
        instrument.remoteReadMetadata((ActorRef)OptionVal$.MODULE$.orNull$extension(inboundEnvelope.recipient(), Predef$.MODULE$.$conforms()), inboundEnvelope.message(), (ActorRef)OptionVal$.MODULE$.orNull$extension(inboundEnvelope.sender(), Predef$.MODULE$.$conforms()), buffer);
    }

    public void messageSent(OutboundEnvelope outboundEnvelope, int size, long time) {
        this.messageSent$1(0, outboundEnvelope, size, time);
    }

    private void messageSentInstrument(RemoteInstrument instrument, OutboundEnvelope outboundEnvelope, int size, long time) {
        instrument.remoteMessageSent((ActorRef)OptionVal$.MODULE$.orNull$extension(outboundEnvelope.recipient(), Predef$.MODULE$.$conforms()), outboundEnvelope.message(), (ActorRef)OptionVal$.MODULE$.orNull$extension(outboundEnvelope.sender(), Predef$.MODULE$.$conforms()), size, time);
    }

    public void messageReceived(InboundEnvelope inboundEnvelope, int size, long time) {
        this.messageRecieved$1(0, inboundEnvelope, size, time);
    }

    private void messageReceivedInstrument(RemoteInstrument instrument, InboundEnvelope inboundEnvelope, int size, long time) {
        instrument.remoteMessageReceived((ActorRef)OptionVal$.MODULE$.orNull$extension(inboundEnvelope.recipient(), Predef$.MODULE$.$conforms()), inboundEnvelope.message(), (ActorRef)OptionVal$.MODULE$.orNull$extension(inboundEnvelope.sender(), Predef$.MODULE$.$conforms()), size, time);
    }

    private Iterator<Object> remoteInstrumentIdIteratorRaw(ByteBuffer buffer, int endPos) {
        return new Iterator<Object>(null, buffer, endPos){
            private final ByteBuffer buffer$1;
            private final int endPos$1;

            public Iterator<Object> seq() {
                return Iterator.seq$(this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$(this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$(this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$(this);
            }

            public Iterator<Object> take(int n) {
                return Iterator.take$(this, n);
            }

            public Iterator<Object> drop(int n) {
                return Iterator.drop$(this, n);
            }

            public Iterator<Object> slice(int from, int until) {
                return Iterator.slice$(this, from, until);
            }

            public Iterator<Object> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$(this, from, until);
            }

            public <B> Iterator<B> map(Function1<Object, B> f) {
                return Iterator.map$(this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$(this, that);
            }

            public <B> Iterator<B> flatMap(Function1<Object, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$(this, f);
            }

            public Iterator<Object> filter(Function1<Object, Object> p) {
                return Iterator.filter$(this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Object, B, Object> p) {
                return Iterator.corresponds$(this, that, p);
            }

            public Iterator<Object> withFilter(Function1<Object, Object> p) {
                return Iterator.withFilter$(this, p);
            }

            public Iterator<Object> filterNot(Function1<Object, Object> p) {
                return Iterator.filterNot$(this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Object, B> pf) {
                return Iterator.collect$(this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Object, B> op) {
                return Iterator.scanLeft$(this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Object, B, B> op) {
                return Iterator.scanRight$(this, z, op);
            }

            public Iterator<Object> takeWhile(Function1<Object, Object> p) {
                return Iterator.takeWhile$(this, p);
            }

            public Tuple2<Iterator<Object>, Iterator<Object>> partition(Function1<Object, Object> p) {
                return Iterator.partition$(this, p);
            }

            public Tuple2<Iterator<Object>, Iterator<Object>> span(Function1<Object, Object> p) {
                return Iterator.span$(this, p);
            }

            public Iterator<Object> dropWhile(Function1<Object, Object> p) {
                return Iterator.dropWhile$(this, p);
            }

            public <B> Iterator<Tuple2<Object, B>> zip(Iterator<B> that) {
                return Iterator.zip$(this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$(this, len, elem);
            }

            public Iterator<Tuple2<Object, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$(this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$(this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<Object, U> f) {
                Iterator.foreach$(this, f);
            }

            public boolean forall(Function1<Object, Object> p) {
                return Iterator.forall$(this, p);
            }

            public boolean exists(Function1<Object, Object> p) {
                return Iterator.exists$(this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$(this, elem);
            }

            public Option<Object> find(Function1<Object, Object> p) {
                return Iterator.find$(this, p);
            }

            public int indexWhere(Function1<Object, Object> p) {
                return Iterator.indexWhere$(this, p);
            }

            public int indexWhere(Function1<Object, Object> p, int from) {
                return Iterator.indexWhere$(this, p, from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$(this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$(this, elem, from);
            }

            public BufferedIterator<Object> buffered() {
                return Iterator.buffered$(this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$(this, size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$(this, size, step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$(this);
            }

            public int length() {
                return Iterator.length$(this);
            }

            public Tuple2<Iterator<Object>, Iterator<Object>> duplicate() {
                return Iterator.duplicate$(this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$(this, from, patchElems, replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$(this, xs, start, len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$(this, that);
            }

            public Traversable<Object> toTraversable() {
                return Iterator.toTraversable$(this);
            }

            public Iterator<Object> toIterator() {
                return Iterator.toIterator$(this);
            }

            public Stream<Object> toStream() {
                return Iterator.toStream$(this);
            }

            public String toString() {
                return Iterator.toString$(this);
            }

            public List<Object> reversed() {
                return TraversableOnce.reversed$(this);
            }

            public int size() {
                return TraversableOnce.size$(this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$(this);
            }

            public int count(Function1<Object, Object> p) {
                return TraversableOnce.count$(this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Object, B> pf) {
                return TraversableOnce.collectFirst$(this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Object, B> op) {
                return (B)TraversableOnce.$div$colon$(this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Object, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$(this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Object, B> op) {
                return (B)TraversableOnce.foldLeft$(this, z, op);
            }

            public <B> B foldRight(B z, Function2<Object, B, B> op) {
                return (B)TraversableOnce.foldRight$(this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Object, B> op) {
                return (B)TraversableOnce.reduceLeft$(this, op);
            }

            public <B> B reduceRight(Function2<Object, B, B> op) {
                return (B)TraversableOnce.reduceRight$(this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Object, B> op) {
                return TraversableOnce.reduceLeftOption$(this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Object, B, B> op) {
                return TraversableOnce.reduceRightOption$(this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$(this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$(this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$(this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Object, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$(this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$(this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$(this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$(this, cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$(this, cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$(this, f, cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$(this, f, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$(this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$(this, xs, start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$(this, xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$(this, evidence$1);
            }

            public List<Object> toList() {
                return TraversableOnce.toList$(this);
            }

            public Iterable<Object> toIterable() {
                return TraversableOnce.toIterable$(this);
            }

            public Seq<Object> toSeq() {
                return TraversableOnce.toSeq$(this);
            }

            public IndexedSeq<Object> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$(this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$(this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$(this);
            }

            public Vector<Object> toVector() {
                return TraversableOnce.toVector$(this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, Object, Col> cbf) {
                return (Col)TraversableOnce.to$(this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef$.less.colon.less<Object, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$(this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$(this, start, sep, end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$(this, sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$(this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$(this, b, start, sep, end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$(this, b, sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$(this, b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$(this);
            }

            public boolean hasNext() {
                return this.buffer$1.position() < this.endPos$1;
            }

            public int next() {
                int keyAndLength = this.buffer$1.getInt();
                this.buffer$1.position(this.buffer$1.position() + RemoteInstruments$.MODULE$.getLength(keyAndLength));
                return RemoteInstruments$.MODULE$.getKey(keyAndLength);
            }
            {
                this.buffer$1 = buffer$1;
                this.endPos$1 = endPos$1;
                GenTraversableOnce.$init$(this);
                TraversableOnce.$init$(this);
                Iterator.$init$(this);
            }
        };
    }

    public boolean isEmpty() {
        return this.instruments().isEmpty();
    }

    public boolean nonEmpty() {
        return this.instruments().nonEmpty();
    }

    public boolean timeSerialization() {
        return this.serializationTimingEnabled();
    }

    private final void messageSent$1(int pos, OutboundEnvelope outboundEnvelope$1, int size$2, long time$1) {
        while (pos < this.instruments().length()) {
            RemoteInstrument instrument = this.instruments().apply(pos);
            try {
                this.messageSentInstrument(instrument, outboundEnvelope$1, size$2, time$1);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable t = option.get();
                    this.log().debug("Message sent in RemoteInstrument {} failed with {}", BoxesRunTime.boxToByte(instrument.identifier()), t.getMessage());
                }
                throw throwable;
            }
            ++pos;
        }
    }

    private final void messageRecieved$1(int pos, InboundEnvelope inboundEnvelope$1, int size$3, long time$2) {
        while (pos < this.instruments().length()) {
            RemoteInstrument instrument = this.instruments().apply(pos);
            try {
                this.messageReceivedInstrument(instrument, inboundEnvelope$1, size$3, time$2);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable t = option.get();
                    this.log().debug("Message received in RemoteInstrument {} failed with {}", BoxesRunTime.boxToByte(instrument.identifier()), t.getMessage());
                }
                throw throwable;
            }
            ++pos;
        }
    }

    public RemoteInstruments(ExtendedActorSystem system, LoggingAdapter log, Vector<RemoteInstrument> _instruments) {
        this.system = system;
        this.log = log;
        this.instruments = (Vector)_instruments.sortBy((Function1<RemoteInstrument, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToByte(x$1.identifier()), (Ordering)Ordering$Byte$.MODULE$);
        this.serializationTimingEnabled = this.instruments().exists((Function1<RemoteInstrument, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(x$2.serializationTimingEnabled()));
    }

    public RemoteInstruments(ExtendedActorSystem system, LoggingAdapter log) {
        this(system, log, RemoteInstruments$.MODULE$.create(system, log));
    }

    public RemoteInstruments(ExtendedActorSystem system) {
        this(system, Logging$.MODULE$.getLogger(system, RemoteInstruments.class));
    }
}

