/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.client.proxy;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobID;
import org.apache.flink.queryablestate.client.proxy.KvStateClientProxyHandler;
import org.apache.flink.queryablestate.messages.KvStateRequest;
import org.apache.flink.queryablestate.messages.KvStateResponse;
import org.apache.flink.queryablestate.network.AbstractServerBase;
import org.apache.flink.queryablestate.network.AbstractServerHandler;
import org.apache.flink.queryablestate.network.messages.MessageDeserializer;
import org.apache.flink.queryablestate.network.messages.MessageSerializer;
import org.apache.flink.queryablestate.network.stats.KvStateRequestStats;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.jobmaster.KvStateLocationOracle;
import org.apache.flink.runtime.query.KvStateClientProxy;
import org.apache.flink.util.Preconditions;

@Internal
public class KvStateClientProxyImpl
extends AbstractServerBase<KvStateRequest, KvStateResponse>
implements KvStateClientProxy {
    private final int queryExecutorThreads;
    private final KvStateRequestStats stats;
    private final ConcurrentHashMap<JobID, KvStateLocationOracle> kvStateLocationOracles;

    public KvStateClientProxyImpl(InetAddress bindAddress, Iterator<Integer> bindPortIterator, Integer numEventLoopThreads, Integer numQueryThreads, KvStateRequestStats stats) {
        super("Queryable State Proxy Server", bindAddress, bindPortIterator, numEventLoopThreads, numQueryThreads);
        Preconditions.checkArgument((numQueryThreads >= 1 ? 1 : 0) != 0, (Object)"Non-positive number of query threads.");
        this.queryExecutorThreads = numQueryThreads;
        this.stats = (KvStateRequestStats)Preconditions.checkNotNull((Object)stats);
        this.kvStateLocationOracles = new ConcurrentHashMap(4);
    }

    public InetSocketAddress getServerAddress() {
        return super.getServerAddress();
    }

    public void start() throws Throwable {
        super.start();
    }

    public void shutdown() {
        try {
            this.shutdownServer().get(10L, TimeUnit.SECONDS);
            this.log.info("{} was shutdown successfully.", (Object)this.getServerName());
        }
        catch (Exception e) {
            this.log.warn("{} shutdown failed: {}", (Object)this.getServerName(), (Object)e);
        }
    }

    public void updateKvStateLocationOracle(JobID jobId, @Nullable KvStateLocationOracle kvStateLocationOracle) {
        if (kvStateLocationOracle == null) {
            this.kvStateLocationOracles.remove(jobId);
        } else {
            this.kvStateLocationOracles.put(jobId, kvStateLocationOracle);
        }
    }

    @Nullable
    public KvStateLocationOracle getKvStateLocationOracle(JobID jobId) {
        KvStateLocationOracle legacyKvStateLocationOracle = this.kvStateLocationOracles.get(HighAvailabilityServices.DEFAULT_JOB_ID);
        if (legacyKvStateLocationOracle != null) {
            return legacyKvStateLocationOracle;
        }
        return this.kvStateLocationOracles.get(jobId);
    }

    public AbstractServerHandler<KvStateRequest, KvStateResponse> initializeHandler() {
        MessageSerializer serializer = new MessageSerializer((MessageDeserializer)new KvStateRequest.KvStateRequestDeserializer(), (MessageDeserializer)new KvStateResponse.KvStateResponseDeserializer());
        return new KvStateClientProxyHandler(this, this.queryExecutorThreads, (MessageSerializer<KvStateRequest, KvStateResponse>)serializer, this.stats);
    }
}

