/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.network;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.queryablestate.KvStateID;
import org.apache.flink.queryablestate.messages.KvStateInternalRequest;
import org.apache.flink.queryablestate.messages.KvStateResponse;
import org.apache.flink.queryablestate.network.messages.MessageBody;
import org.apache.flink.queryablestate.network.messages.MessageDeserializer;
import org.apache.flink.queryablestate.network.messages.MessageSerializer;
import org.apache.flink.queryablestate.network.messages.MessageType;
import org.apache.flink.queryablestate.network.messages.RequestFailure;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufAllocator;
import org.apache.flink.shaded.netty4.io.netty.buffer.UnpooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MessageSerializerTest {
    private final ByteBufAllocator alloc = UnpooledByteBufAllocator.DEFAULT;
    @Parameterized.Parameter
    public boolean async;

    @Parameterized.Parameters
    public static Collection<Boolean> parameters() {
        return Arrays.asList(false, true);
    }

    @Test
    public void testRequestSerialization() throws Exception {
        long requestId = 2147484984L;
        KvStateID kvStateId = new KvStateID();
        byte[] serializedKeyAndNamespace = this.randomByteArray(1024);
        KvStateInternalRequest request = new KvStateInternalRequest(kvStateId, serializedKeyAndNamespace);
        MessageSerializer serializer = new MessageSerializer((MessageDeserializer)new KvStateInternalRequest.KvStateInternalRequestDeserializer(), (MessageDeserializer)new KvStateResponse.KvStateResponseDeserializer());
        ByteBuf buf = MessageSerializer.serializeRequest((ByteBufAllocator)this.alloc, (long)requestId, (MessageBody)request);
        int frameLength = buf.readInt();
        Assert.assertEquals((Object)MessageType.REQUEST, (Object)MessageSerializer.deserializeHeader((ByteBuf)buf));
        Assert.assertEquals((long)requestId, (long)MessageSerializer.getRequestId((ByteBuf)buf));
        KvStateInternalRequest requestDeser = (KvStateInternalRequest)serializer.deserializeRequest(buf);
        Assert.assertEquals((long)buf.readerIndex(), (long)(frameLength + 4));
        Assert.assertEquals((Object)kvStateId, (Object)requestDeser.getKvStateId());
        Assert.assertArrayEquals((byte[])serializedKeyAndNamespace, (byte[])requestDeser.getSerializedKeyAndNamespace());
    }

    @Test
    public void testRequestSerializationWithZeroLengthKeyAndNamespace() throws Exception {
        long requestId = 2147484984L;
        KvStateID kvStateId = new KvStateID();
        byte[] serializedKeyAndNamespace = new byte[]{};
        KvStateInternalRequest request = new KvStateInternalRequest(kvStateId, serializedKeyAndNamespace);
        MessageSerializer serializer = new MessageSerializer((MessageDeserializer)new KvStateInternalRequest.KvStateInternalRequestDeserializer(), (MessageDeserializer)new KvStateResponse.KvStateResponseDeserializer());
        ByteBuf buf = MessageSerializer.serializeRequest((ByteBufAllocator)this.alloc, (long)requestId, (MessageBody)request);
        int frameLength = buf.readInt();
        Assert.assertEquals((Object)MessageType.REQUEST, (Object)MessageSerializer.deserializeHeader((ByteBuf)buf));
        Assert.assertEquals((long)requestId, (long)MessageSerializer.getRequestId((ByteBuf)buf));
        KvStateInternalRequest requestDeser = (KvStateInternalRequest)serializer.deserializeRequest(buf);
        Assert.assertEquals((long)buf.readerIndex(), (long)(frameLength + 4));
        Assert.assertEquals((Object)kvStateId, (Object)requestDeser.getKvStateId());
        Assert.assertArrayEquals((byte[])serializedKeyAndNamespace, (byte[])requestDeser.getSerializedKeyAndNamespace());
    }

    @Test(expected=NullPointerException.class)
    public void testNullPointerExceptionOnNullSerializedKeyAndNamepsace() throws Exception {
        new KvStateInternalRequest(new KvStateID(), null);
    }

    @Test
    public void testResponseSerialization() throws Exception {
        long requestId = 2220210925L;
        byte[] serializedResult = this.randomByteArray(1024);
        KvStateResponse response = new KvStateResponse(serializedResult);
        MessageSerializer serializer = new MessageSerializer((MessageDeserializer)new KvStateInternalRequest.KvStateInternalRequestDeserializer(), (MessageDeserializer)new KvStateResponse.KvStateResponseDeserializer());
        ByteBuf buf = MessageSerializer.serializeResponse((ByteBufAllocator)this.alloc, (long)requestId, (MessageBody)response);
        int frameLength = buf.readInt();
        Assert.assertEquals((Object)MessageType.REQUEST_RESULT, (Object)MessageSerializer.deserializeHeader((ByteBuf)buf));
        Assert.assertEquals((long)requestId, (long)MessageSerializer.getRequestId((ByteBuf)buf));
        KvStateResponse responseDeser = (KvStateResponse)serializer.deserializeResponse(buf);
        Assert.assertEquals((long)buf.readerIndex(), (long)(frameLength + 4));
        Assert.assertArrayEquals((byte[])serializedResult, (byte[])responseDeser.getContent());
    }

    @Test
    public void testResponseSerializationWithZeroLengthSerializedResult() throws Exception {
        byte[] serializedResult = new byte[]{};
        KvStateResponse response = new KvStateResponse(serializedResult);
        MessageSerializer serializer = new MessageSerializer((MessageDeserializer)new KvStateInternalRequest.KvStateInternalRequestDeserializer(), (MessageDeserializer)new KvStateResponse.KvStateResponseDeserializer());
        ByteBuf buf = MessageSerializer.serializeResponse((ByteBufAllocator)this.alloc, (long)72727278L, (MessageBody)response);
        int frameLength = buf.readInt();
        Assert.assertEquals((Object)MessageType.REQUEST_RESULT, (Object)MessageSerializer.deserializeHeader((ByteBuf)buf));
        Assert.assertEquals((long)72727278L, (long)MessageSerializer.getRequestId((ByteBuf)buf));
        KvStateResponse responseDeser = (KvStateResponse)serializer.deserializeResponse(buf);
        Assert.assertEquals((long)buf.readerIndex(), (long)(frameLength + 4));
        Assert.assertArrayEquals((byte[])serializedResult, (byte[])responseDeser.getContent());
    }

    @Test(expected=NullPointerException.class)
    public void testNullPointerExceptionOnNullSerializedResult() throws Exception {
        new KvStateResponse((byte[])null);
    }

    @Test
    public void testKvStateRequestFailureSerialization() throws Exception {
        long requestId = 2148594869L;
        IllegalStateException cause = new IllegalStateException("Expected test");
        ByteBuf buf = MessageSerializer.serializeRequestFailure((ByteBufAllocator)this.alloc, (long)requestId, (Throwable)cause);
        int frameLength = buf.readInt();
        Assert.assertEquals((Object)MessageType.REQUEST_FAILURE, (Object)MessageSerializer.deserializeHeader((ByteBuf)buf));
        RequestFailure requestFailure = MessageSerializer.deserializeRequestFailure((ByteBuf)buf);
        Assert.assertEquals((long)buf.readerIndex(), (long)(frameLength + 4));
        Assert.assertEquals((long)requestId, (long)requestFailure.getRequestId());
        Assert.assertEquals(cause.getClass(), requestFailure.getCause().getClass());
        Assert.assertEquals((Object)cause.getMessage(), (Object)requestFailure.getCause().getMessage());
    }

    @Test
    public void testServerFailureSerialization() throws Exception {
        IllegalStateException cause = new IllegalStateException("Expected test");
        ByteBuf buf = MessageSerializer.serializeServerFailure((ByteBufAllocator)this.alloc, (Throwable)cause);
        int frameLength = buf.readInt();
        Assert.assertEquals((Object)MessageType.SERVER_FAILURE, (Object)MessageSerializer.deserializeHeader((ByteBuf)buf));
        Throwable request = MessageSerializer.deserializeServerFailure((ByteBuf)buf);
        Assert.assertEquals((long)buf.readerIndex(), (long)(frameLength + 4));
        Assert.assertEquals(cause.getClass(), request.getClass());
        Assert.assertEquals((Object)cause.getMessage(), (Object)request.getMessage());
    }

    private byte[] randomByteArray(int capacity) {
        byte[] bytes = new byte[capacity];
        ThreadLocalRandom.current().nextBytes(bytes);
        return bytes;
    }
}

