/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.itcases;

import org.apache.curator.test.TestingServer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.QueryableStateOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.contrib.streaming.state.RocksDBStateBackend;
import org.apache.flink.queryablestate.client.QueryableStateClient;
import org.apache.flink.queryablestate.itcases.AbstractQueryableStateTestBase;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.test.util.MiniClusterWithClientResource;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.rules.TemporaryFolder;

public class HAQueryableStateRocksDBBackendITCase
extends AbstractQueryableStateTestBase {
    private static final int NUM_JMS = 2;
    private static final int NUM_TMS = 2;
    private static final int NUM_SLOTS_PER_TM = 2;
    private static final int QS_PROXY_PORT_RANGE_START = 9074;
    private static final int QS_SERVER_PORT_RANGE_START = 9079;
    @ClassRule
    public static TemporaryFolder temporaryFolder = new TemporaryFolder();
    private static TestingServer zkServer;
    private static MiniClusterWithClientResource miniClusterResource;

    @Override
    protected StateBackend createStateBackend() throws Exception {
        return new RocksDBStateBackend(temporaryFolder.newFolder().toURI().toString());
    }

    @BeforeClass
    public static void setup() throws Exception {
        zkServer = new TestingServer();
        miniClusterResource = new MiniClusterWithClientResource(new MiniClusterResourceConfiguration.Builder().setConfiguration(HAQueryableStateRocksDBBackendITCase.getConfig()).setNumberTaskManagers(2).setNumberSlotsPerTaskManager(2).build());
        miniClusterResource.before();
        client = new QueryableStateClient("localhost", 9074);
        clusterClient = miniClusterResource.getClusterClient();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        miniClusterResource.after();
        client.shutdownAndWait();
        zkServer.stop();
        zkServer.close();
    }

    private static Configuration getConfig() throws Exception {
        Configuration config = new Configuration();
        config.setBoolean(QueryableStateOptions.ENABLE_QUERYABLE_STATE_PROXY_SERVER, true);
        config.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, (Object)MemorySize.parse((String)"4m"));
        config.setInteger("local.number-jobmanager", 2);
        config.setInteger("local.number-taskmanager", 2);
        config.setInteger(TaskManagerOptions.NUM_TASK_SLOTS, 2);
        config.setInteger(QueryableStateOptions.CLIENT_NETWORK_THREADS, 2);
        config.setInteger(QueryableStateOptions.PROXY_NETWORK_THREADS, 2);
        config.setInteger(QueryableStateOptions.SERVER_NETWORK_THREADS, 2);
        config.setString(QueryableStateOptions.PROXY_PORT_RANGE, "9074-9076");
        config.setString(QueryableStateOptions.SERVER_PORT_RANGE, "9079-9081");
        config.setBoolean(WebOptions.SUBMIT_ENABLE, false);
        config.setString(HighAvailabilityOptions.HA_STORAGE_PATH, temporaryFolder.newFolder().toString());
        config.setString(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, zkServer.getConnectString());
        config.setString(HighAvailabilityOptions.HA_MODE, "zookeeper");
        return config;
    }
}

