/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.network;

import java.nio.channels.ClosedChannelException;
import org.apache.flink.queryablestate.messages.KvStateInternalRequest;
import org.apache.flink.queryablestate.messages.KvStateResponse;
import org.apache.flink.queryablestate.network.ClientHandler;
import org.apache.flink.queryablestate.network.ClientHandlerCallback;
import org.apache.flink.queryablestate.network.messages.MessageBody;
import org.apache.flink.queryablestate.network.messages.MessageDeserializer;
import org.apache.flink.queryablestate.network.messages.MessageSerializer;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufAllocator;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.embedded.EmbeddedChannel;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class KvStateClientHandlerTest {
    @Test
    public void testReadCallbacksAndBufferRecycling() throws Exception {
        ClientHandlerCallback callback = (ClientHandlerCallback)Mockito.mock(ClientHandlerCallback.class);
        MessageSerializer serializer = new MessageSerializer((MessageDeserializer)new KvStateInternalRequest.KvStateInternalRequestDeserializer(), (MessageDeserializer)new KvStateResponse.KvStateResponseDeserializer());
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ClientHandler("Test Client", serializer, callback)});
        byte[] content = new byte[]{};
        KvStateResponse response = new KvStateResponse(content);
        ByteBuf buf = MessageSerializer.serializeResponse((ByteBufAllocator)channel.alloc(), (long)1222112277L, (MessageBody)response);
        buf.skipBytes(4);
        channel.writeInbound(new Object[]{buf});
        ((ClientHandlerCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onRequestResult(Matchers.eq((long)1222112277L), (MessageBody)Matchers.any(KvStateResponse.class));
        Assert.assertEquals((String)"Buffer not recycled", (long)0L, (long)buf.refCnt());
        buf = MessageSerializer.serializeRequestFailure((ByteBufAllocator)channel.alloc(), (long)1222112278L, (Throwable)new RuntimeException("Expected test Exception"));
        buf.skipBytes(4);
        channel.writeInbound(new Object[]{buf});
        ((ClientHandlerCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onRequestFailure(Matchers.eq((long)1222112278L), (Throwable)ArgumentMatchers.isA(RuntimeException.class));
        Assert.assertEquals((String)"Buffer not recycled", (long)0L, (long)buf.refCnt());
        buf = MessageSerializer.serializeServerFailure((ByteBufAllocator)channel.alloc(), (Throwable)new RuntimeException("Expected test Exception"));
        buf.skipBytes(4);
        channel.writeInbound(new Object[]{buf});
        ((ClientHandlerCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onFailure((Throwable)ArgumentMatchers.isA(RuntimeException.class));
        buf = channel.alloc().buffer(4).writeInt(1223823);
        channel.writeInbound(new Object[]{buf});
        ((ClientHandlerCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onFailure((Throwable)ArgumentMatchers.isA(IllegalStateException.class));
        Assert.assertEquals((String)"Buffer not recycled", (long)0L, (long)buf.refCnt());
        channel.pipeline().fireExceptionCaught((Throwable)new RuntimeException("Expected test Exception"));
        ((ClientHandlerCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)3))).onFailure((Throwable)ArgumentMatchers.isA(RuntimeException.class));
        channel.pipeline().fireChannelInactive();
        ((ClientHandlerCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onFailure((Throwable)ArgumentMatchers.isA(ClosedChannelException.class));
    }
}

