/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.network;

import java.io.File;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.contrib.streaming.state.RocksDBKeyedStateBackend;
import org.apache.flink.contrib.streaming.state.RocksDBTestUtils;
import org.apache.flink.queryablestate.client.VoidNamespace;
import org.apache.flink.queryablestate.client.VoidNamespaceSerializer;
import org.apache.flink.queryablestate.network.KvStateRequestSerializerTest;
import org.apache.flink.runtime.state.internal.InternalListState;
import org.apache.flink.runtime.state.internal.InternalMapState;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public final class KVStateRequestSerializerRocksDBTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testListSerialization() throws Exception {
        long key = 0L;
        RocksDBKeyedStateBackend longHeapKeyedStateBackend = RocksDBTestUtils.builderForTestDefaults((File)this.temporaryFolder.getRoot(), (TypeSerializer)LongSerializer.INSTANCE).build();
        longHeapKeyedStateBackend.setCurrentKey((Object)0L);
        InternalListState listState = (InternalListState)longHeapKeyedStateBackend.createInternalState((TypeSerializer)VoidNamespaceSerializer.INSTANCE, (StateDescriptor)new ListStateDescriptor("test", (TypeSerializer)LongSerializer.INSTANCE));
        KvStateRequestSerializerTest.testListSerialization(0L, (InternalListState<Long, VoidNamespace, Long>)listState);
        longHeapKeyedStateBackend.dispose();
    }

    @Test
    public void testMapSerialization() throws Exception {
        long key = 0L;
        RocksDBKeyedStateBackend longHeapKeyedStateBackend = RocksDBTestUtils.builderForTestDefaults((File)this.temporaryFolder.getRoot(), (TypeSerializer)LongSerializer.INSTANCE).build();
        longHeapKeyedStateBackend.setCurrentKey((Object)0L);
        InternalMapState mapState = (InternalMapState)longHeapKeyedStateBackend.getPartitionedState((Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE, (StateDescriptor)new MapStateDescriptor("test", (TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE));
        KvStateRequestSerializerTest.testMapSerialization(0L, (InternalMapState<Long, VoidNamespace, Long, String>)mapState);
        longHeapKeyedStateBackend.dispose();
    }
}

