/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.network;

import java.io.File;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.contrib.streaming.state.PredefinedOptions;
import org.apache.flink.contrib.streaming.state.RocksDBKeyedStateBackend;
import org.apache.flink.queryablestate.client.VoidNamespace;
import org.apache.flink.queryablestate.client.VoidNamespaceSerializer;
import org.apache.flink.queryablestate.network.KvStateRequestSerializerTest;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.TestLocalRecoveryConfig;
import org.apache.flink.runtime.state.internal.InternalListState;
import org.apache.flink.runtime.state.internal.InternalMapState;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;

public final class KVStateRequestSerializerRocksDBTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testListSerialization() throws Exception {
        long key = 0L;
        DBOptions dbOptions = PredefinedOptions.DEFAULT.createDBOptions();
        dbOptions.setCreateIfMissing(true);
        ColumnFamilyOptions columnFamilyOptions = PredefinedOptions.DEFAULT.createColumnOptions();
        RocksDBKeyedStateBackend2 longHeapKeyedStateBackend = new RocksDBKeyedStateBackend2("no-op", ClassLoader.getSystemClassLoader(), this.temporaryFolder.getRoot(), dbOptions, columnFamilyOptions, (TaskKvStateRegistry)Mockito.mock(TaskKvStateRegistry.class), LongSerializer.INSTANCE, 1, new KeyGroupRange(0, 0), new ExecutionConfig());
        longHeapKeyedStateBackend.restore(null);
        longHeapKeyedStateBackend.setCurrentKey(0L);
        InternalListState listState = longHeapKeyedStateBackend.createListState(VoidNamespaceSerializer.INSTANCE, new ListStateDescriptor("test", (TypeSerializer)LongSerializer.INSTANCE));
        KvStateRequestSerializerTest.testListSerialization(0L, listState);
        longHeapKeyedStateBackend.dispose();
    }

    @Test
    public void testMapSerialization() throws Exception {
        long key = 0L;
        DBOptions dbOptions = PredefinedOptions.DEFAULT.createDBOptions();
        dbOptions.setCreateIfMissing(true);
        ColumnFamilyOptions columnFamilyOptions = PredefinedOptions.DEFAULT.createColumnOptions();
        RocksDBKeyedStateBackend longHeapKeyedStateBackend = new RocksDBKeyedStateBackend("no-op", ClassLoader.getSystemClassLoader(), this.temporaryFolder.getRoot(), dbOptions, columnFamilyOptions, (TaskKvStateRegistry)Mockito.mock(TaskKvStateRegistry.class), (TypeSerializer)LongSerializer.INSTANCE, 1, new KeyGroupRange(0, 0), new ExecutionConfig(), false, TestLocalRecoveryConfig.disabled());
        longHeapKeyedStateBackend.restore(null);
        longHeapKeyedStateBackend.setCurrentKey((Object)0L);
        InternalMapState mapState = (InternalMapState)longHeapKeyedStateBackend.getPartitionedState((Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE, (StateDescriptor)new MapStateDescriptor("test", (TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE));
        KvStateRequestSerializerTest.testMapSerialization(0L, (InternalMapState<Long, VoidNamespace, Long, String>)mapState);
        longHeapKeyedStateBackend.dispose();
    }

    static final class RocksDBKeyedStateBackend2<K>
    extends RocksDBKeyedStateBackend<K> {
        RocksDBKeyedStateBackend2(String operatorIdentifier, ClassLoader userCodeClassLoader, File instanceBasePath, DBOptions dbOptions, ColumnFamilyOptions columnFamilyOptions, TaskKvStateRegistry kvStateRegistry, TypeSerializer<K> keySerializer, int numberOfKeyGroups, KeyGroupRange keyGroupRange, ExecutionConfig executionConfig) throws Exception {
            super(operatorIdentifier, userCodeClassLoader, instanceBasePath, dbOptions, columnFamilyOptions, kvStateRegistry, keySerializer, numberOfKeyGroups, keyGroupRange, executionConfig, false, TestLocalRecoveryConfig.disabled());
        }

        public <N, T> InternalListState<K, N, T> createListState(TypeSerializer<N> namespaceSerializer, ListStateDescriptor<T> stateDesc) throws Exception {
            return super.createListState(namespaceSerializer, stateDesc);
        }
    }
}

