/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.itcases;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.QueryableStateOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.queryablestate.client.QueryableStateClient;
import org.apache.flink.queryablestate.itcases.AbstractQueryableStateTestBase;
import org.apache.flink.runtime.state.AbstractStateBackend;
import org.apache.flink.runtime.state.filesystem.FsStateBackend;
import org.apache.flink.test.util.MiniClusterResource;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

public class NonHAQueryableStateFsBackendITCase
extends AbstractQueryableStateTestBase {
    private static final int NUM_TMS = 2;
    private static final int NUM_SLOTS_PER_TM = 2;
    private static final int QS_PROXY_PORT_RANGE_START = 9084;
    private static final int QS_SERVER_PORT_RANGE_START = 9089;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @ClassRule
    public static final MiniClusterResource MINI_CLUSTER_RESOURCE = new MiniClusterResource(new MiniClusterResource.MiniClusterResourceConfiguration(NonHAQueryableStateFsBackendITCase.getConfig(), 2, 2), true);

    @Override
    protected AbstractStateBackend createStateBackend() throws Exception {
        return new FsStateBackend(this.temporaryFolder.newFolder().toURI().toString());
    }

    @BeforeClass
    public static void setup() throws Exception {
        client = new QueryableStateClient("localhost", 9084);
        clusterClient = MINI_CLUSTER_RESOURCE.getClusterClient();
    }

    @AfterClass
    public static void tearDown() {
        client.shutdownAndWait();
    }

    private static Configuration getConfig() {
        Configuration config = new Configuration();
        config.setLong(TaskManagerOptions.MANAGED_MEMORY_SIZE, 4L);
        config.setInteger("local.number-taskmanager", 2);
        config.setInteger(TaskManagerOptions.NUM_TASK_SLOTS, 2);
        config.setInteger(QueryableStateOptions.CLIENT_NETWORK_THREADS, 1);
        config.setInteger(QueryableStateOptions.PROXY_NETWORK_THREADS, 1);
        config.setInteger(QueryableStateOptions.SERVER_NETWORK_THREADS, 1);
        config.setString(QueryableStateOptions.PROXY_PORT_RANGE, "9084-9086");
        config.setString(QueryableStateOptions.SERVER_PORT_RANGE, "9089-9091");
        config.setBoolean(WebOptions.SUBMIT_ENABLE, false);
        return config;
    }
}

