/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.client.proxy;

import java.net.InetAddress;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.queryablestate.client.proxy.KvStateClientProxyImpl;
import org.apache.flink.queryablestate.network.stats.DisabledKvStateRequestStats;
import org.apache.flink.queryablestate.network.stats.KvStateRequestStats;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.jobmaster.KvStateLocationOracle;
import org.apache.flink.runtime.query.KvStateLocation;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KvStateClientProxyImplTest
extends TestLogger {
    private KvStateClientProxyImpl kvStateClientProxy;

    @Before
    public void setup() {
        this.kvStateClientProxy = new KvStateClientProxyImpl(InetAddress.getLoopbackAddress(), Collections.singleton(0).iterator(), Integer.valueOf(1), Integer.valueOf(1), (KvStateRequestStats)new DisabledKvStateRequestStats());
    }

    @After
    public void shutdown() {
        this.kvStateClientProxy.shutdown();
    }

    @Test
    public void testKvStateLocationOracle() {
        JobID jobId1 = new JobID();
        TestingKvStateLocationOracle kvStateLocationOracle1 = new TestingKvStateLocationOracle();
        this.kvStateClientProxy.updateKvStateLocationOracle(jobId1, (KvStateLocationOracle)kvStateLocationOracle1);
        JobID jobId2 = new JobID();
        TestingKvStateLocationOracle kvStateLocationOracle2 = new TestingKvStateLocationOracle();
        this.kvStateClientProxy.updateKvStateLocationOracle(jobId2, (KvStateLocationOracle)kvStateLocationOracle2);
        Assert.assertThat((Object)this.kvStateClientProxy.getKvStateLocationOracle(new JobID()), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)this.kvStateClientProxy.getKvStateLocationOracle(jobId1), (Matcher)Matchers.equalTo((Object)kvStateLocationOracle1));
        Assert.assertThat((Object)this.kvStateClientProxy.getKvStateLocationOracle(jobId2), (Matcher)Matchers.equalTo((Object)kvStateLocationOracle2));
        this.kvStateClientProxy.updateKvStateLocationOracle(jobId1, null);
        Assert.assertThat((Object)this.kvStateClientProxy.getKvStateLocationOracle(jobId1), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testLegacyCodePathPreference() {
        TestingKvStateLocationOracle kvStateLocationOracle = new TestingKvStateLocationOracle();
        this.kvStateClientProxy.updateKvStateLocationOracle(HighAvailabilityServices.DEFAULT_JOB_ID, (KvStateLocationOracle)kvStateLocationOracle);
        JobID jobId = new JobID();
        this.kvStateClientProxy.updateKvStateLocationOracle(jobId, (KvStateLocationOracle)new TestingKvStateLocationOracle());
        Assert.assertThat((Object)this.kvStateClientProxy.getKvStateLocationOracle(jobId), (Matcher)Matchers.equalTo((Object)kvStateLocationOracle));
    }

    private static final class TestingKvStateLocationOracle
    implements KvStateLocationOracle {
        private TestingKvStateLocationOracle() {
        }

        public CompletableFuture<KvStateLocation> requestKvStateLocation(JobID jobId, String registrationName) {
            return null;
        }
    }
}

