/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.server;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.annotation.Internal;
import org.apache.flink.queryablestate.exceptions.UnknownKeyOrNamespaceException;
import org.apache.flink.queryablestate.exceptions.UnknownKvStateIdException;
import org.apache.flink.queryablestate.messages.KvStateInternalRequest;
import org.apache.flink.queryablestate.messages.KvStateResponse;
import org.apache.flink.queryablestate.network.AbstractServerBase;
import org.apache.flink.queryablestate.network.AbstractServerHandler;
import org.apache.flink.queryablestate.network.messages.MessageSerializer;
import org.apache.flink.queryablestate.network.stats.KvStateRequestStats;
import org.apache.flink.queryablestate.server.KvStateServerImpl;
import org.apache.flink.runtime.query.KvStateRegistry;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
@Internal
public class KvStateServerHandler
extends AbstractServerHandler<KvStateInternalRequest, KvStateResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(KvStateServerHandler.class);
    private final KvStateRegistry registry;

    public KvStateServerHandler(KvStateServerImpl server, KvStateRegistry kvStateRegistry, MessageSerializer<KvStateInternalRequest, KvStateResponse> serializer, KvStateRequestStats stats) {
        super((AbstractServerBase)server, serializer, stats);
        this.registry = (KvStateRegistry)Preconditions.checkNotNull((Object)kvStateRegistry);
    }

    public CompletableFuture<KvStateResponse> handleRequest(long requestId, KvStateInternalRequest request) {
        CompletableFuture<KvStateResponse> responseFuture = new CompletableFuture<KvStateResponse>();
        try {
            InternalKvState kvState = this.registry.getKvState(request.getKvStateId());
            if (kvState == null) {
                responseFuture.completeExceptionally((Throwable)new UnknownKvStateIdException(this.getServerName(), request.getKvStateId()));
            } else {
                byte[] serializedKeyAndNamespace = request.getSerializedKeyAndNamespace();
                byte[] serializedResult = kvState.getSerializedValue(serializedKeyAndNamespace);
                if (serializedResult != null) {
                    responseFuture.complete(new KvStateResponse(serializedResult));
                } else {
                    responseFuture.completeExceptionally((Throwable)new UnknownKeyOrNamespaceException(this.getServerName()));
                }
            }
            return responseFuture;
        }
        catch (Throwable t) {
            String errMsg = "Error while processing request with ID " + requestId + ". Caused by: " + ExceptionUtils.stringifyException((Throwable)t);
            responseFuture.completeExceptionally(new RuntimeException(errMsg));
            return responseFuture;
        }
    }

    public CompletableFuture<Void> shutdown() {
        return CompletableFuture.completedFuture(null);
    }
}

