/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.client.proxy;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.Internal;
import org.apache.flink.queryablestate.client.proxy.KvStateClientProxyHandler;
import org.apache.flink.queryablestate.exceptions.UnknownJobManagerException;
import org.apache.flink.queryablestate.messages.KvStateRequest;
import org.apache.flink.queryablestate.messages.KvStateResponse;
import org.apache.flink.queryablestate.network.AbstractServerBase;
import org.apache.flink.queryablestate.network.AbstractServerHandler;
import org.apache.flink.queryablestate.network.messages.MessageDeserializer;
import org.apache.flink.queryablestate.network.messages.MessageSerializer;
import org.apache.flink.queryablestate.network.stats.KvStateRequestStats;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.query.KvStateClientProxy;
import org.apache.flink.util.Preconditions;

@Internal
public class KvStateClientProxyImpl
extends AbstractServerBase<KvStateRequest, KvStateResponse>
implements KvStateClientProxy {
    private static final CompletableFuture<ActorGateway> UNKNOWN_JOB_MANAGER = FutureUtils.completedExceptionally((Throwable)new UnknownJobManagerException());
    private final int queryExecutorThreads;
    private final KvStateRequestStats stats;
    private final Object leaderLock = new Object();
    private CompletableFuture<ActorGateway> jobManagerFuture = UNKNOWN_JOB_MANAGER;

    public KvStateClientProxyImpl(InetAddress bindAddress, Iterator<Integer> bindPortIterator, Integer numEventLoopThreads, Integer numQueryThreads, KvStateRequestStats stats) {
        super("Queryable State Proxy Server", bindAddress, bindPortIterator, numEventLoopThreads, numQueryThreads);
        Preconditions.checkArgument((numQueryThreads >= 1 ? 1 : 0) != 0, (Object)"Non-positive number of query threads.");
        this.queryExecutorThreads = numQueryThreads;
        this.stats = (KvStateRequestStats)Preconditions.checkNotNull((Object)stats);
    }

    public InetSocketAddress getServerAddress() {
        return super.getServerAddress();
    }

    public void start() throws Throwable {
        super.start();
    }

    public void shutdown() {
        try {
            this.shutdownServer().get(10L, TimeUnit.SECONDS);
            this.log.info("{} was shutdown successfully.", (Object)this.getServerName());
        }
        catch (Exception e) {
            this.log.warn("{} shutdown failed: {}", (Object)this.getServerName(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJobManager(CompletableFuture<ActorGateway> leadingJobManager) throws Exception {
        Object object = this.leaderLock;
        synchronized (object) {
            this.jobManagerFuture = leadingJobManager == null ? UNKNOWN_JOB_MANAGER : leadingJobManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<ActorGateway> getJobManagerFuture() {
        Object object = this.leaderLock;
        synchronized (object) {
            return this.jobManagerFuture;
        }
    }

    public AbstractServerHandler<KvStateRequest, KvStateResponse> initializeHandler() {
        MessageSerializer serializer = new MessageSerializer((MessageDeserializer)new KvStateRequest.KvStateRequestDeserializer(), (MessageDeserializer)new KvStateResponse.KvStateResponseDeserializer());
        return new KvStateClientProxyHandler(this, this.queryExecutorThreads, (MessageSerializer<KvStateRequest, KvStateResponse>)serializer, this.stats);
    }
}

