/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.network;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.queryablestate.client.VoidNamespace;
import org.apache.flink.queryablestate.client.VoidNamespaceSerializer;
import org.apache.flink.queryablestate.client.state.serialization.KvStateSerializer;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.heap.HeapKeyedStateBackend;
import org.apache.flink.runtime.state.internal.InternalListState;
import org.apache.flink.runtime.state.internal.InternalMapState;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class KvStateRequestSerializerTest {
    @Parameterized.Parameter
    public boolean async;

    @Parameterized.Parameters
    public static Collection<Boolean> parameters() {
        return Arrays.asList(false, true);
    }

    @Test
    public void testKeyAndNamespaceSerialization() throws Exception {
        LongSerializer keySerializer = LongSerializer.INSTANCE;
        StringSerializer namespaceSerializer = StringSerializer.INSTANCE;
        long expectedKey = 2147495970L;
        String expectedNamespace = "knilf";
        byte[] serializedKeyAndNamespace = KvStateSerializer.serializeKeyAndNamespace((Object)expectedKey, (TypeSerializer)keySerializer, (Object)expectedNamespace, (TypeSerializer)namespaceSerializer);
        Tuple2 actual = KvStateSerializer.deserializeKeyAndNamespace((byte[])serializedKeyAndNamespace, (TypeSerializer)keySerializer, (TypeSerializer)namespaceSerializer);
        Assert.assertEquals((long)expectedKey, (long)((Long)actual.f0));
        Assert.assertEquals((Object)expectedNamespace, (Object)actual.f1);
    }

    @Test(expected=IOException.class)
    public void testKeyAndNamespaceDeserializationEmpty() throws Exception {
        KvStateSerializer.deserializeKeyAndNamespace((byte[])new byte[0], (TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE);
    }

    @Test(expected=IOException.class)
    public void testKeyAndNamespaceDeserializationTooShort() throws Exception {
        KvStateSerializer.deserializeKeyAndNamespace((byte[])new byte[]{1}, (TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE);
    }

    @Test(expected=IOException.class)
    public void testKeyAndNamespaceDeserializationTooMany1() throws Exception {
        KvStateSerializer.deserializeKeyAndNamespace((byte[])new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 42, 0, 2}, (TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE);
    }

    @Test(expected=IOException.class)
    public void testKeyAndNamespaceDeserializationTooMany2() throws Exception {
        KvStateSerializer.deserializeKeyAndNamespace((byte[])new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 42, 0, 2, 2}, (TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE);
    }

    @Test
    public void testValueSerialization() throws Exception {
        LongSerializer valueSerializer = LongSerializer.INSTANCE;
        long expectedValue = 9223372035561846515L;
        byte[] serializedValue = KvStateSerializer.serializeValue((Object)expectedValue, (TypeSerializer)valueSerializer);
        long actualValue = (Long)KvStateSerializer.deserializeValue((byte[])serializedValue, (TypeSerializer)valueSerializer);
        Assert.assertEquals((long)expectedValue, (long)actualValue);
    }

    @Test(expected=IOException.class)
    public void testDeserializeValueEmpty() throws Exception {
        KvStateSerializer.deserializeValue((byte[])new byte[0], (TypeSerializer)LongSerializer.INSTANCE);
    }

    @Test(expected=IOException.class)
    public void testDeserializeValueTooShort() throws Exception {
        KvStateSerializer.deserializeValue((byte[])new byte[]{1}, (TypeSerializer)LongSerializer.INSTANCE);
    }

    @Test(expected=IOException.class)
    public void testDeserializeValueTooMany1() throws Exception {
        KvStateSerializer.deserializeValue((byte[])new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 2}, (TypeSerializer)LongSerializer.INSTANCE);
    }

    @Test(expected=IOException.class)
    public void testDeserializeValueTooMany2() throws Exception {
        KvStateSerializer.deserializeValue((byte[])new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 2, 2}, (TypeSerializer)LongSerializer.INSTANCE);
    }

    @Test
    public void testListSerialization() throws Exception {
        long key = 0L;
        HeapKeyedStateBackend longHeapKeyedStateBackend = new HeapKeyedStateBackend((TaskKvStateRegistry)Mockito.mock(TaskKvStateRegistry.class), (TypeSerializer)LongSerializer.INSTANCE, ClassLoader.getSystemClassLoader(), 1, new KeyGroupRange(0, 0), this.async, new ExecutionConfig());
        longHeapKeyedStateBackend.setCurrentKey((Object)0L);
        InternalListState listState = longHeapKeyedStateBackend.createListState((TypeSerializer)VoidNamespaceSerializer.INSTANCE, new ListStateDescriptor("test", (TypeSerializer)LongSerializer.INSTANCE));
        KvStateRequestSerializerTest.testListSerialization(0L, (InternalListState<VoidNamespace, Long>)listState);
    }

    public static void testListSerialization(long key, InternalListState<VoidNamespace, Long> listState) throws Exception {
        LongSerializer valueSerializer = LongSerializer.INSTANCE;
        listState.setCurrentNamespace((Object)VoidNamespace.INSTANCE);
        int numElements = 10;
        ArrayList<Long> expectedValues = new ArrayList<Long>();
        for (int i = 0; i < 10; ++i) {
            long value = ThreadLocalRandom.current().nextLong();
            expectedValues.add(value);
            listState.add((Object)value);
        }
        byte[] serializedKey = KvStateSerializer.serializeKeyAndNamespace((Object)key, (TypeSerializer)LongSerializer.INSTANCE, (Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE);
        byte[] serializedValues = listState.getSerializedValue(serializedKey);
        List actualValues = KvStateSerializer.deserializeList((byte[])serializedValues, (TypeSerializer)valueSerializer);
        Assert.assertEquals(expectedValues, (Object)actualValues);
        long expectedValue = ThreadLocalRandom.current().nextLong();
        byte[] serializedValue = KvStateSerializer.serializeValue((Object)expectedValue, (TypeSerializer)valueSerializer);
        List actualValue = KvStateSerializer.deserializeList((byte[])serializedValue, (TypeSerializer)valueSerializer);
        Assert.assertEquals((long)1L, (long)actualValue.size());
        Assert.assertEquals((long)expectedValue, (long)((Long)actualValue.get(0)));
    }

    @Test
    public void testDeserializeListEmpty() throws Exception {
        List actualValue = KvStateSerializer.deserializeList((byte[])new byte[0], (TypeSerializer)LongSerializer.INSTANCE);
        Assert.assertEquals((long)0L, (long)actualValue.size());
    }

    @Test(expected=IOException.class)
    public void testDeserializeListTooShort1() throws Exception {
        KvStateSerializer.deserializeList((byte[])new byte[]{1}, (TypeSerializer)LongSerializer.INSTANCE);
    }

    @Test(expected=IOException.class)
    public void testDeserializeListTooShort2() throws Exception {
        KvStateSerializer.deserializeList((byte[])new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 2, 3}, (TypeSerializer)LongSerializer.INSTANCE);
    }

    @Test
    public void testMapSerialization() throws Exception {
        long key = 0L;
        HeapKeyedStateBackend longHeapKeyedStateBackend = new HeapKeyedStateBackend((TaskKvStateRegistry)Mockito.mock(TaskKvStateRegistry.class), (TypeSerializer)LongSerializer.INSTANCE, ClassLoader.getSystemClassLoader(), 1, new KeyGroupRange(0, 0), this.async, new ExecutionConfig());
        longHeapKeyedStateBackend.setCurrentKey((Object)0L);
        InternalMapState mapState = (InternalMapState)longHeapKeyedStateBackend.getPartitionedState((Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE, (StateDescriptor)new MapStateDescriptor("test", (TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE));
        KvStateRequestSerializerTest.testMapSerialization(0L, (InternalMapState<VoidNamespace, Long, String>)mapState);
    }

    public static void testMapSerialization(long key, InternalMapState<VoidNamespace, Long, String> mapState) throws Exception {
        LongSerializer userKeySerializer = LongSerializer.INSTANCE;
        StringSerializer userValueSerializer = StringSerializer.INSTANCE;
        mapState.setCurrentNamespace((Object)VoidNamespace.INSTANCE);
        int numElements = 10;
        HashMap<Long, String> expectedValues = new HashMap<Long, String>();
        for (int i = 1; i <= 10; ++i) {
            long value = ThreadLocalRandom.current().nextLong();
            expectedValues.put(value, Long.toString(value));
            mapState.put((Object)value, (Object)Long.toString(value));
        }
        expectedValues.put(0L, null);
        mapState.put((Object)0L, null);
        byte[] serializedKey = KvStateSerializer.serializeKeyAndNamespace((Object)key, (TypeSerializer)LongSerializer.INSTANCE, (Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE);
        byte[] serializedValues = mapState.getSerializedValue(serializedKey);
        Map actualValues = KvStateSerializer.deserializeMap((byte[])serializedValues, (TypeSerializer)userKeySerializer, (TypeSerializer)userValueSerializer);
        Assert.assertEquals((long)expectedValues.size(), (long)actualValues.size());
        for (Map.Entry actualEntry : actualValues.entrySet()) {
            Assert.assertEquals(expectedValues.get(actualEntry.getKey()), actualEntry.getValue());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        long expectedKey = ThreadLocalRandom.current().nextLong();
        String expectedValue = Long.toString(expectedKey);
        byte[] isNull = new byte[]{0};
        baos.write(KvStateSerializer.serializeValue((Object)expectedKey, (TypeSerializer)userKeySerializer));
        baos.write(isNull);
        baos.write(KvStateSerializer.serializeValue((Object)expectedValue, (TypeSerializer)userValueSerializer));
        byte[] serializedValue = baos.toByteArray();
        Map actualValue = KvStateSerializer.deserializeMap((byte[])serializedValue, (TypeSerializer)userKeySerializer, (TypeSerializer)userValueSerializer);
        Assert.assertEquals((long)1L, (long)actualValue.size());
        Assert.assertEquals((Object)expectedValue, actualValue.get(expectedKey));
    }

    @Test
    public void testDeserializeMapEmpty() throws Exception {
        Map actualValue = KvStateSerializer.deserializeMap((byte[])new byte[0], (TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE);
        Assert.assertEquals((long)0L, (long)actualValue.size());
    }

    @Test(expected=IOException.class)
    public void testDeserializeMapTooShort1() throws Exception {
        KvStateSerializer.deserializeMap((byte[])new byte[]{1}, (TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE);
    }

    @Test(expected=IOException.class)
    public void testDeserializeMapTooShort2() throws Exception {
        KvStateSerializer.deserializeMap((byte[])new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 0}, (TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)LongSerializer.INSTANCE);
    }

    @Test(expected=IOException.class)
    public void testDeserializeMapTooShort3() throws Exception {
        KvStateSerializer.deserializeMap((byte[])new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 3}, (TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)LongSerializer.INSTANCE);
    }

    private byte[] randomByteArray(int capacity) {
        byte[] bytes = new byte[capacity];
        ThreadLocalRandom.current().nextBytes(bytes);
        return bytes;
    }
}

