/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.itcases;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.QueryableStateOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.queryablestate.client.QueryableStateClient;
import org.apache.flink.queryablestate.itcases.AbstractQueryableStateTestBase;
import org.apache.flink.runtime.jobmanager.HighAvailabilityMode;
import org.apache.flink.runtime.testingUtils.TestingCluster;
import org.junit.AfterClass;
import org.junit.Assert;

public abstract class NonHAAbstractQueryableStateTestBase
extends AbstractQueryableStateTestBase {
    private static final int NUM_TMS = 2;
    private static final int NUM_SLOTS_PER_TM = 4;

    public static void setup(int proxyPortRangeStart, int serverPortRangeStart) {
        try {
            Configuration config = new Configuration();
            config.setLong(TaskManagerOptions.MANAGED_MEMORY_SIZE, 4L);
            config.setInteger("local.number-taskmanager", 2);
            config.setInteger("taskmanager.numberOfTaskSlots", 4);
            config.setInteger(QueryableStateOptions.CLIENT_NETWORK_THREADS, 1);
            config.setInteger(QueryableStateOptions.PROXY_NETWORK_THREADS, 1);
            config.setInteger(QueryableStateOptions.SERVER_NETWORK_THREADS, 1);
            config.setString(QueryableStateOptions.PROXY_PORT_RANGE, proxyPortRangeStart + "-" + (proxyPortRangeStart + 2));
            config.setString(QueryableStateOptions.SERVER_PORT_RANGE, serverPortRangeStart + "-" + (serverPortRangeStart + 2));
            cluster = new TestingCluster(config, false);
            cluster.start(true);
            client = new QueryableStateClient("localhost", proxyPortRangeStart);
            Assert.assertTrue((cluster.haMode() == HighAvailabilityMode.NONE ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @AfterClass
    public static void tearDown() {
        client.shutdownAndWait();
        cluster.stop();
        cluster.awaitTermination();
    }
}

