/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.itcases;

import java.io.IOException;
import org.apache.curator.test.TestingServer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.QueryableStateOptions;
import org.apache.flink.queryablestate.client.QueryableStateClient;
import org.apache.flink.queryablestate.itcases.AbstractQueryableStateTestBase;
import org.apache.flink.runtime.jobmanager.HighAvailabilityMode;
import org.apache.flink.runtime.testingUtils.TestingCluster;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.rules.TemporaryFolder;

public abstract class HAAbstractQueryableStateTestBase
extends AbstractQueryableStateTestBase {
    private static final int NUM_JMS = 2;
    private static final int NUM_TMS = 2;
    private static final int NUM_SLOTS_PER_TM = 4;
    private static TestingServer zkServer;
    private static TemporaryFolder temporaryFolder;

    public static void setup(int proxyPortRangeStart, int serverPortRangeStart) {
        try {
            zkServer = new TestingServer();
            temporaryFolder = new TemporaryFolder();
            temporaryFolder.create();
            Configuration config = new Configuration();
            config.setInteger("local.number-jobmanager", 2);
            config.setInteger("local.number-taskmanager", 2);
            config.setInteger("taskmanager.numberOfTaskSlots", 4);
            config.setInteger(QueryableStateOptions.CLIENT_NETWORK_THREADS, 2);
            config.setInteger(QueryableStateOptions.PROXY_NETWORK_THREADS, 2);
            config.setInteger(QueryableStateOptions.SERVER_NETWORK_THREADS, 2);
            config.setString(QueryableStateOptions.PROXY_PORT_RANGE, proxyPortRangeStart + "-" + (proxyPortRangeStart + 2));
            config.setString(QueryableStateOptions.SERVER_PORT_RANGE, serverPortRangeStart + "-" + (serverPortRangeStart + 2));
            config.setString(HighAvailabilityOptions.HA_STORAGE_PATH, temporaryFolder.newFolder().toString());
            config.setString(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, zkServer.getConnectString());
            config.setString(HighAvailabilityOptions.HA_MODE, "zookeeper");
            cluster = new TestingCluster(config, false);
            cluster.start(true);
            client = new QueryableStateClient("localhost", proxyPortRangeStart);
            Assert.assertTrue((cluster.haMode() == HighAvailabilityMode.ZOOKEEPER ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @AfterClass
    public static void tearDown() throws IOException {
        client.shutdownAndWait();
        cluster.stop();
        cluster.awaitTermination();
        zkServer.stop();
        zkServer.close();
    }
}

