/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.itcases;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.QueryableStateOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.queryablestate.client.QueryableStateClient;
import org.apache.flink.queryablestate.itcases.AbstractQueryableStateTestBase;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.filesystem.FsStateBackend;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.test.util.MiniClusterWithClientResource;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

public class NonHAQueryableStateFsBackendITCase
extends AbstractQueryableStateTestBase {
    private static final int NUM_TMS = 2;
    private static final int NUM_SLOTS_PER_TM = 2;
    private static final int NUM_PORT_COUNT = 100;
    private static final int QS_PROXY_PORT_RANGE_START = 9084;
    private static final int QS_SERVER_PORT_RANGE_START = 9089;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @ClassRule
    public static final MiniClusterWithClientResource MINI_CLUSTER_RESOURCE = new MiniClusterWithClientResource(new MiniClusterResourceConfiguration.Builder().setConfiguration(NonHAQueryableStateFsBackendITCase.getConfig()).setNumberTaskManagers(2).setNumberSlotsPerTaskManager(2).build());

    @Override
    protected StateBackend createStateBackend() throws Exception {
        return new FsStateBackend(this.temporaryFolder.newFolder().toURI().toString());
    }

    @BeforeClass
    public static void setup() throws Exception {
        client = new QueryableStateClient("localhost", 9084);
        clusterClient = MINI_CLUSTER_RESOURCE.getClusterClient();
    }

    @AfterClass
    public static void tearDown() {
        client.shutdownAndWait();
    }

    private static Configuration getConfig() {
        Configuration config = new Configuration();
        config.setBoolean(QueryableStateOptions.ENABLE_QUERYABLE_STATE_PROXY_SERVER, true);
        config.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, (Object)MemorySize.parse((String)"4m"));
        config.setInteger("local.number-taskmanager", 2);
        config.setInteger(TaskManagerOptions.NUM_TASK_SLOTS, 2);
        config.setInteger(QueryableStateOptions.CLIENT_NETWORK_THREADS, 1);
        config.setInteger(QueryableStateOptions.PROXY_NETWORK_THREADS, 1);
        config.setInteger(QueryableStateOptions.SERVER_NETWORK_THREADS, 1);
        config.setString(QueryableStateOptions.PROXY_PORT_RANGE, "9084-9184");
        config.setString(QueryableStateOptions.SERVER_PORT_RANGE, "9089-9189");
        config.setBoolean(WebOptions.SUBMIT_ENABLE, false);
        return config;
    }
}

