/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.client.state;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.queryablestate.client.state.ImmutableValueState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ImmutableValueStateTest {
    private final ValueStateDescriptor<Long> valueStateDesc = new ValueStateDescriptor("test", (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO);
    private ValueState<Long> valueState;

    @Before
    public void setUp() throws Exception {
        if (!this.valueStateDesc.isSerializerInitialized()) {
            this.valueStateDesc.initializeSerializerUnlessSet(new ExecutionConfig());
        }
        this.valueState = (ValueState)ImmutableValueState.createState(this.valueStateDesc, (byte[])ByteBuffer.allocate(8).putLong(42L).array());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testUpdate() throws IOException {
        long value = (Long)this.valueState.value();
        Assert.assertEquals((long)42L, (long)value);
        this.valueState.update((Object)54L);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testClear() throws IOException {
        long value = (Long)this.valueState.value();
        Assert.assertEquals((long)42L, (long)value);
        this.valueState.clear();
    }
}

