/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.client.state;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.queryablestate.client.state.ImmutableMapState;
import org.apache.flink.queryablestate.client.state.serialization.KvStateSerializer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ImmutableMapStateTest {
    private final MapStateDescriptor<Long, Long> mapStateDesc = new MapStateDescriptor("test", (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO);
    private MapState<Long, Long> mapState;

    @Before
    public void setUp() throws Exception {
        if (!this.mapStateDesc.isSerializerInitialized()) {
            this.mapStateDesc.initializeSerializerUnlessSet(new ExecutionConfig());
        }
        HashMap<Long, Long> initMap = new HashMap<Long, Long>();
        initMap.put(1L, 5L);
        initMap.put(2L, 5L);
        byte[] initSer = KvStateSerializer.serializeMap(initMap.entrySet(), (TypeSerializer)BasicTypeInfo.LONG_TYPE_INFO.createSerializer(new ExecutionConfig()), (TypeSerializer)BasicTypeInfo.LONG_TYPE_INFO.createSerializer(new ExecutionConfig()));
        this.mapState = (MapState)ImmutableMapState.createState(this.mapStateDesc, (byte[])initSer);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testPut() throws Exception {
        Assert.assertTrue((boolean)this.mapState.contains((Object)1L));
        long value = (Long)this.mapState.get((Object)1L);
        Assert.assertEquals((long)5L, (long)value);
        Assert.assertTrue((boolean)this.mapState.contains((Object)2L));
        value = (Long)this.mapState.get((Object)2L);
        Assert.assertEquals((long)5L, (long)value);
        this.mapState.put((Object)2L, (Object)54L);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testPutAll() throws Exception {
        Assert.assertTrue((boolean)this.mapState.contains((Object)1L));
        long value = (Long)this.mapState.get((Object)1L);
        Assert.assertEquals((long)5L, (long)value);
        Assert.assertTrue((boolean)this.mapState.contains((Object)2L));
        value = (Long)this.mapState.get((Object)2L);
        Assert.assertEquals((long)5L, (long)value);
        HashMap<Long, Long> nMap = new HashMap<Long, Long>();
        nMap.put(1L, 7L);
        nMap.put(2L, 7L);
        this.mapState.putAll(nMap);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testUpdate() throws Exception {
        Assert.assertTrue((boolean)this.mapState.contains((Object)1L));
        long value = (Long)this.mapState.get((Object)1L);
        Assert.assertEquals((long)5L, (long)value);
        Assert.assertTrue((boolean)this.mapState.contains((Object)2L));
        value = (Long)this.mapState.get((Object)2L);
        Assert.assertEquals((long)5L, (long)value);
        this.mapState.put((Object)2L, (Object)54L);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testIterator() throws Exception {
        Assert.assertTrue((boolean)this.mapState.contains((Object)1L));
        long value = (Long)this.mapState.get((Object)1L);
        Assert.assertEquals((long)5L, (long)value);
        Assert.assertTrue((boolean)this.mapState.contains((Object)2L));
        value = (Long)this.mapState.get((Object)2L);
        Assert.assertEquals((long)5L, (long)value);
        Iterator iterator = this.mapState.iterator();
        while (iterator.hasNext()) {
            iterator.remove();
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testIterable() throws Exception {
        Assert.assertTrue((boolean)this.mapState.contains((Object)1L));
        long value = (Long)this.mapState.get((Object)1L);
        Assert.assertEquals((long)5L, (long)value);
        Assert.assertTrue((boolean)this.mapState.contains((Object)2L));
        value = (Long)this.mapState.get((Object)2L);
        Assert.assertEquals((long)5L, (long)value);
        Iterable iterable = this.mapState.entries();
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            Assert.assertEquals((long)5L, (long)((Long)((Map.Entry)iterator.next()).getValue()));
            iterator.remove();
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testKeys() throws Exception {
        Assert.assertTrue((boolean)this.mapState.contains((Object)1L));
        long value = (Long)this.mapState.get((Object)1L);
        Assert.assertEquals((long)5L, (long)value);
        Assert.assertTrue((boolean)this.mapState.contains((Object)2L));
        value = (Long)this.mapState.get((Object)2L);
        Assert.assertEquals((long)5L, (long)value);
        Iterator iterator = this.mapState.keys().iterator();
        while (iterator.hasNext()) {
            iterator.remove();
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testValues() throws Exception {
        Assert.assertTrue((boolean)this.mapState.contains((Object)1L));
        long value = (Long)this.mapState.get((Object)1L);
        Assert.assertEquals((long)5L, (long)value);
        Assert.assertTrue((boolean)this.mapState.contains((Object)2L));
        value = (Long)this.mapState.get((Object)2L);
        Assert.assertEquals((long)5L, (long)value);
        Iterator iterator = this.mapState.values().iterator();
        while (iterator.hasNext()) {
            iterator.remove();
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testClear() throws Exception {
        Assert.assertTrue((boolean)this.mapState.contains((Object)1L));
        long value = (Long)this.mapState.get((Object)1L);
        Assert.assertEquals((long)5L, (long)value);
        Assert.assertTrue((boolean)this.mapState.contains((Object)2L));
        value = (Long)this.mapState.get((Object)2L);
        Assert.assertEquals((long)5L, (long)value);
        this.mapState.clear();
    }
}

