/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.client.state;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.queryablestate.client.state.ImmutableListState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ImmutableListStateTest {
    private final ListStateDescriptor<Long> listStateDesc = new ListStateDescriptor("test", (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO);
    private ListState<Long> listState;

    @Before
    public void setUp() throws Exception {
        if (!this.listStateDesc.isSerializerInitialized()) {
            this.listStateDesc.initializeSerializerUnlessSet(new ExecutionConfig());
        }
        ArrayList<Long> init = new ArrayList<Long>();
        init.add(42L);
        byte[] serInit = this.serializeInitValue(init);
        this.listState = (ListState)ImmutableListState.createState(this.listStateDesc, (byte[])serInit);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testUpdate() throws Exception {
        List<Long> list = this.getStateContents();
        Assert.assertEquals((long)1L, (long)list.size());
        long element = list.get(0);
        Assert.assertEquals((long)42L, (long)element);
        this.listState.add((Object)54L);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testClear() throws Exception {
        List<Long> list = this.getStateContents();
        Assert.assertEquals((long)1L, (long)list.size());
        long element = list.get(0);
        Assert.assertEquals((long)42L, (long)element);
        this.listState.clear();
    }

    private byte[] serializeInitValue(List<Long> toSerialize) throws IOException {
        TypeSerializer serializer = this.listStateDesc.getElementSerializer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper((OutputStream)baos);
        for (int i = 0; i < toSerialize.size(); ++i) {
            serializer.serialize((Object)toSerialize.get(i), (DataOutputView)view);
            if (i >= toSerialize.size() - 1) continue;
            view.writeByte(44);
        }
        view.flush();
        return baos.toByteArray();
    }

    private List<Long> getStateContents() throws Exception {
        ArrayList<Long> list = new ArrayList<Long>();
        for (Long elem : (Iterable)this.listState.get()) {
            list.add(elem);
        }
        return list;
    }
}

