/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.client.state;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.FoldFunction;
import org.apache.flink.api.common.state.FoldingState;
import org.apache.flink.api.common.state.FoldingStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.queryablestate.client.state.ImmutableFoldingState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ImmutableFoldingStateTest {
    private final FoldingStateDescriptor<Long, String> foldingStateDesc = new FoldingStateDescriptor("test", (Object)"0", (FoldFunction)new SumFold(), (TypeSerializer)StringSerializer.INSTANCE);
    private FoldingState<Long, String> foldingState;

    @Before
    public void setUp() throws Exception {
        if (!this.foldingStateDesc.isSerializerInitialized()) {
            this.foldingStateDesc.initializeSerializerUnlessSet(new ExecutionConfig());
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StringSerializer.INSTANCE.serialize("42", (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
        this.foldingState = (FoldingState)ImmutableFoldingState.createState(this.foldingStateDesc, (byte[])out.toByteArray());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testUpdate() throws Exception {
        String value = (String)this.foldingState.get();
        Assert.assertEquals((Object)"42", (Object)value);
        this.foldingState.add((Object)54L);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testClear() throws Exception {
        String value = (String)this.foldingState.get();
        Assert.assertEquals((Object)"42", (Object)value);
        this.foldingState.clear();
    }

    private static class SumFold
    implements FoldFunction<Long, String> {
        private static final long serialVersionUID = -6249227626701264599L;

        private SumFold() {
        }

        public String fold(String accumulator, Long value) throws Exception {
            long acc = Long.valueOf(accumulator);
            return Long.toString(acc += value.longValue());
        }
    }
}

