/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.client.state;

import java.nio.ByteBuffer;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.queryablestate.client.state.ImmutableReducingState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ImmutableReducingStateTest {
    private final ReducingStateDescriptor<Long> reducingStateDesc = new ReducingStateDescriptor("test", (ReduceFunction)new SumReduce(), (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO);
    private ImmutableReducingState<Long> reduceState;

    @Before
    public void setUp() throws Exception {
        if (!this.reducingStateDesc.isSerializerInitialized()) {
            this.reducingStateDesc.initializeSerializerUnlessSet(new ExecutionConfig());
        }
        this.reduceState = ImmutableReducingState.createState(this.reducingStateDesc, (byte[])ByteBuffer.allocate(8).putLong(42L).array());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testUpdate() {
        long value = (Long)this.reduceState.get();
        Assert.assertEquals((long)42L, (long)value);
        this.reduceState.add((Object)54L);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testClear() {
        long value = (Long)this.reduceState.get();
        Assert.assertEquals((long)42L, (long)value);
        this.reduceState.clear();
    }

    private static class SumReduce
    implements ReduceFunction<Long> {
        private static final long serialVersionUID = 6041237513913189144L;

        private SumReduce() {
        }

        public Long reduce(Long value1, Long value2) throws Exception {
            return value1 + value2;
        }
    }
}

