/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.client.state;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.state.AggregatingState;
import org.apache.flink.api.common.state.AggregatingStateDescriptor;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.queryablestate.client.state.ImmutableAggregatingState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ImmutableAggregatingStateTest {
    private final AggregatingStateDescriptor<Long, String, String> aggrStateDesc = new AggregatingStateDescriptor("test", (AggregateFunction)new SumAggr(), String.class);
    private AggregatingState<Long, String> aggrState;

    @Before
    public void setUp() throws Exception {
        if (!this.aggrStateDesc.isSerializerInitialized()) {
            this.aggrStateDesc.initializeSerializerUnlessSet(new ExecutionConfig());
        }
        String initValue = "42";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.aggrStateDesc.getSerializer().serialize((Object)"42", (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
        this.aggrState = (AggregatingState)ImmutableAggregatingState.createState(this.aggrStateDesc, (byte[])out.toByteArray());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testUpdate() throws Exception {
        String value = (String)this.aggrState.get();
        Assert.assertEquals((Object)"42", (Object)value);
        this.aggrState.add((Object)54L);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testClear() throws Exception {
        String value = (String)this.aggrState.get();
        Assert.assertEquals((Object)"42", (Object)value);
        this.aggrState.clear();
    }

    private static class SumAggr
    implements AggregateFunction<Long, String, String> {
        private static final long serialVersionUID = -6249227626701264599L;

        private SumAggr() {
        }

        public String createAccumulator() {
            return "";
        }

        public String add(Long value, String accumulator) {
            accumulator = accumulator + ", " + value;
            return accumulator;
        }

        public String getResult(String accumulator) {
            return accumulator;
        }

        public String merge(String a, String b) {
            return a + ", " + b;
        }
    }
}

