/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.python.aggregate.arrow.stream;

import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.python.PythonFunctionRunner;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.python.PythonFunctionInfo;
import org.apache.flink.table.runtime.operators.python.aggregate.arrow.AbstractArrowPythonAggregateFunctionOperator;
import org.apache.flink.table.runtime.operators.python.aggregate.arrow.stream.AbstractStreamArrowPythonAggregateFunctionOperatorTest;
import org.apache.flink.table.runtime.operators.python.aggregate.arrow.stream.StreamArrowPythonProcTimeBoundedRowsOperator;
import org.apache.flink.table.runtime.utils.PassThroughPythonAggregateFunctionRunner;
import org.apache.flink.table.runtime.utils.PythonTestUtils;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.junit.Test;

public class StreamArrowPythonProcTimeBoundedRowsOperatorTest
extends AbstractStreamArrowPythonAggregateFunctionOperatorTest {
    @Test
    public void testOverWindowAggregateFunction() throws Exception {
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.getTestHarness(new Configuration());
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.open();
        testHarness.setProcessingTime(100L);
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c2", 0L)));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c4", 1L)));
        testHarness.setProcessingTime(200L);
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c6", 2L)));
        testHarness.setProcessingTime(300L);
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c2", "c8", 3L)));
        testHarness.setProcessingTime(600L);
        testHarness.close();
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", "c2", 0L, 0L)));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", "c4", 1L, 0L)));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", "c6", 2L, 1L)));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c2", "c8", 3L, 3L)));
        this.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
    }

    @Override
    public LogicalType[] getOutputLogicalType() {
        return new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType()};
    }

    @Override
    public RowType getInputType() {
        return new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new VarCharType()), new RowType.RowField("f2", (LogicalType)new VarCharType()), new RowType.RowField("f3", (LogicalType)new BigIntType())));
    }

    @Override
    public RowType getOutputType() {
        return new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new VarCharType()), new RowType.RowField("f2", (LogicalType)new VarCharType()), new RowType.RowField("f3", (LogicalType)new BigIntType()), new RowType.RowField("agg", (LogicalType)new BigIntType())));
    }

    @Override
    public AbstractArrowPythonAggregateFunctionOperator getTestOperator(Configuration config, PythonFunctionInfo[] pandasAggregateFunctions, RowType inputType, RowType outputType, int[] groupingSet, int[] udafInputOffsets) {
        return new PassThroughStreamArrowPythonProcTimeBoundedRowsOperator(config, pandasAggregateFunctions, inputType, outputType, 3, 1L, groupingSet, udafInputOffsets);
    }

    private static class PassThroughStreamArrowPythonProcTimeBoundedRowsOperator
    extends StreamArrowPythonProcTimeBoundedRowsOperator {
        PassThroughStreamArrowPythonProcTimeBoundedRowsOperator(Configuration config, PythonFunctionInfo[] pandasAggFunctions, RowType inputType, RowType outputType, int inputTimeFieldIndex, long lowerBoundary, int[] groupingSet, int[] udafInputOffsets) {
            super(config, 100L, 200L, pandasAggFunctions, inputType, outputType, inputTimeFieldIndex, lowerBoundary, groupingSet, udafInputOffsets);
        }

        public PythonFunctionRunner createPythonFunctionRunner() {
            return new PassThroughPythonAggregateFunctionRunner(this.getRuntimeContext().getTaskName(), PythonTestUtils.createTestEnvironmentManager(), this.userDefinedFunctionInputType, this.userDefinedFunctionOutputType, this.getFunctionUrn(), this.getUserDefinedFunctionsProto(), this.getInputOutputCoderUrn(), new HashMap<String, String>(), PythonTestUtils.createMockFlinkMetricContainer(), false);
        }
    }
}

