/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.arrow.sources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.runtime.arrow.ArrowUtils;
import org.apache.flink.table.runtime.arrow.ArrowWriter;
import org.apache.flink.table.runtime.arrow.sources.AbstractArrowSourceFunction;
import org.apache.flink.table.runtime.arrow.sources.ArrowSourceFunction;
import org.apache.flink.table.runtime.arrow.sources.ArrowSourceFunctionTestBase;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.testutils.DeeplyEqualsChecker;
import org.junit.BeforeClass;

public class ArrowSourceFunctionTest
extends ArrowSourceFunctionTestBase<RowData> {
    private static List<LogicalType> fieldTypes = new ArrayList<LogicalType>();
    private static RowType rowType;
    private static DataType dataType;
    private static RowDataSerializer serializer;
    private static BufferAllocator allocator;

    public ArrowSourceFunctionTest() {
        super(VectorSchemaRoot.create((Schema)ArrowUtils.toArrowSchema((RowType)rowType), (BufferAllocator)allocator), serializer, Comparator.comparing(o -> o.getString(0)), new DeeplyEqualsChecker().withCustomCheck((o1, o2) -> o1 instanceof RowData && o2 instanceof RowData, (o1, o2, checker) -> ArrowSourceFunctionTest.deepEqualsBaseRow((RowData)o1, (RowData)o2, (RowDataSerializer)serializer.duplicate(), (RowDataSerializer)serializer.duplicate())));
    }

    private static boolean deepEqualsBaseRow(RowData should, RowData is, RowDataSerializer serializer1, RowDataSerializer serializer2) {
        if (should.getArity() != is.getArity()) {
            return false;
        }
        BinaryRowData row1 = serializer1.toBinaryRow(should);
        BinaryRowData row2 = serializer2.toBinaryRow(is);
        return Objects.equals(row1, row2);
    }

    @BeforeClass
    public static void init() {
        fieldTypes.add((LogicalType)new VarCharType());
        ArrayList<RowType.RowField> rowFields = new ArrayList<RowType.RowField>();
        for (int i = 0; i < fieldTypes.size(); ++i) {
            rowFields.add(new RowType.RowField("f" + i, fieldTypes.get(i)));
        }
        rowType = new RowType(rowFields);
        dataType = TypeConversions.fromLogicalToDataType((LogicalType)rowType);
        serializer = new RowDataSerializer(fieldTypes.toArray(new LogicalType[0]));
        allocator = ArrowUtils.getRootAllocator().newChildAllocator("stdout", 0L, Long.MAX_VALUE);
    }

    @Override
    public Tuple2<List<RowData>, Integer> getTestData() {
        return Tuple2.of(Arrays.asList(GenericRowData.of((Object[])new Object[]{BinaryStringData.fromString((String)"aaa")}), GenericRowData.of((Object[])new Object[]{BinaryStringData.fromString((String)"bbb")}), GenericRowData.of((Object[])new Object[]{BinaryStringData.fromString((String)"ccc")}), GenericRowData.of((Object[])new Object[]{BinaryStringData.fromString((String)"ddd")}), GenericRowData.of((Object[])new Object[]{BinaryStringData.fromString((String)"eee")})), (Object)3);
    }

    @Override
    public ArrowWriter<RowData> createArrowWriter() {
        return ArrowUtils.createRowDataArrowWriter((VectorSchemaRoot)this.root, (RowType)rowType);
    }

    @Override
    public AbstractArrowSourceFunction<RowData> createArrowSourceFunction(byte[][] arrowData) {
        return new ArrowSourceFunction(dataType, arrowData);
    }
}

