/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.arrow;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.runtime.arrow.ArrowReader;
import org.apache.flink.table.runtime.arrow.ArrowWriter;
import org.apache.flink.testutils.CustomEqualityMatcher;
import org.apache.flink.testutils.DeeplyEqualsChecker;
import org.apache.flink.util.Preconditions;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public abstract class ArrowReaderWriterTestBase<T> {
    private final DeeplyEqualsChecker checker;

    ArrowReaderWriterTestBase() {
        this.checker = new DeeplyEqualsChecker();
    }

    ArrowReaderWriterTestBase(DeeplyEqualsChecker checker) {
        this.checker = (DeeplyEqualsChecker)Preconditions.checkNotNull((Object)checker);
    }

    @Test
    public void testBasicFunctionality() {
        try {
            T[] testData;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Tuple2<ArrowWriter<T>, ArrowStreamWriter> tuple2 = this.createArrowWriter(baos);
            ArrowWriter arrowWriter = (ArrowWriter)tuple2.f0;
            ArrowStreamWriter arrowStreamWriter = (ArrowStreamWriter)tuple2.f1;
            for (T value : testData = this.getTestData()) {
                arrowWriter.write(value);
            }
            arrowWriter.finish();
            arrowStreamWriter.writeBatch();
            ArrowReader<T> arrowReader = this.createArrowReader(new ByteArrayInputStream(baos.toByteArray()));
            for (int i = 0; i < testData.length; ++i) {
                Object deserialized = arrowReader.read(i);
                Assert.assertThat((String)"Deserialized value is wrong.", (Object)deserialized, (Matcher)CustomEqualityMatcher.deeplyEquals(testData[i]).withChecker(this.checker));
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Exception in test: " + e.getMessage()));
        }
    }

    public abstract ArrowReader<T> createArrowReader(InputStream var1) throws IOException;

    public abstract Tuple2<ArrowWriter<T>, ArrowStreamWriter> createArrowWriter(OutputStream var1) throws IOException;

    public abstract T[] getTestData();
}

