/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.python.util.ZipUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ZipUtilsTest {
    private static final int S_IFLNK = 40960;
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testSymlink() throws IOException {
        File zipFile = this.temporaryFolder.newFile();
        try (ZipArchiveOutputStream zipOut = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(zipFile));){
            String file1 = "zipFile1";
            ZipArchiveEntry entry = new ZipArchiveEntry(file1);
            entry.setUnixMode(420);
            zipOut.putArchiveEntry((ArchiveEntry)entry);
            zipOut.write(new byte[]{1, 1, 1, 1, 1});
            zipOut.closeArchiveEntry();
            String file2 = "zipFile2";
            entry = new ZipArchiveEntry(file2);
            entry.setUnixMode(420);
            zipOut.putArchiveEntry((ArchiveEntry)entry);
            zipOut.write(new byte[]{2, 2, 2, 2, 2});
            zipOut.closeArchiveEntry();
            entry = new ZipArchiveEntry("softlink");
            entry.setUnixMode(41380);
            zipOut.putArchiveEntry((ArchiveEntry)entry);
            zipOut.write(file1.getBytes(ConfigConstants.DEFAULT_CHARSET));
            zipOut.closeArchiveEntry();
        }
        String targetPath = this.temporaryFolder.newFolder().getCanonicalPath();
        ZipUtils.extractZipFileWithPermissions((String)zipFile.getCanonicalPath(), (String)targetPath);
        Path softLink = new File(targetPath, "softlink").toPath();
        Assert.assertTrue((boolean)Files.isSymbolicLink(softLink));
        Assert.assertTrue((boolean)Files.readSymbolicLink(softLink).toString().endsWith("zipFile1"));
        Path file1Path = new File(targetPath, "zipFile1").toPath();
        Assert.assertTrue((boolean)Files.isRegularFile(file1Path, new LinkOption[0]));
        Assert.assertArrayEquals((byte[])Files.readAllBytes(file1Path), (byte[])new byte[]{1, 1, 1, 1, 1});
        Path file2Path = new File(targetPath, "zipFile2").toPath();
        Assert.assertTrue((boolean)Files.isRegularFile(file2Path, new LinkOption[0]));
        Assert.assertArrayEquals((byte[])Files.readAllBytes(file2Path), (byte[])new byte[]{2, 2, 2, 2, 2});
    }

    @Test
    public void testSymlinkWithoutTargetFile() throws IOException {
        File zipFile = this.temporaryFolder.newFile();
        try (ZipArchiveOutputStream zipOut = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(zipFile));){
            ZipArchiveEntry entry = new ZipArchiveEntry("softlink");
            entry.setUnixMode(41380);
            zipOut.putArchiveEntry((ArchiveEntry)entry);
            zipOut.write("targetFile".getBytes(ConfigConstants.DEFAULT_CHARSET));
            zipOut.closeArchiveEntry();
        }
        String targetPath = this.temporaryFolder.newFolder().getCanonicalPath();
        ZipUtils.extractZipFileWithPermissions((String)zipFile.getCanonicalPath(), (String)targetPath);
        Path softLink = new File(targetPath, "softlink").toPath();
        Assert.assertTrue((boolean)Files.isSymbolicLink(softLink));
        Assert.assertTrue((boolean)Files.readSymbolicLink(softLink).toString().endsWith("targetFile"));
    }

    @Test
    public void testExpandOutOfTargetDir() throws IOException {
        File zipFile = this.temporaryFolder.newFile();
        try (ZipArchiveOutputStream zipOut = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(zipFile));){
            String file1 = "../zipFile";
            ZipArchiveEntry entry = new ZipArchiveEntry(file1);
            zipOut.putArchiveEntry((ArchiveEntry)entry);
            zipOut.write(new byte[]{1, 1, 1, 1, 1});
            zipOut.closeArchiveEntry();
        }
        String targetPath = this.temporaryFolder.newFolder().getCanonicalPath();
        try {
            ZipUtils.extractZipFileWithPermissions((String)zipFile.getCanonicalPath(), (String)targetPath);
            Assert.fail((String)"exception expected");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Expand ../zipFile would create a file outside of"));
        }
    }

    @Test
    public void testPermissionRestored() throws IOException {
        File zipFile = this.temporaryFolder.newFile();
        try (ZipArchiveOutputStream zipOut = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(zipFile));){
            String file1 = "zipFile";
            ZipArchiveEntry entry = new ZipArchiveEntry(file1);
            entry.setUnixMode(237);
            zipOut.putArchiveEntry((ArchiveEntry)entry);
            zipOut.write(new byte[]{1, 1, 1, 1, 1});
            zipOut.closeArchiveEntry();
        }
        String targetPath = this.temporaryFolder.newFolder().getCanonicalPath();
        ZipUtils.extractZipFileWithPermissions((String)zipFile.getCanonicalPath(), (String)targetPath);
        Path path = new File(targetPath, "zipFile").toPath();
        Assert.assertEquals((long)237L, (long)this.toUnixMode(Files.getPosixFilePermissions(path, new LinkOption[0])));
    }

    private int toUnixMode(Set<PosixFilePermission> permission) {
        int mode = 0;
        for (PosixFilePermission action : PosixFilePermission.values()) {
            mode <<= 1;
            mode += permission.contains((Object)action) ? 1 : 0;
        }
        return mode;
    }
}

