/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.python.PythonOptions;
import org.apache.flink.python.util.PythonDependencyUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PythonDependencyUtilsTest {
    private List<Tuple2<String, DistributedCache.DistributedCacheEntry>> cachedFiles;

    @Before
    public void setUp() {
        this.cachedFiles = new ArrayList<Tuple2<String, DistributedCache.DistributedCacheEntry>>();
    }

    @Test
    public void testPythonFiles() {
        Configuration config = new Configuration();
        config.set(PythonOptions.PYTHON_FILES, (Object)"hdfs:///tmp_dir/test_file1.py,tmp_dir/test_file2.py,tmp_dir/test_dir,hdfs:///tmp_dir/test_file1.py");
        Configuration actual = PythonDependencyUtils.configurePythonDependencies(this.cachedFiles, (Configuration)config);
        HashMap<String, String> expectedCachedFiles = new HashMap<String, String>();
        expectedCachedFiles.put("python_file_83bbdaee494ad7d9b334c02ec71dc86a0868f7f8e49d1249a37c517dc6ee15a7", "hdfs:///tmp_dir/test_file1.py");
        expectedCachedFiles.put("python_file_e57a895cb1256500098be0874128680cd9f56000d48fcd393c48d6371bd2d947", "tmp_dir/test_file2.py");
        expectedCachedFiles.put("python_file_e56bc55ff643576457b3d012b2bba888727c71cf05a958930f2263398c4e9798", "tmp_dir/test_dir");
        this.verifyCachedFiles(expectedCachedFiles);
        Configuration expectedConfiguration = new Configuration(config);
        expectedConfiguration.set(PythonDependencyUtils.PYTHON_FILES, new HashMap());
        ((Map)expectedConfiguration.get(PythonDependencyUtils.PYTHON_FILES)).put("python_file_83bbdaee494ad7d9b334c02ec71dc86a0868f7f8e49d1249a37c517dc6ee15a7", "test_file1.py");
        ((Map)expectedConfiguration.get(PythonDependencyUtils.PYTHON_FILES)).put("python_file_e57a895cb1256500098be0874128680cd9f56000d48fcd393c48d6371bd2d947", "test_file2.py");
        ((Map)expectedConfiguration.get(PythonDependencyUtils.PYTHON_FILES)).put("python_file_e56bc55ff643576457b3d012b2bba888727c71cf05a958930f2263398c4e9798", "test_dir");
        this.verifyConfiguration(expectedConfiguration, actual);
    }

    @Test
    public void testPythonRequirements() {
        Configuration config = new Configuration();
        config.set(PythonOptions.PYTHON_REQUIREMENTS, (Object)"tmp_dir/requirements.txt");
        Configuration actual = PythonDependencyUtils.configurePythonDependencies(this.cachedFiles, (Configuration)config);
        HashMap<String, String> expectedCachedFiles = new HashMap<String, String>();
        expectedCachedFiles.put("python_requirements_file_69390ca43c69ada3819226fcfbb5b6d27e111132a9427e7f201edd82e9d65ff6", "tmp_dir/requirements.txt");
        this.verifyCachedFiles(expectedCachedFiles);
        Configuration expectedConfiguration = new Configuration(config);
        expectedConfiguration.set(PythonDependencyUtils.PYTHON_REQUIREMENTS_FILE, new HashMap());
        ((Map)expectedConfiguration.get(PythonDependencyUtils.PYTHON_REQUIREMENTS_FILE)).put("file", "python_requirements_file_69390ca43c69ada3819226fcfbb5b6d27e111132a9427e7f201edd82e9d65ff6");
        this.verifyConfiguration(expectedConfiguration, actual);
        config.set(PythonOptions.PYTHON_REQUIREMENTS, (Object)"tmp_dir/requirements2.txt#tmp_dir/cache");
        actual = PythonDependencyUtils.configurePythonDependencies(this.cachedFiles, (Configuration)config);
        expectedCachedFiles = new HashMap();
        expectedCachedFiles.put("python_requirements_file_56fd0c530faaa7129dca8d314cf69cbfc7c1c5c952f5176a003253e2f418873e", "tmp_dir/requirements2.txt");
        expectedCachedFiles.put("python_requirements_cache_2f563dd6731c2c7c5e1ef1ef8279f61e907dc3bfc698adb71b109e43ed93e143", "tmp_dir/cache");
        this.verifyCachedFiles(expectedCachedFiles);
        expectedConfiguration = new Configuration(config);
        expectedConfiguration.set(PythonDependencyUtils.PYTHON_REQUIREMENTS_FILE, new HashMap());
        ((Map)expectedConfiguration.get(PythonDependencyUtils.PYTHON_REQUIREMENTS_FILE)).put("file", "python_requirements_file_56fd0c530faaa7129dca8d314cf69cbfc7c1c5c952f5176a003253e2f418873e");
        ((Map)expectedConfiguration.get(PythonDependencyUtils.PYTHON_REQUIREMENTS_FILE)).put("cache", "python_requirements_cache_2f563dd6731c2c7c5e1ef1ef8279f61e907dc3bfc698adb71b109e43ed93e143");
        this.verifyConfiguration(expectedConfiguration, actual);
    }

    @Test
    public void testPythonArchives() {
        Configuration config = new Configuration();
        config.set(PythonOptions.PYTHON_ARCHIVES, (Object)"hdfs:///tmp_dir/file1.zip,hdfs:///tmp_dir/file1.zip,tmp_dir/py37.zip,tmp_dir/py37.zip#venv,tmp_dir/py37.zip#venv2,tmp_dir/py37.zip#venv");
        Configuration actual = PythonDependencyUtils.configurePythonDependencies(this.cachedFiles, (Configuration)config);
        HashMap<String, String> expectedCachedFiles = new HashMap<String, String>();
        expectedCachedFiles.put("python_archive_4cc74e4003de886434723f351771df2a84f72531c52085acc0915e19d70df2ba", "hdfs:///tmp_dir/file1.zip");
        expectedCachedFiles.put("python_archive_b9ceeb8434d3335ec0ba298bbd52768bf5e4d136df3e157500fe4f413a1f416c", "tmp_dir/py37.zip");
        expectedCachedFiles.put("python_archive_5f3fca2a4165c7d9c94b00bfab956c15f14c41e9e03f6037c83eb61157fce09c", "tmp_dir/py37.zip");
        expectedCachedFiles.put("python_archive_44532e54ce38086fcc235a2af12479a7305820f7f39767f0215c454df54024dd", "tmp_dir/py37.zip");
        this.verifyCachedFiles(expectedCachedFiles);
        Configuration expectedConfiguration = new Configuration(config);
        expectedConfiguration.set(PythonDependencyUtils.PYTHON_ARCHIVES, new HashMap());
        ((Map)expectedConfiguration.get(PythonDependencyUtils.PYTHON_ARCHIVES)).put("python_archive_4cc74e4003de886434723f351771df2a84f72531c52085acc0915e19d70df2ba", "file1.zip");
        ((Map)expectedConfiguration.get(PythonDependencyUtils.PYTHON_ARCHIVES)).put("python_archive_5f3fca2a4165c7d9c94b00bfab956c15f14c41e9e03f6037c83eb61157fce09c", "py37.zip");
        ((Map)expectedConfiguration.get(PythonDependencyUtils.PYTHON_ARCHIVES)).put("python_archive_b9ceeb8434d3335ec0ba298bbd52768bf5e4d136df3e157500fe4f413a1f416c", "venv");
        ((Map)expectedConfiguration.get(PythonDependencyUtils.PYTHON_ARCHIVES)).put("python_archive_44532e54ce38086fcc235a2af12479a7305820f7f39767f0215c454df54024dd", "venv2");
        this.verifyConfiguration(expectedConfiguration, actual);
    }

    @Test
    public void testPythonExecutables() {
        Configuration config = new Configuration();
        config.set(PythonOptions.PYTHON_EXECUTABLE, (Object)"venv/bin/python3");
        config.set(PythonOptions.PYTHON_CLIENT_EXECUTABLE, (Object)"python37");
        Configuration actual = PythonDependencyUtils.configurePythonDependencies(this.cachedFiles, (Configuration)config);
        Configuration expectedConfiguration = new Configuration();
        expectedConfiguration.set(PythonOptions.PYTHON_EXECUTABLE, (Object)"venv/bin/python3");
        expectedConfiguration.set(PythonOptions.PYTHON_CLIENT_EXECUTABLE, (Object)"python37");
        this.verifyConfiguration(expectedConfiguration, actual);
    }

    @Test
    public void testPythonDependencyConfigMerge() {
        Configuration config = new Configuration();
        config.set(PythonOptions.PYTHON_ARCHIVES, (Object)"hdfs:///tmp_dir/file1.zip,hdfs:///tmp_dir/file2.zip");
        config.set(PythonOptions.PYTHON_FILES, (Object)"hdfs:///tmp_dir/file3.zip,hdfs:///tmp_dir/file4.zip");
        Configuration config2 = new Configuration();
        config2.set(PythonOptions.PYTHON_ARCHIVES, (Object)"hdfs:///tmp_dir/file5.zip,hdfs:///tmp_dir/file6.zip");
        config2.set(PythonOptions.PYTHON_FILES, (Object)"hdfs:///tmp_dir/file7.zip,hdfs:///tmp_dir/file8.zip");
        Configuration expectedConfiguration = new Configuration();
        expectedConfiguration.set(PythonOptions.PYTHON_ARCHIVES, (Object)"hdfs:///tmp_dir/file5.zip,hdfs:///tmp_dir/file6.zip,hdfs:///tmp_dir/file1.zip,hdfs:///tmp_dir/file2.zip");
        expectedConfiguration.set(PythonOptions.PYTHON_FILES, (Object)"hdfs:///tmp_dir/file7.zip,hdfs:///tmp_dir/file8.zip,hdfs:///tmp_dir/file3.zip,hdfs:///tmp_dir/file4.zip");
        PythonDependencyUtils.merge((Configuration)config, (Configuration)config2);
        this.verifyConfiguration(expectedConfiguration, config);
    }

    private void verifyCachedFiles(Map<String, String> expected) {
        Map<String, String> actual = this.cachedFiles.stream().collect(Collectors.toMap(t -> (String)t.f0, t -> ((DistributedCache.DistributedCacheEntry)t.f1).filePath));
        Assert.assertEquals(expected, actual);
    }

    private void verifyConfiguration(Configuration expected, Configuration actual) {
        Properties actualProperties = new Properties();
        actual.addAllToProperties(actualProperties);
        Properties expectedProperties = new Properties();
        expected.addAllToProperties(expectedProperties);
        Assert.assertEquals((Object)expectedProperties, (Object)actualProperties);
    }
}

