/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python.util;

import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.types.Row;

public class PartitionCustomTestMapFunction
extends RichMapFunction<Row, Row> {
    private int currentTaskIndex;

    public void open(Configuration parameters) {
        this.currentTaskIndex = this.getRuntimeContext().getIndexOfThisSubtask();
    }

    public Row map(Row value) throws Exception {
        int expectedPartitionIndex = (Integer)value.getField(1) % this.getRuntimeContext().getNumberOfParallelSubtasks();
        if (expectedPartitionIndex != this.currentTaskIndex) {
            throw new RuntimeException(String.format("the data: Row<%s> was sent to the wrong partition[%d], expected partition is [%d].", value.toString(), this.currentTaskIndex, expectedPartitionIndex));
        }
        return value;
    }
}

