/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;

public class DataStreamTestCollectSink<IN>
implements SinkFunction<IN> {
    private static List<Object> collectedResult = new ArrayList<Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(IN value, SinkFunction.Context context) throws Exception {
        List<Object> list = collectedResult;
        synchronized (list) {
            collectedResult.add(value);
        }
    }

    public List<Object> collectAndClear(boolean isPythonObjects) {
        ArrayList<Object> listToBeReturned = new ArrayList<Object>();
        if (isPythonObjects) {
            listToBeReturned.addAll(collectedResult);
        } else {
            for (Object obj : collectedResult) {
                listToBeReturned.add(obj.toString());
            }
        }
        this.clear();
        return listToBeReturned;
    }

    public void clear() {
        collectedResult.clear();
    }
}

