/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python.env.beam;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.flink.python.env.PythonDependencyInfo;
import org.apache.flink.python.env.beam.ProcessPythonEnvironmentManager;
import org.apache.flink.util.OperatingSystem;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ProcessPythonEnvironmentManagerTest {
    private static String tmpDir;
    private static boolean isUnix;

    @BeforeClass
    public static void prepareTempDirectory() throws IOException {
        FileOutputStream out;
        Serializable fileInDirs;
        int i;
        File tmpFile = File.createTempFile("process_environment_manager_test", "");
        if (!tmpFile.delete() || !tmpFile.mkdirs()) {
            throw new IOException("Create temp directory: " + tmpFile.getAbsolutePath() + " failed!");
        }
        tmpDir = tmpFile.getAbsolutePath();
        for (i = 0; i < 6; ++i) {
            File distributedFile = new File(tmpDir, "file" + i);
            try (FileOutputStream out2 = new FileOutputStream(distributedFile);){
                out2.write(i);
                continue;
            }
        }
        for (i = 0; i < 2; ++i) {
            File distributedDirectory = new File(tmpDir, "dir" + i);
            if (distributedDirectory.mkdirs()) {
                for (int j = 0; j < 2; ++j) {
                    fileInDirs = new File(tmpDir, "dir" + i + File.separator + "file" + j);
                    out = new FileOutputStream((File)fileInDirs);
                    Throwable throwable = null;
                    try {
                        out.write(i);
                        out.write(j);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                continue;
            }
            throw new IOException("Create temp dir: " + distributedDirectory.getAbsolutePath() + " failed!");
        }
        isUnix = OperatingSystem.isFreeBSD() || OperatingSystem.isLinux() || OperatingSystem.isMac() || OperatingSystem.isSolaris();
        for (i = 0; i < 2; ++i) {
            Object zipfile1;
            File zipFile = new File(tmpDir, "zip" + i);
            ZipArchiveOutputStream zipOut = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(zipFile));
            fileInDirs = null;
            try {
                ZipArchiveEntry zipfile0 = new ZipArchiveEntry("zipDir" + i + "/zipfile0");
                zipfile0.setUnixMode(457);
                zipOut.putArchiveEntry((ArchiveEntry)zipfile0);
                zipOut.write(new byte[]{1, 1, 1, 1, 1});
                zipOut.closeArchiveEntry();
                zipfile1 = new ZipArchiveEntry("zipDir" + i + "/zipfile1");
                zipfile1.setUnixMode(420);
                zipOut.putArchiveEntry((ArchiveEntry)zipfile1);
                zipOut.write(new byte[]{2, 2, 2, 2, 2});
                zipOut.closeArchiveEntry();
            }
            catch (Throwable zipfile0) {
                fileInDirs = zipfile0;
                throw zipfile0;
            }
            finally {
                if (zipOut != null) {
                    if (fileInDirs != null) {
                        try {
                            zipOut.close();
                        }
                        catch (Throwable zipfile0) {
                            ((Throwable)fileInDirs).addSuppressed(zipfile0);
                        }
                    } else {
                        zipOut.close();
                    }
                }
            }
            File zipExpected = new File(String.join((CharSequence)File.separator, tmpDir, "zipExpected" + i, "zipDir" + i));
            if (!zipExpected.mkdirs()) {
                throw new IOException("Create temp dir: " + zipExpected.getAbsolutePath() + " failed!");
            }
            File zipfile0 = new File(zipExpected, "zipfile0");
            out = new FileOutputStream(zipfile0);
            zipfile1 = null;
            try {
                out.write(new byte[]{1, 1, 1, 1, 1});
            }
            catch (Throwable throwable) {
                zipfile1 = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    if (zipfile1 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)zipfile1).addSuppressed(throwable);
                        }
                    } else {
                        out.close();
                    }
                }
            }
            File zipfile12 = new File(zipExpected, "zipfile1");
            try (FileOutputStream out3 = new FileOutputStream(zipfile12);){
                out3.write(new byte[]{2, 2, 2, 2, 2});
            }
            if (!isUnix) continue;
            if (!(zipfile0.setReadable(true, true) && zipfile0.setWritable(true, true) && zipfile0.setExecutable(true))) {
                throw new IOException("Set unixmode 711 to temp file: " + zipfile0.getAbsolutePath() + "failed!");
            }
            if (zipfile12.setReadable(true) && zipfile12.setWritable(true, true) && zipfile12.setExecutable(false)) continue;
            throw new IOException("Set unixmode 644 to temp file: " + zipfile12.getAbsolutePath() + "failed!");
        }
    }

    @AfterClass
    public static void cleanTempDirectory() {
        if (tmpDir != null) {
            org.apache.flink.util.FileUtils.deleteDirectoryQuietly((File)new File(tmpDir));
            tmpDir = null;
        }
    }

    @Test
    public void testPythonFiles() throws Exception {
        LinkedHashMap<String, String> pythonFiles = new LinkedHashMap<String, String>();
        pythonFiles.put(String.join((CharSequence)File.separator, tmpDir, "zip0"), "test_zip.zip");
        pythonFiles.put(String.join((CharSequence)File.separator, tmpDir, "file1"), "test_file1.py");
        pythonFiles.put(String.join((CharSequence)File.separator, tmpDir, "file2"), "test_file2.egg");
        pythonFiles.put(String.join((CharSequence)File.separator, tmpDir, "dir0"), "test_dir");
        PythonDependencyInfo dependencyInfo = new PythonDependencyInfo(pythonFiles, null, null, new HashMap(), "python");
        try (ProcessPythonEnvironmentManager environmentManager = ProcessPythonEnvironmentManagerTest.createBasicPythonEnvironmentManager(dependencyInfo);){
            environmentManager.open();
            Map environmentVariable = environmentManager.constructEnvironmentVariables();
            String baseDir = environmentManager.getBaseDirectory();
            CharSequence[] expectedUserPythonPaths = new String[]{String.join((CharSequence)File.separator, baseDir, "python-files", "zip0", "test_zip"), String.join((CharSequence)File.separator, baseDir, "python-files", "file1"), String.join((CharSequence)File.separator, baseDir, "python-files", "file2", "test_file2.egg"), String.join((CharSequence)File.separator, baseDir, "python-files", "dir0", "test_dir")};
            String expectedPythonPath = String.join((CharSequence)File.pathSeparator, expectedUserPythonPaths);
            Assert.assertEquals((Object)expectedPythonPath, environmentVariable.get("PYTHONPATH"));
            ProcessPythonEnvironmentManagerTest.assertFileEquals(new File(String.join((CharSequence)File.separator, tmpDir, "file1")), new File(String.join((CharSequence)File.separator, baseDir, "python-files", "file1", "test_file1.py")));
            ProcessPythonEnvironmentManagerTest.assertFileEquals(new File(String.join((CharSequence)File.separator, tmpDir, "zipExpected0")), new File(String.join((CharSequence)File.separator, baseDir, "python-files", "zip0", "test_zip")));
            ProcessPythonEnvironmentManagerTest.assertFileEquals(new File(String.join((CharSequence)File.separator, tmpDir, "file2")), new File(String.join((CharSequence)File.separator, baseDir, "python-files", "file2", "test_file2.egg")));
            ProcessPythonEnvironmentManagerTest.assertFileEquals(new File(String.join((CharSequence)File.separator, tmpDir, "dir0")), new File(String.join((CharSequence)File.separator, baseDir, "python-files", "dir0", "test_dir")));
        }
    }

    @Test
    public void testRequirements() throws Exception {
        PythonDependencyInfo dependencyInfo = new PythonDependencyInfo(new HashMap(), String.join((CharSequence)File.separator, tmpDir, "file0"), String.join((CharSequence)File.separator, tmpDir, "dir0"), new HashMap(), "python");
        try (ProcessPythonEnvironmentManager environmentManager = ProcessPythonEnvironmentManagerTest.createBasicPythonEnvironmentManager(dependencyInfo);){
            environmentManager.open();
            Map environmentVariable = environmentManager.constructEnvironmentVariables();
            String tmpBase = environmentManager.getBaseDirectory();
            Map<String, String> expected = ProcessPythonEnvironmentManagerTest.getBasicExpectedEnv(environmentManager);
            expected.put("_PYTHON_REQUIREMENTS_FILE", String.join((CharSequence)File.separator, tmpDir, "file0"));
            expected.put("_PYTHON_REQUIREMENTS_CACHE", String.join((CharSequence)File.separator, tmpDir, "dir0"));
            expected.put("_PYTHON_REQUIREMENTS_INSTALL_DIR", String.join((CharSequence)File.separator, tmpBase, "python-requirements"));
            Assert.assertEquals(expected, (Object)environmentVariable);
        }
    }

    @Test
    public void testArchives() throws Exception {
        LinkedHashMap<String, String> archives = new LinkedHashMap<String, String>();
        archives.put(String.join((CharSequence)File.separator, tmpDir, "zip0"), "py27.zip");
        archives.put(String.join((CharSequence)File.separator, tmpDir, "zip1"), "py37");
        PythonDependencyInfo dependencyInfo = new PythonDependencyInfo(new HashMap(), null, null, archives, "python");
        try (ProcessPythonEnvironmentManager environmentManager = ProcessPythonEnvironmentManagerTest.createBasicPythonEnvironmentManager(dependencyInfo);){
            environmentManager.open();
            Map environmentVariable = environmentManager.constructEnvironmentVariables();
            String tmpBase = environmentManager.getBaseDirectory();
            Map<String, String> expected = ProcessPythonEnvironmentManagerTest.getBasicExpectedEnv(environmentManager);
            expected.put("_PYTHON_WORKING_DIR", String.join((CharSequence)File.separator, tmpBase, "python-archives"));
            Assert.assertEquals(expected, (Object)environmentVariable);
            ProcessPythonEnvironmentManagerTest.assertFileEquals(new File(String.join((CharSequence)File.separator, tmpDir, "zipExpected0")), new File(String.join((CharSequence)File.separator, tmpBase, "python-archives", "py27.zip")), true);
            ProcessPythonEnvironmentManagerTest.assertFileEquals(new File(String.join((CharSequence)File.separator, tmpDir, "zipExpected1")), new File(String.join((CharSequence)File.separator, tmpBase, "python-archives", "py37")), true);
        }
    }

    @Test
    public void testPythonExecutable() throws Exception {
        PythonDependencyInfo dependencyInfo = new PythonDependencyInfo(new HashMap(), null, null, new HashMap(), "/usr/local/bin/python");
        try (ProcessPythonEnvironmentManager environmentManager = ProcessPythonEnvironmentManagerTest.createBasicPythonEnvironmentManager(dependencyInfo);){
            environmentManager.open();
            Map environmentVariable = environmentManager.constructEnvironmentVariables();
            Map<String, String> expected = ProcessPythonEnvironmentManagerTest.getBasicExpectedEnv(environmentManager);
            expected.put("python", "/usr/local/bin/python");
            Assert.assertEquals(expected, (Object)environmentVariable);
        }
    }

    @Test
    public void testCreateRetrievalToken() throws Exception {
        PythonDependencyInfo dependencyInfo = new PythonDependencyInfo(new HashMap(), null, null, new HashMap(), "python");
        HashMap<String, String> sysEnv = new HashMap<String, String>();
        sysEnv.put("FLINK_HOME", "/flink");
        try (ProcessPythonEnvironmentManager environmentManager = new ProcessPythonEnvironmentManager(dependencyInfo, new String[]{tmpDir}, sysEnv);){
            environmentManager.open();
            String retrievalToken = environmentManager.createRetrievalToken();
            File retrievalTokenFile = new File(retrievalToken);
            byte[] content = new byte[(int)retrievalTokenFile.length()];
            try (DataInputStream input = new DataInputStream(new FileInputStream(retrievalToken));){
                input.readFully(content);
            }
            Assert.assertEquals((Object)"{\"manifest\": {}}", (Object)new String(content));
        }
    }

    @Test
    public void testSetLogDirectory() throws Exception {
        PythonDependencyInfo dependencyInfo = new PythonDependencyInfo(new HashMap(), null, null, new HashMap(), "python");
        try (ProcessPythonEnvironmentManager environmentManager = new ProcessPythonEnvironmentManager(dependencyInfo, new String[]{tmpDir}, new HashMap());){
            environmentManager.open();
            Map env = environmentManager.constructEnvironmentVariables();
            Map<String, String> expected = ProcessPythonEnvironmentManagerTest.getBasicExpectedEnv(environmentManager);
            expected.put("BOOT_LOG_DIR", environmentManager.getBaseDirectory());
            Assert.assertEquals(expected, (Object)env);
        }
    }

    @Test
    public void testOpenClose() throws Exception {
        PythonDependencyInfo dependencyInfo = new PythonDependencyInfo(new HashMap(), null, null, new HashMap(), "python");
        try (ProcessPythonEnvironmentManager environmentManager = ProcessPythonEnvironmentManagerTest.createBasicPythonEnvironmentManager(dependencyInfo);){
            environmentManager.open();
            environmentManager.createRetrievalToken();
            String tmpBase = environmentManager.getBaseDirectory();
            Assert.assertTrue((boolean)new File(tmpBase).isDirectory());
            environmentManager.close();
            Assert.assertFalse((boolean)new File(tmpBase).exists());
        }
    }

    private static void assertFileEquals(File expectedFile, File actualFile) throws IOException, NoSuchAlgorithmException {
        ProcessPythonEnvironmentManagerTest.assertFileEquals(expectedFile, actualFile, false);
    }

    private static void assertFileEquals(File expectedFile, File actualFile, boolean checkUnixMode) throws IOException, NoSuchAlgorithmException {
        Assert.assertTrue((boolean)actualFile.exists());
        Assert.assertTrue((boolean)expectedFile.exists());
        if (expectedFile.getAbsolutePath().equals(actualFile.getAbsolutePath())) {
            return;
        }
        if (isUnix && checkUnixMode) {
            Set<PosixFilePermission> expectedPerm = Files.getPosixFilePermissions(Paths.get(expectedFile.toURI()), new LinkOption[0]);
            Set<PosixFilePermission> actualPerm = Files.getPosixFilePermissions(Paths.get(actualFile.toURI()), new LinkOption[0]);
            Assert.assertEquals(expectedPerm, actualPerm);
        }
        if (expectedFile.isDirectory()) {
            Assert.assertTrue((boolean)actualFile.isDirectory());
            Object[] expectedSubFiles = expectedFile.list();
            Assert.assertArrayEquals((Object[])expectedSubFiles, (Object[])actualFile.list());
            if (expectedSubFiles != null) {
                for (Object fileName : expectedSubFiles) {
                    ProcessPythonEnvironmentManagerTest.assertFileEquals(new File(expectedFile.getAbsolutePath(), (String)fileName), new File(actualFile.getAbsolutePath(), (String)fileName));
                }
            }
        } else {
            Assert.assertEquals((long)expectedFile.length(), (long)actualFile.length());
            if (expectedFile.length() > 0L) {
                Assert.assertTrue((boolean)FileUtils.contentEquals((File)expectedFile, (File)actualFile));
            }
        }
    }

    private static Map<String, String> getBasicExpectedEnv(ProcessPythonEnvironmentManager environmentManager) {
        HashMap<String, String> map = new HashMap<String, String>();
        String tmpBase = environmentManager.getBaseDirectory();
        map.put("python", "python");
        map.put("BOOT_LOG_DIR", tmpBase);
        map.put("PYFLINK_GATEWAY_DISABLED", "true");
        return map;
    }

    private static ProcessPythonEnvironmentManager createBasicPythonEnvironmentManager(PythonDependencyInfo dependencyInfo) {
        return new ProcessPythonEnvironmentManager(dependencyInfo, new String[]{tmpDir}, new HashMap());
    }
}

