/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.python.PythonConfig;
import org.apache.flink.python.PythonOptions;
import org.apache.flink.python.util.PythonDependencyUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class PythonConfigTest {
    @Test
    public void testDefaultConfigure() {
        PythonConfig pythonConfig = new PythonConfig(new Configuration());
        Assert.assertThat((Object)pythonConfig.getMaxBundleSize(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)PythonOptions.MAX_BUNDLE_SIZE.defaultValue())));
        Assert.assertThat((Object)pythonConfig.getMaxBundleTimeMills(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)PythonOptions.MAX_BUNDLE_TIME_MILLS.defaultValue())));
        Assert.assertThat((Object)pythonConfig.getMaxArrowBatchSize(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)PythonOptions.MAX_ARROW_BATCH_SIZE.defaultValue())));
        Assert.assertThat((Object)pythonConfig.getPythonFilesInfo().isEmpty(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)pythonConfig.getPythonRequirementsFileInfo().isPresent(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)pythonConfig.getPythonRequirementsCacheDirInfo().isPresent(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)pythonConfig.getPythonArchivesInfo().isEmpty(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)pythonConfig.getPythonExec(), (Matcher)Matchers.is((Object)"python"));
        Assert.assertThat((Object)pythonConfig.isUsingManagedMemory(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)PythonOptions.USE_MANAGED_MEMORY.defaultValue())));
    }

    @Test
    public void testMaxBundleSize() {
        Configuration config = new Configuration();
        config.set(PythonOptions.MAX_BUNDLE_SIZE, (Object)10);
        PythonConfig pythonConfig = new PythonConfig(config);
        Assert.assertThat((Object)pythonConfig.getMaxBundleSize(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)10)));
    }

    @Test
    public void testMaxBundleTimeMills() {
        Configuration config = new Configuration();
        config.set(PythonOptions.MAX_BUNDLE_TIME_MILLS, (Object)10L);
        PythonConfig pythonConfig = new PythonConfig(config);
        Assert.assertThat((Object)pythonConfig.getMaxBundleTimeMills(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)10L)));
    }

    @Test
    public void testMaxArrowBatchSize() {
        Configuration config = new Configuration();
        config.set(PythonOptions.MAX_ARROW_BATCH_SIZE, (Object)10);
        PythonConfig pythonConfig = new PythonConfig(config);
        Assert.assertThat((Object)pythonConfig.getMaxArrowBatchSize(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)10)));
    }

    @Test
    public void testPythonFilesInfo() {
        Configuration config = new Configuration();
        HashMap<String, String> pythonFiles = new HashMap<String, String>();
        pythonFiles.put("python_file_{SHA256}", "file0.py");
        config.set(PythonDependencyUtils.PYTHON_FILES, pythonFiles);
        PythonConfig pythonConfig = new PythonConfig(config);
        Assert.assertThat((Object)pythonConfig.getPythonFilesInfo(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(pythonFiles)));
    }

    @Test
    public void testPythonRequirementsFileInfo() {
        Configuration config = new Configuration();
        Map pythonRequirementsFile = config.getOptional(PythonDependencyUtils.PYTHON_REQUIREMENTS_FILE).orElse(new HashMap());
        pythonRequirementsFile.put("file", "python_requirements_file_{SHA256}");
        config.set(PythonDependencyUtils.PYTHON_REQUIREMENTS_FILE, (Object)pythonRequirementsFile);
        PythonConfig pythonConfig = new PythonConfig(config);
        Assert.assertThat(pythonConfig.getPythonRequirementsFileInfo().get(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"python_requirements_file_{SHA256}")));
    }

    @Test
    public void testPythonRequirementsCacheDirInfo() {
        Configuration config = new Configuration();
        Map pythonRequirementsFile = config.getOptional(PythonDependencyUtils.PYTHON_REQUIREMENTS_FILE).orElse(new HashMap());
        pythonRequirementsFile.put("cache", "python_requirements_cache_{SHA256}");
        config.set(PythonDependencyUtils.PYTHON_REQUIREMENTS_FILE, (Object)pythonRequirementsFile);
        PythonConfig pythonConfig = new PythonConfig(config);
        Assert.assertThat(pythonConfig.getPythonRequirementsCacheDirInfo().get(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"python_requirements_cache_{SHA256}")));
    }

    @Test
    public void testPythonArchivesInfo() {
        Configuration config = new Configuration();
        HashMap<String, String> pythonArchives = new HashMap<String, String>();
        pythonArchives.put("python_archive_{SHA256}", "file0.zip");
        config.set(PythonDependencyUtils.PYTHON_ARCHIVES, pythonArchives);
        PythonConfig pythonConfig = new PythonConfig(config);
        Assert.assertThat((Object)pythonConfig.getPythonArchivesInfo(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(pythonArchives)));
    }

    @Test
    public void testPythonExec() {
        Configuration config = new Configuration();
        config.set(PythonOptions.PYTHON_EXECUTABLE, (Object)"/usr/local/bin/python3");
        PythonConfig pythonConfig = new PythonConfig(config);
        Assert.assertThat((Object)pythonConfig.getPythonExec(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"/usr/local/bin/python3")));
    }

    @Test
    public void testManagedMemory() {
        Configuration config = new Configuration();
        config.set(PythonOptions.USE_MANAGED_MEMORY, (Object)true);
        PythonConfig pythonConfig = new PythonConfig(config);
        Assert.assertThat((Object)pythonConfig.isUsingManagedMemory(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)true)));
    }
}

