/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.utils;

import java.util.HashMap;
import org.apache.beam.runners.core.construction.graph.ExecutableStage;
import org.apache.beam.runners.fnexecution.control.BundleProgressHandler;
import org.apache.beam.runners.fnexecution.control.JobBundleFactory;
import org.apache.beam.runners.fnexecution.control.OutputReceiverFactory;
import org.apache.beam.runners.fnexecution.control.RemoteBundle;
import org.apache.beam.runners.fnexecution.control.StageBundleFactory;
import org.apache.beam.runners.fnexecution.state.StateRequestHandler;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.python.env.PythonDependencyInfo;
import org.apache.flink.python.env.PythonEnvironmentManager;
import org.apache.flink.python.env.beam.ProcessPythonEnvironmentManager;
import org.apache.flink.python.metric.FlinkMetricContainer;
import org.apache.flink.runtime.metrics.NoOpMetricRegistry;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.flink.runtime.metrics.groups.GenericMetricGroup;
import org.apache.flink.runtime.metrics.groups.MetricGroupTest;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public final class PythonTestUtils {
    public static JobBundleFactory createMockJobBundleFactory() {
        JobBundleFactory jobBundleFactorySpy = (JobBundleFactory)Mockito.spy(JobBundleFactory.class);
        StageBundleFactory stageBundleFactorySpy = (StageBundleFactory)Mockito.spy(StageBundleFactory.class);
        Mockito.when((Object)jobBundleFactorySpy.forStage((ExecutableStage)ArgumentMatchers.any())).thenReturn((Object)stageBundleFactorySpy);
        RemoteBundle remoteBundleSpy = (RemoteBundle)Mockito.spy(RemoteBundle.class);
        try {
            Mockito.when((Object)stageBundleFactorySpy.getBundle((OutputReceiverFactory)ArgumentMatchers.any(), (StateRequestHandler)ArgumentMatchers.any(), (BundleProgressHandler)ArgumentMatchers.any())).thenReturn((Object)remoteBundleSpy);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap<String, FnDataReceiver> inputReceivers = new HashMap<String, FnDataReceiver>();
        FnDataReceiver windowedValueReceiverSpy = (FnDataReceiver)Mockito.spy(FnDataReceiver.class);
        inputReceivers.put("input", windowedValueReceiverSpy);
        Mockito.when((Object)remoteBundleSpy.getInputReceivers()).thenReturn(inputReceivers);
        return jobBundleFactorySpy;
    }

    public static FlinkMetricContainer createMockFlinkMetricContainer() {
        return new FlinkMetricContainer((MetricGroup)new GenericMetricGroup(NoOpMetricRegistry.INSTANCE, (AbstractMetricGroup)new MetricGroupTest.DummyAbstractMetricGroup(NoOpMetricRegistry.INSTANCE), "root"));
    }

    public static PythonEnvironmentManager createTestEnvironmentManager() {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("PYFLINK_UDF_RUNNER_DIR", "");
        return new ProcessPythonEnvironmentManager(new PythonDependencyInfo(new HashMap(), null, null, new HashMap(), "python"), new String[]{System.getProperty("java.io.tmpdir")}, env);
    }
}

