/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils.serializers.python;

import java.util.Objects;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.testutils.DeeplyEqualsChecker;

public class RowDataSerializerTest
extends SerializerTestBase<RowData> {
    public RowDataSerializerTest() {
        super(new DeeplyEqualsChecker().withCustomCheck((o1, o2) -> o1 instanceof RowData && o2 instanceof RowData, (o1, o2, checker) -> {
            LogicalType[] fieldTypes = new LogicalType[]{new BigIntType(), new BigIntType()};
            RowDataSerializer serializer = new RowDataSerializer(fieldTypes);
            return RowDataSerializerTest.deepEqualsRowData((RowData)o1, (RowData)o2, (RowDataSerializer)serializer.duplicate(), (RowDataSerializer)serializer.duplicate());
        }));
    }

    protected TypeSerializer<RowData> createSerializer() {
        TypeSerializer[] fieldTypeSerializers = new TypeSerializer[]{LongSerializer.INSTANCE, LongSerializer.INSTANCE};
        LogicalType[] fieldTypes = new LogicalType[]{new BigIntType(), new BigIntType()};
        return new org.apache.flink.table.runtime.typeutils.serializers.python.RowDataSerializer(fieldTypes, fieldTypeSerializers);
    }

    protected int getLength() {
        return -1;
    }

    protected Class<RowData> getTypeClass() {
        return RowData.class;
    }

    private static boolean deepEqualsRowData(RowData should, RowData is, RowDataSerializer serializer1, RowDataSerializer serializer2) {
        if (should.getArity() != is.getArity()) {
            return false;
        }
        BinaryRowData row1 = serializer1.toBinaryRow(should);
        BinaryRowData row2 = serializer2.toBinaryRow(is);
        return Objects.equals(row1, row2);
    }

    protected RowData[] getTestData() {
        RowData row1 = StreamRecordUtils.row((Object[])new Object[]{null, 1L});
        BinaryRowData row2 = StreamRecordUtils.binaryrow((Object[])new Object[]{1L, null});
        return new RowData[]{row1, row2};
    }
}

