/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils.serializers.python;

import java.util.HashMap;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.FloatSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.binary.BinaryArrayData;
import org.apache.flink.table.data.binary.BinaryMapData;
import org.apache.flink.table.data.util.MapDataUtil;
import org.apache.flink.table.runtime.typeutils.serializers.python.MapDataSerializer;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.testutils.DeeplyEqualsChecker;

public class MapDataSerializerTest
extends SerializerTestBase<MapData> {
    private static final LogicalType BIGINT = DataTypes.BIGINT().getLogicalType();
    private static final LogicalType FLOAT = DataTypes.FLOAT().getLogicalType();

    public MapDataSerializerTest() {
        super(new DeeplyEqualsChecker().withCustomCheck((o1, o2) -> o1 instanceof MapData && o2 instanceof MapData, (o1, o2, checker) -> MapDataUtil.convertToJavaMap((MapData)((MapData)o1), (LogicalType)BIGINT, (LogicalType)FLOAT).equals(MapDataUtil.convertToJavaMap((MapData)((MapData)o2), (LogicalType)BIGINT, (LogicalType)FLOAT))));
    }

    protected TypeSerializer<MapData> createSerializer() {
        return new MapDataSerializer((LogicalType)new BigIntType(), (LogicalType)new FloatType(), (TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)FloatSerializer.INSTANCE);
    }

    protected int getLength() {
        return -1;
    }

    protected Class<MapData> getTypeClass() {
        return MapData.class;
    }

    protected MapData[] getTestData() {
        HashMap<Long, Float> first = new HashMap<Long, Float>();
        first.put(1L, Float.valueOf(-100.1f));
        BinaryArrayData keyBinary = BinaryArrayData.fromPrimitiveArray((long[])new long[]{10L});
        BinaryArrayData valueBinary = BinaryArrayData.fromPrimitiveArray((float[])new float[]{10.2f});
        return new MapData[]{new GenericMapData(first), BinaryMapData.valueOf((BinaryArrayData)keyBinary, (BinaryArrayData)valueBinary)};
    }
}

