/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.python.aggregate.arrow.stream;

import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.python.PythonFunctionRunner;
import org.apache.flink.python.PythonOptions;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.python.PythonFunctionInfo;
import org.apache.flink.table.runtime.operators.python.aggregate.arrow.AbstractArrowPythonAggregateFunctionOperator;
import org.apache.flink.table.runtime.operators.python.aggregate.arrow.stream.AbstractStreamArrowPythonAggregateFunctionOperatorTest;
import org.apache.flink.table.runtime.operators.python.aggregate.arrow.stream.StreamArrowPythonRowTimeBoundedRowsOperator;
import org.apache.flink.table.runtime.utils.PassThroughPythonAggregateFunctionRunner;
import org.apache.flink.table.runtime.utils.PythonTestUtils;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.junit.Test;

public class StreamArrowPythonRowTimeBoundedRowsOperatorTest
extends AbstractStreamArrowPythonAggregateFunctionOperatorTest {
    @Test
    public void testOverWindowAggregateFunction() throws Exception {
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.getTestHarness(new Configuration());
        long initialTime = 0L;
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c2", 0L, 1L), initialTime + 1L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c4", 1L, 1L), initialTime + 2L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c6", 2L, 10L), initialTime + 3L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c2", "c8", 3L, 2L), initialTime + 3L));
        testHarness.processWatermark(Long.MAX_VALUE);
        testHarness.close();
        expectedOutput.add(new Watermark(Long.MAX_VALUE));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", "c2", 0L, 1L, 0L)));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", "c4", 1L, 1L, 0L)));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c2", "c8", 3L, 2L, 3L)));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", "c6", 2L, 10L, 1L)));
        this.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testFinishBundleTriggeredOnCheckpoint() throws Exception {
        Configuration conf = new Configuration();
        conf.setInteger(PythonOptions.MAX_BUNDLE_SIZE, 10);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.getTestHarness(conf);
        long initialTime = 0L;
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c2", 0L, 1L), initialTime + 1L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c4", 1L, 1L), initialTime + 2L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c6", 2L, 10L), initialTime + 3L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c2", "c8", 3L, 2L), initialTime + 3L));
        testHarness.processWatermark(new Watermark(10000L));
        expectedOutput.add(new Watermark(10000L));
        this.assertOutputEquals("FinishBundle should not be triggered.", expectedOutput, testHarness.getOutput());
        testHarness.prepareSnapshotPreBarrier(0L);
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", "c2", 0L, 1L, 0L)));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", "c4", 1L, 1L, 0L)));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c2", "c8", 3L, 2L, 3L)));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", "c6", 2L, 10L, 1L)));
        this.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.close();
    }

    @Test
    public void testFinishBundleTriggeredByCount() throws Exception {
        Configuration conf = new Configuration();
        conf.setInteger(PythonOptions.MAX_BUNDLE_SIZE, 6);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.getTestHarness(conf);
        long initialTime = 0L;
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c2", 0L, 1L), initialTime + 1L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c4", 1L, 1L), initialTime + 2L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c6", 2L, 10L), initialTime + 3L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c2", "c8", 3L, 2L), initialTime + 3L));
        this.assertOutputEquals("FinishBundle should not be triggered.", expectedOutput, testHarness.getOutput());
        testHarness.processWatermark(new Watermark(1000L));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", "c2", 0L, 1L, 0L)));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", "c4", 1L, 1L, 0L)));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c2", "c8", 3L, 2L, 3L)));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", "c6", 2L, 10L, 1L)));
        expectedOutput.add(new Watermark(1000L));
        this.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.close();
    }

    @Test
    public void testFinishBundleTriggeredByTime() throws Exception {
        Configuration conf = new Configuration();
        conf.setInteger(PythonOptions.MAX_BUNDLE_SIZE, 10);
        conf.setLong(PythonOptions.MAX_BUNDLE_TIME_MILLS, 1000L);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.getTestHarness(conf);
        long initialTime = 0L;
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c2", 0L, 1L), initialTime + 1L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c4", 1L, 1L), initialTime + 2L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c6", 2L, 10L), initialTime + 3L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c2", "c8", 3L, 2L), initialTime + 3L));
        testHarness.processWatermark(new Watermark(10000L));
        expectedOutput.add(new Watermark(10000L));
        this.assertOutputEquals("FinishBundle should not be triggered.", expectedOutput, testHarness.getOutput());
        testHarness.setProcessingTime(1000L);
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", "c2", 0L, 1L, 0L)));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", "c4", 1L, 1L, 0L)));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c2", "c8", 3L, 2L, 3L)));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", "c6", 2L, 10L, 1L)));
        this.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.close();
    }

    @Override
    public LogicalType[] getOutputLogicalType() {
        return new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType()};
    }

    @Override
    public RowType getInputType() {
        return new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new VarCharType()), new RowType.RowField("f2", (LogicalType)new VarCharType()), new RowType.RowField("f3", (LogicalType)new BigIntType()), new RowType.RowField("rowTime", (LogicalType)new BigIntType())));
    }

    @Override
    public RowType getOutputType() {
        return new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new VarCharType()), new RowType.RowField("f2", (LogicalType)new VarCharType()), new RowType.RowField("f3", (LogicalType)new BigIntType()), new RowType.RowField("rowTime", (LogicalType)new BigIntType()), new RowType.RowField("agg", (LogicalType)new BigIntType())));
    }

    @Override
    public AbstractArrowPythonAggregateFunctionOperator getTestOperator(Configuration config, PythonFunctionInfo[] pandasAggregateFunctions, RowType inputType, RowType outputType, int[] groupingSet, int[] udafInputOffsets) {
        return new PassThroughStreamArrowPythonRowTimeBoundedRowsOperator(config, pandasAggregateFunctions, inputType, outputType, 3, 1L, groupingSet, udafInputOffsets);
    }

    private static class PassThroughStreamArrowPythonRowTimeBoundedRowsOperator
    extends StreamArrowPythonRowTimeBoundedRowsOperator {
        PassThroughStreamArrowPythonRowTimeBoundedRowsOperator(Configuration config, PythonFunctionInfo[] pandasAggFunctions, RowType inputType, RowType outputType, int inputTimeFieldIndex, long lowerBoundary, int[] groupingSet, int[] udafInputOffsets) {
            super(config, 1000L, 2000L, pandasAggFunctions, inputType, outputType, inputTimeFieldIndex, lowerBoundary, groupingSet, udafInputOffsets);
        }

        public PythonFunctionRunner createPythonFunctionRunner() {
            return new PassThroughPythonAggregateFunctionRunner(this.getRuntimeContext().getTaskName(), PythonTestUtils.createTestEnvironmentManager(), this.userDefinedFunctionInputType, this.userDefinedFunctionOutputType, this.getFunctionUrn(), this.getUserDefinedFunctionsProto(), this.getInputOutputCoderUrn(), new HashMap<String, String>(), PythonTestUtils.createMockFlinkMetricContainer(), false);
        }
    }
}

