/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.arrow;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.runtime.arrow.ArrowReader;
import org.apache.flink.table.runtime.arrow.ArrowReaderWriterTestBase;
import org.apache.flink.table.runtime.arrow.ArrowUtils;
import org.apache.flink.table.runtime.arrow.ArrowWriter;
import org.apache.flink.table.runtime.functions.SqlDateTimeUtils;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.types.Row;
import org.junit.BeforeClass;

public class RowArrowReaderWriterTest
extends ArrowReaderWriterTestBase<Row> {
    private static RowType rowType;
    private static BufferAllocator allocator;

    @BeforeClass
    public static void init() {
        ArrayList<Object> fieldTypes = new ArrayList<Object>();
        fieldTypes.add(new TinyIntType());
        fieldTypes.add(new SmallIntType());
        fieldTypes.add(new IntType());
        fieldTypes.add(new BigIntType());
        fieldTypes.add(new BooleanType());
        fieldTypes.add(new FloatType());
        fieldTypes.add(new DoubleType());
        fieldTypes.add(new VarCharType());
        fieldTypes.add(new VarBinaryType());
        fieldTypes.add(new DecimalType(10, 0));
        fieldTypes.add(new DateType());
        fieldTypes.add(new TimeType(0));
        fieldTypes.add(new TimeType(2));
        fieldTypes.add(new TimeType(4));
        fieldTypes.add(new TimeType(8));
        fieldTypes.add(new LocalZonedTimestampType(0));
        fieldTypes.add(new LocalZonedTimestampType(2));
        fieldTypes.add(new LocalZonedTimestampType(4));
        fieldTypes.add(new LocalZonedTimestampType(8));
        fieldTypes.add(new TimestampType(0));
        fieldTypes.add(new TimestampType(2));
        fieldTypes.add(new TimestampType(4));
        fieldTypes.add(new TimestampType(8));
        fieldTypes.add(new ArrayType((LogicalType)new VarCharType()));
        fieldTypes.add(new RowType(Arrays.asList(new RowType.RowField("a", (LogicalType)new IntType()), new RowType.RowField("b", (LogicalType)new VarCharType()), new RowType.RowField("c", (LogicalType)new ArrayType((LogicalType)new VarCharType())), new RowType.RowField("d", (LogicalType)new TimestampType(2)), new RowType.RowField("e", (LogicalType)new RowType(Arrays.asList(new RowType.RowField("e1", (LogicalType)new IntType()), new RowType.RowField("e2", (LogicalType)new VarCharType())))))));
        ArrayList<RowType.RowField> rowFields = new ArrayList<RowType.RowField>();
        for (int i = 0; i < fieldTypes.size(); ++i) {
            rowFields.add(new RowType.RowField("f" + i, (LogicalType)fieldTypes.get(i)));
        }
        rowType = new RowType(rowFields);
        allocator = ArrowUtils.getRootAllocator().newChildAllocator("stdout", 0L, Long.MAX_VALUE);
    }

    @Override
    public ArrowReader<Row> createArrowReader(InputStream inputStream) throws IOException {
        ArrowStreamReader reader = new ArrowStreamReader(inputStream, allocator);
        reader.loadNextBatch();
        return ArrowUtils.createRowArrowReader((VectorSchemaRoot)reader.getVectorSchemaRoot(), (RowType)rowType);
    }

    @Override
    public Tuple2<ArrowWriter<Row>, ArrowStreamWriter> createArrowWriter(OutputStream outputStream) throws IOException {
        VectorSchemaRoot root = VectorSchemaRoot.create((Schema)ArrowUtils.toArrowSchema((RowType)rowType), (BufferAllocator)allocator);
        ArrowWriter arrowWriter = ArrowUtils.createRowArrowWriter((VectorSchemaRoot)root, (RowType)rowType);
        ArrowStreamWriter arrowStreamWriter = new ArrowStreamWriter(root, null, outputStream);
        arrowStreamWriter.start();
        return Tuple2.of((Object)arrowWriter, (Object)arrowStreamWriter);
    }

    public Row[] getTestData() {
        Row row1 = Row.of((Object[])new Object[]{(byte)1, (short)2, 3, 4L, true, Float.valueOf(1.0f), 1.0, "hello", "hello".getBytes(), new BigDecimal(1), SqlDateTimeUtils.internalToDate((int)100), SqlDateTimeUtils.internalToTime((int)3600000), SqlDateTimeUtils.internalToTime((int)3600000), SqlDateTimeUtils.internalToTime((int)3600000), SqlDateTimeUtils.internalToTime((int)3600000), new Timestamp(3600000L), new Timestamp(3600000L), new Timestamp(3600000L), new Timestamp(3600000L), new Timestamp(3600000L), new Timestamp(3600000L), new Timestamp(3600000L), new Timestamp(3600000L), new String[]{null, null, null}, Row.of((Object[])new Object[]{1, "hello", new String[]{null, null, null}, new Timestamp(3600000L), Row.of((Object[])new Object[]{1, "hello"})})});
        Row row2 = Row.of((Object[])new Object[]{null, (short)2, 3, 4L, false, Float.valueOf(1.0f), 1.0, "\u4e2d\u6587", "\u4e2d\u6587".getBytes(), new BigDecimal(1), SqlDateTimeUtils.internalToDate((int)100), SqlDateTimeUtils.internalToTime((int)3600000), SqlDateTimeUtils.internalToTime((int)3600000), SqlDateTimeUtils.internalToTime((int)3600000), SqlDateTimeUtils.internalToTime((int)3600000), new Timestamp(3600000L), new Timestamp(3600000L), new Timestamp(3600000L), new Timestamp(3600000L), new Timestamp(3600000L), new Timestamp(3600000L), new Timestamp(3600000L), new Timestamp(3600000L), new String[]{"hello", "\u4e2d\u6587", null}, Row.of((Object[])new Object[]{1, "hello", new String[]{"hello", "\u4e2d\u6587", null}, new Timestamp(3600000L), Row.of((Object[])new Object[]{1, "hello"})})});
        Row row3 = Row.of((Object[])new Object[]{(byte)1, null, 3, 4L, true, Float.valueOf(1.0f), 1.0, "hello", "hello".getBytes(), new BigDecimal(1), SqlDateTimeUtils.internalToDate((int)100), SqlDateTimeUtils.internalToTime((int)3600000), SqlDateTimeUtils.internalToTime((int)3600000), SqlDateTimeUtils.internalToTime((int)3600000), SqlDateTimeUtils.internalToTime((int)3600000), new Timestamp(3600000L), new Timestamp(3600000L), new Timestamp(3600000L), new Timestamp(3600000L), new Timestamp(3600000L), new Timestamp(3600000L), new Timestamp(3600000L), new Timestamp(3600000L), null, null});
        Row row4 = new Row(rowType.getFieldCount());
        return new Row[]{row1, row2, row3, row4};
    }
}

