/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.BigIntSerializer;
import org.apache.flink.api.common.typeutils.base.BooleanSerializer;
import org.apache.flink.api.common.typeutils.base.ByteSerializer;
import org.apache.flink.api.common.typeutils.base.CharSerializer;
import org.apache.flink.api.common.typeutils.base.DoubleSerializer;
import org.apache.flink.api.common.typeutils.base.FloatSerializer;
import org.apache.flink.api.common.typeutils.base.GenericArraySerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.ShortSerializer;
import org.apache.flink.api.common.typeutils.base.array.BytePrimitiveArraySerializer;
import org.apache.flink.api.common.typeutils.base.array.IntPrimitiveArraySerializer;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.runtime.RowSerializer;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;
import org.apache.flink.fnexecution.v1.FlinkFnApi;
import org.apache.flink.streaming.api.typeinfo.python.PickledByteArrayTypeInfo;
import org.apache.flink.streaming.api.utils.PythonTypeUtils;
import org.apache.flink.table.runtime.typeutils.serializers.python.BigDecSerializer;
import org.apache.flink.table.runtime.typeutils.serializers.python.DateSerializer;
import org.apache.flink.table.runtime.typeutils.serializers.python.StringSerializer;
import org.apache.flink.table.runtime.typeutils.serializers.python.TimeSerializer;
import org.apache.flink.table.runtime.typeutils.serializers.python.TimestampSerializer;
import org.junit.Assert;
import org.junit.Test;

public class PythonTypeUtilsTest {
    @Test
    public void testTypeInfoToProtoConverter() {
        HashMap<Object, FlinkFnApi.TypeInfo.TypeName> typeInformationTypeNameMap = new HashMap<Object, FlinkFnApi.TypeInfo.TypeName>();
        typeInformationTypeNameMap.put(BasicTypeInfo.INT_TYPE_INFO, FlinkFnApi.TypeInfo.TypeName.INT);
        typeInformationTypeNameMap.put(BasicTypeInfo.BIG_DEC_TYPE_INFO, FlinkFnApi.TypeInfo.TypeName.BIG_DEC);
        typeInformationTypeNameMap.put(BasicTypeInfo.BIG_INT_TYPE_INFO, FlinkFnApi.TypeInfo.TypeName.BIG_INT);
        typeInformationTypeNameMap.put(BasicTypeInfo.CHAR_TYPE_INFO, FlinkFnApi.TypeInfo.TypeName.CHAR);
        typeInformationTypeNameMap.put(BasicTypeInfo.FLOAT_TYPE_INFO, FlinkFnApi.TypeInfo.TypeName.FLOAT);
        typeInformationTypeNameMap.put(BasicTypeInfo.DOUBLE_TYPE_INFO, FlinkFnApi.TypeInfo.TypeName.DOUBLE);
        typeInformationTypeNameMap.put(BasicTypeInfo.SHORT_TYPE_INFO, FlinkFnApi.TypeInfo.TypeName.SHORT);
        typeInformationTypeNameMap.put(BasicTypeInfo.LONG_TYPE_INFO, FlinkFnApi.TypeInfo.TypeName.LONG);
        typeInformationTypeNameMap.put(BasicTypeInfo.STRING_TYPE_INFO, FlinkFnApi.TypeInfo.TypeName.STRING);
        typeInformationTypeNameMap.put(BasicTypeInfo.BYTE_TYPE_INFO, FlinkFnApi.TypeInfo.TypeName.BYTE);
        typeInformationTypeNameMap.put(PickledByteArrayTypeInfo.PICKLED_BYTE_ARRAY_TYPE_INFO, FlinkFnApi.TypeInfo.TypeName.PICKLED_BYTES);
        typeInformationTypeNameMap.put(BasicTypeInfo.BOOLEAN_TYPE_INFO, FlinkFnApi.TypeInfo.TypeName.BOOLEAN);
        for (Map.Entry entry : typeInformationTypeNameMap.entrySet()) {
            Assert.assertEquals(entry.getValue(), (Object)PythonTypeUtils.TypeInfoToProtoConverter.getFieldType((TypeInformation)((TypeInformation)entry.getKey())).getTypeName());
        }
        PrimitiveArrayTypeInfo primitiveIntegerArrayTypeInfo = PrimitiveArrayTypeInfo.INT_PRIMITIVE_ARRAY_TYPE_INFO;
        FlinkFnApi.TypeInfo.FieldType convertedFieldType = PythonTypeUtils.TypeInfoToProtoConverter.getFieldType((TypeInformation)primitiveIntegerArrayTypeInfo);
        Assert.assertEquals((Object)convertedFieldType.getTypeName(), (Object)FlinkFnApi.TypeInfo.TypeName.PRIMITIVE_ARRAY);
        Assert.assertEquals((Object)convertedFieldType.getCollectionElementType().getTypeName(), (Object)FlinkFnApi.TypeInfo.TypeName.INT);
        BasicArrayTypeInfo basicIntegerArrayTypeInfo = BasicArrayTypeInfo.INT_ARRAY_TYPE_INFO;
        FlinkFnApi.TypeInfo.FieldType convertedBasicFieldType = PythonTypeUtils.TypeInfoToProtoConverter.getFieldType((TypeInformation)basicIntegerArrayTypeInfo);
        Assert.assertEquals((Object)convertedBasicFieldType.getTypeName(), (Object)FlinkFnApi.TypeInfo.TypeName.BASIC_ARRAY);
        Assert.assertEquals((Object)convertedBasicFieldType.getCollectionElementType().getTypeName(), (Object)FlinkFnApi.TypeInfo.TypeName.INT);
        TypeInformation rowTypeInfo = Types.ROW((TypeInformation[])new TypeInformation[]{Types.INT});
        convertedFieldType = PythonTypeUtils.TypeInfoToProtoConverter.getFieldType((TypeInformation)rowTypeInfo);
        Assert.assertEquals((Object)convertedFieldType.getTypeName(), (Object)FlinkFnApi.TypeInfo.TypeName.ROW);
        Assert.assertEquals((Object)convertedFieldType.getRowTypeInfo().getField(0).getType().getTypeName(), (Object)FlinkFnApi.TypeInfo.TypeName.INT);
        TypeInformation tupleTypeInfo = Types.TUPLE((TypeInformation[])new TypeInformation[]{Types.INT});
        convertedFieldType = PythonTypeUtils.TypeInfoToProtoConverter.getFieldType((TypeInformation)tupleTypeInfo);
        Assert.assertEquals((Object)convertedFieldType.getTypeName(), (Object)FlinkFnApi.TypeInfo.TypeName.TUPLE);
        Assert.assertEquals((Object)convertedFieldType.getTupleTypeInfo().getField(0).getType().getTypeName(), (Object)FlinkFnApi.TypeInfo.TypeName.INT);
    }

    @Test
    public void testTypeInfotoSerializerConverter() {
        HashMap<Object, Object> typeInformationTypeSerializerMap = new HashMap<Object, Object>();
        typeInformationTypeSerializerMap.put(BasicTypeInfo.INT_TYPE_INFO, IntSerializer.INSTANCE);
        typeInformationTypeSerializerMap.put(BasicTypeInfo.BIG_DEC_TYPE_INFO, BigDecSerializer.INSTANCE);
        typeInformationTypeSerializerMap.put(BasicTypeInfo.BIG_INT_TYPE_INFO, BigIntSerializer.INSTANCE);
        typeInformationTypeSerializerMap.put(BasicTypeInfo.CHAR_TYPE_INFO, CharSerializer.INSTANCE);
        typeInformationTypeSerializerMap.put(BasicTypeInfo.FLOAT_TYPE_INFO, FloatSerializer.INSTANCE);
        typeInformationTypeSerializerMap.put(BasicTypeInfo.DOUBLE_TYPE_INFO, DoubleSerializer.INSTANCE);
        typeInformationTypeSerializerMap.put(BasicTypeInfo.SHORT_TYPE_INFO, ShortSerializer.INSTANCE);
        typeInformationTypeSerializerMap.put(BasicTypeInfo.LONG_TYPE_INFO, LongSerializer.INSTANCE);
        typeInformationTypeSerializerMap.put(BasicTypeInfo.STRING_TYPE_INFO, StringSerializer.INSTANCE);
        typeInformationTypeSerializerMap.put(BasicTypeInfo.BYTE_TYPE_INFO, ByteSerializer.INSTANCE);
        typeInformationTypeSerializerMap.put(PickledByteArrayTypeInfo.PICKLED_BYTE_ARRAY_TYPE_INFO, BytePrimitiveArraySerializer.INSTANCE);
        typeInformationTypeSerializerMap.put(BasicTypeInfo.BOOLEAN_TYPE_INFO, BooleanSerializer.INSTANCE);
        typeInformationTypeSerializerMap.put(SqlTimeTypeInfo.DATE, DateSerializer.INSTANCE);
        typeInformationTypeSerializerMap.put(SqlTimeTypeInfo.TIME, TimeSerializer.INSTANCE);
        typeInformationTypeSerializerMap.put(SqlTimeTypeInfo.TIMESTAMP, new TimestampSerializer(3));
        for (Map.Entry entry : typeInformationTypeSerializerMap.entrySet()) {
            Assert.assertEquals(entry.getValue(), (Object)PythonTypeUtils.TypeInfoToSerializerConverter.typeInfoSerializerConverter((TypeInformation)((TypeInformation)entry.getKey())));
        }
        PrimitiveArrayTypeInfo primitiveIntegerArrayTypeInfo = PrimitiveArrayTypeInfo.INT_PRIMITIVE_ARRAY_TYPE_INFO;
        TypeSerializer convertedTypeSerializer = PythonTypeUtils.TypeInfoToSerializerConverter.typeInfoSerializerConverter((TypeInformation)primitiveIntegerArrayTypeInfo);
        Assert.assertEquals((Object)convertedTypeSerializer, (Object)IntPrimitiveArraySerializer.INSTANCE);
        BasicArrayTypeInfo integerArrayTypeInfo = BasicArrayTypeInfo.INT_ARRAY_TYPE_INFO;
        convertedTypeSerializer = PythonTypeUtils.TypeInfoToSerializerConverter.typeInfoSerializerConverter((TypeInformation)integerArrayTypeInfo);
        Assert.assertEquals((Object)convertedTypeSerializer, (Object)new GenericArraySerializer(Integer.class, (TypeSerializer)IntSerializer.INSTANCE));
        TypeInformation rowTypeInfo = Types.ROW((TypeInformation[])new TypeInformation[]{Types.INT});
        convertedTypeSerializer = PythonTypeUtils.TypeInfoToSerializerConverter.typeInfoSerializerConverter((TypeInformation)rowTypeInfo);
        Assert.assertEquals((Object)convertedTypeSerializer, (Object)new RowSerializer(new TypeSerializer[]{IntSerializer.INSTANCE}, false));
        TupleTypeInfo tupleTypeInfo = (TupleTypeInfo)Types.TUPLE((TypeInformation[])new TypeInformation[]{Types.INT});
        convertedTypeSerializer = PythonTypeUtils.TypeInfoToSerializerConverter.typeInfoSerializerConverter((TypeInformation)tupleTypeInfo);
        Assert.assertEquals((Object)convertedTypeSerializer, (Object)new TupleSerializer(tupleTypeInfo.getTypeClass(), new TypeSerializer[]{IntSerializer.INSTANCE}));
    }
}

