/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python.util;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.python.util.PythonConfigUtil;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.DiscardingSink;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.junit.Assert;
import org.junit.Test;

public class PythonConfigUtilTest {
    @Test
    public void testGetEnvironmentConfig() throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        StreamExecutionEnvironment executionEnvironment = StreamExecutionEnvironment.getExecutionEnvironment();
        Configuration envConfig = PythonConfigUtil.getEnvConfigWithDependencies((StreamExecutionEnvironment)executionEnvironment);
        Assert.assertNotNull((Object)envConfig);
    }

    @Test
    public void testJobName() throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, NoSuchFieldException {
        String jobName = "MyTestJob";
        Configuration config = new Configuration();
        config.set(PipelineOptions.NAME, (Object)jobName);
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)config);
        env.fromCollection(Collections.singletonList("test")).addSink((SinkFunction)new DiscardingSink());
        StreamGraph streamGraph = PythonConfigUtil.generateStreamGraphWithDependencies((StreamExecutionEnvironment)env, (boolean)true);
        Assert.assertEquals((Object)jobName, (Object)streamGraph.getJobName());
    }
}

