/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python.env;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.python.PythonConfig;
import org.apache.flink.python.PythonOptions;
import org.apache.flink.python.env.PythonDependencyInfo;
import org.apache.flink.python.util.PythonDependencyUtils;
import org.apache.flink.util.OperatingSystem;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class PythonDependencyInfoTest {
    private DistributedCache distributedCache;

    public PythonDependencyInfoTest() {
        HashMap<String, CompletableFuture<Path>> distributeCachedFiles = new HashMap<String, CompletableFuture<Path>>();
        distributeCachedFiles.put("python_file_{SHA256_0}", CompletableFuture.completedFuture(new Path("/distributed_cache/file0")));
        distributeCachedFiles.put("python_file_{SHA256_1}", CompletableFuture.completedFuture(new Path("/distributed_cache/file1")));
        distributeCachedFiles.put("python_requirements_file_{SHA256}", CompletableFuture.completedFuture(new Path("/distributed_cache/file2")));
        distributeCachedFiles.put("python_requirements_cache_{SHA256}", CompletableFuture.completedFuture(new Path("/distributed_cache/file3")));
        distributeCachedFiles.put("python_archive_{SHA256_0}", CompletableFuture.completedFuture(new Path("/distributed_cache/file4")));
        distributeCachedFiles.put("python_archive_{SHA256_1}", CompletableFuture.completedFuture(new Path("/distributed_cache/file5")));
        this.distributedCache = new DistributedCache(distributeCachedFiles);
    }

    @Test
    public void testParsePythonFiles() {
        Assume.assumeFalse((boolean)OperatingSystem.isWindows());
        Configuration config = new Configuration();
        HashMap<String, String> pythonFiles = new HashMap<String, String>();
        pythonFiles.put("python_file_{SHA256_0}", "test_file1.py");
        pythonFiles.put("python_file_{SHA256_1}", "test_file2.py");
        config.set(PythonDependencyUtils.PYTHON_FILES, pythonFiles);
        PythonDependencyInfo dependencyInfo = PythonDependencyInfo.create((PythonConfig)new PythonConfig(config), (DistributedCache)this.distributedCache);
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("/distributed_cache/file0", "test_file1.py");
        expected.put("/distributed_cache/file1", "test_file2.py");
        Assert.assertEquals(expected, (Object)dependencyInfo.getPythonFiles());
    }

    @Test
    public void testParsePythonRequirements() throws IOException {
        Assume.assumeFalse((boolean)OperatingSystem.isWindows());
        Configuration config = new Configuration();
        config.set(PythonDependencyUtils.PYTHON_REQUIREMENTS_FILE, new HashMap());
        ((Map)config.get(PythonDependencyUtils.PYTHON_REQUIREMENTS_FILE)).put("file", "python_requirements_file_{SHA256}");
        PythonDependencyInfo dependencyInfo = PythonDependencyInfo.create((PythonConfig)new PythonConfig(config), (DistributedCache)this.distributedCache);
        Assert.assertEquals((Object)"/distributed_cache/file2", dependencyInfo.getRequirementsFilePath().get());
        Assert.assertFalse((boolean)dependencyInfo.getRequirementsCacheDir().isPresent());
        ((Map)config.get(PythonDependencyUtils.PYTHON_REQUIREMENTS_FILE)).put("cache", "python_requirements_cache_{SHA256}");
        dependencyInfo = PythonDependencyInfo.create((PythonConfig)new PythonConfig(config), (DistributedCache)this.distributedCache);
        Assert.assertEquals((Object)"/distributed_cache/file2", dependencyInfo.getRequirementsFilePath().get());
        Assert.assertEquals((Object)"/distributed_cache/file3", dependencyInfo.getRequirementsCacheDir().get());
    }

    @Test
    public void testParsePythonArchives() {
        Assume.assumeFalse((boolean)OperatingSystem.isWindows());
        Configuration config = new Configuration();
        HashMap<String, String> pythonArchives = new HashMap<String, String>();
        pythonArchives.put("python_archive_{SHA256_0}", "py27.zip");
        pythonArchives.put("python_archive_{SHA256_1}", "py37");
        config.set(PythonDependencyUtils.PYTHON_ARCHIVES, pythonArchives);
        PythonDependencyInfo dependencyInfo = PythonDependencyInfo.create((PythonConfig)new PythonConfig(config), (DistributedCache)this.distributedCache);
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("/distributed_cache/file4", "py27.zip");
        expected.put("/distributed_cache/file5", "py37");
        Assert.assertEquals(expected, (Object)dependencyInfo.getArchives());
    }

    @Test
    public void testParsePythonExec() {
        Configuration config = new Configuration();
        config.set(PythonOptions.PYTHON_EXECUTABLE, (Object)"/usr/bin/python3");
        PythonDependencyInfo dependencyInfo = PythonDependencyInfo.create((PythonConfig)new PythonConfig(config), (DistributedCache)this.distributedCache);
        Assert.assertEquals((Object)"/usr/bin/python3", (Object)dependencyInfo.getPythonExec());
    }
}

