/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python;

import java.util.Optional;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.python.PythonOptions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class PythonOptionsTest {
    @Test
    public void testBundleSize() {
        Configuration configuration = new Configuration();
        int defaultBundleSize = configuration.getInteger(PythonOptions.MAX_BUNDLE_SIZE);
        Assert.assertThat((Object)defaultBundleSize, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)PythonOptions.MAX_BUNDLE_SIZE.defaultValue())));
        int expectedBundleSize = 100;
        configuration.setInteger(PythonOptions.MAX_BUNDLE_SIZE, 100);
        int actualBundleSize = configuration.getInteger(PythonOptions.MAX_BUNDLE_SIZE);
        Assert.assertThat((Object)actualBundleSize, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)100)));
    }

    @Test
    public void testBundleTime() {
        Configuration configuration = new Configuration();
        long defaultBundleTime = configuration.getLong(PythonOptions.MAX_BUNDLE_TIME_MILLS);
        Assert.assertThat((Object)defaultBundleTime, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)PythonOptions.MAX_BUNDLE_TIME_MILLS.defaultValue())));
        long expectedBundleTime = 100L;
        configuration.setLong(PythonOptions.MAX_BUNDLE_TIME_MILLS, 100L);
        long actualBundleSize = configuration.getLong(PythonOptions.MAX_BUNDLE_TIME_MILLS);
        Assert.assertThat((Object)actualBundleSize, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)100L)));
    }

    @Test
    public void testArrowBatchSize() {
        Configuration configuration = new Configuration();
        int defaultArrowBatchSize = configuration.getInteger(PythonOptions.MAX_ARROW_BATCH_SIZE);
        Assert.assertThat((Object)defaultArrowBatchSize, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)PythonOptions.MAX_ARROW_BATCH_SIZE.defaultValue())));
        int expectedArrowBatchSize = 100;
        configuration.setInteger(PythonOptions.MAX_ARROW_BATCH_SIZE, 100);
        int actualArrowBatchSize = configuration.getInteger(PythonOptions.MAX_ARROW_BATCH_SIZE);
        Assert.assertThat((Object)actualArrowBatchSize, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)100)));
    }

    @Test
    public void testPythonMetricEnabled() {
        Configuration configuration = new Configuration();
        boolean isMetricEnabled = configuration.getBoolean(PythonOptions.PYTHON_METRIC_ENABLED);
        Assert.assertThat((Object)isMetricEnabled, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)PythonOptions.PYTHON_METRIC_ENABLED.defaultValue())));
        boolean expectedIsMetricEnabled = false;
        configuration.setBoolean(PythonOptions.PYTHON_METRIC_ENABLED, false);
        boolean actualIsMetricEnabled = configuration.getBoolean(PythonOptions.PYTHON_METRIC_ENABLED);
        Assert.assertThat((Object)actualIsMetricEnabled, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)false)));
    }

    @Test
    public void testPythonFiles() {
        Configuration configuration = new Configuration();
        Optional defaultPythonFiles = configuration.getOptional(PythonOptions.PYTHON_FILES);
        Assert.assertThat((Object)defaultPythonFiles, (Matcher)Matchers.is((Matcher)Matchers.equalTo(Optional.empty())));
        String expectedPythonFiles = "tmp_dir/test1.py,tmp_dir/test2.py";
        configuration.set(PythonOptions.PYTHON_FILES, (Object)"tmp_dir/test1.py,tmp_dir/test2.py");
        String actualPythonFiles = (String)configuration.get(PythonOptions.PYTHON_FILES);
        Assert.assertThat((Object)actualPythonFiles, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"tmp_dir/test1.py,tmp_dir/test2.py")));
    }

    @Test
    public void testPythonRequirements() {
        Configuration configuration = new Configuration();
        Optional defaultPythonRequirements = configuration.getOptional(PythonOptions.PYTHON_REQUIREMENTS);
        Assert.assertThat((Object)defaultPythonRequirements, (Matcher)Matchers.is((Matcher)Matchers.equalTo(Optional.empty())));
        String expectedPythonRequirements = "tmp_dir/requirements.txt#tmp_dir/cache";
        configuration.set(PythonOptions.PYTHON_REQUIREMENTS, (Object)"tmp_dir/requirements.txt#tmp_dir/cache");
        String actualPythonRequirements = (String)configuration.get(PythonOptions.PYTHON_REQUIREMENTS);
        Assert.assertThat((Object)actualPythonRequirements, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"tmp_dir/requirements.txt#tmp_dir/cache")));
    }

    @Test
    public void testPythonArchives() {
        Configuration configuration = new Configuration();
        Optional defaultPythonArchives = configuration.getOptional(PythonOptions.PYTHON_ARCHIVES);
        Assert.assertThat((Object)defaultPythonArchives, (Matcher)Matchers.is((Matcher)Matchers.equalTo(Optional.empty())));
        String expectedPythonArchives = "tmp_dir/py37.zip#venv,tmp_dir/data.zip";
        configuration.set(PythonOptions.PYTHON_ARCHIVES, (Object)"tmp_dir/py37.zip#venv,tmp_dir/data.zip");
        String actualPythonArchives = (String)configuration.get(PythonOptions.PYTHON_ARCHIVES);
        Assert.assertThat((Object)actualPythonArchives, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"tmp_dir/py37.zip#venv,tmp_dir/data.zip")));
    }

    @Test
    public void testPythonExecutable() {
        Configuration configuration = new Configuration();
        Optional defaultPythonExecutable = configuration.getOptional(PythonOptions.PYTHON_EXECUTABLE);
        Assert.assertThat((Object)defaultPythonExecutable, (Matcher)Matchers.is((Matcher)Matchers.equalTo(Optional.empty())));
        String expectedPythonExecutable = "venv/py37/bin/python";
        configuration.set(PythonOptions.PYTHON_EXECUTABLE, (Object)"venv/py37/bin/python");
        String actualPythonExecutable = (String)configuration.get(PythonOptions.PYTHON_EXECUTABLE);
        Assert.assertThat((Object)actualPythonExecutable, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"venv/py37/bin/python")));
    }

    @Test
    public void testPythonClientExecutable() {
        Configuration configuration = new Configuration();
        Optional defaultPythonClientExecutable = configuration.getOptional(PythonOptions.PYTHON_CLIENT_EXECUTABLE);
        Assert.assertThat((Object)defaultPythonClientExecutable, (Matcher)Matchers.is((Matcher)Matchers.equalTo(Optional.empty())));
        String expectedPythonClientExecutable = "tmp_dir/test1.py,tmp_dir/test2.py";
        configuration.set(PythonOptions.PYTHON_CLIENT_EXECUTABLE, (Object)"tmp_dir/test1.py,tmp_dir/test2.py");
        String actualPythonClientExecutable = (String)configuration.get(PythonOptions.PYTHON_CLIENT_EXECUTABLE);
        Assert.assertThat((Object)actualPythonClientExecutable, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"tmp_dir/test1.py,tmp_dir/test2.py")));
    }
}

