/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.python;

import java.util.List;
import org.apache.flink.client.python.PythonShellParser;
import org.junit.Assert;
import org.junit.Test;

public class PythonShellParserTest {
    @Test
    public void testParseLocalWithoutOptions() {
        String[] args = new String[]{"local"};
        List commandOptions = PythonShellParser.parseLocal((String[])args);
        Object[] expectedCommandOptions = new String[]{"local"};
        Assert.assertArrayEquals((Object[])expectedCommandOptions, (Object[])commandOptions.toArray());
    }

    @Test
    public void testParseRemoteWithoutOptions() {
        String[] args = new String[]{"remote", "localhost", "8081"};
        List commandOptions = PythonShellParser.parseRemote((String[])args);
        Object[] expectedCommandOptions = new String[]{"remote", "-m", "localhost:8081"};
        Assert.assertArrayEquals((Object[])expectedCommandOptions, (Object[])commandOptions.toArray());
    }

    @Test
    public void testParseYarnWithoutOptions() {
        String[] args = new String[]{"yarn"};
        List commandOptions = PythonShellParser.parseYarn((String[])args);
        Object[] expectedCommandOptions = new String[]{"yarn", "-m", "yarn-cluster"};
        Assert.assertArrayEquals((Object[])expectedCommandOptions, (Object[])commandOptions.toArray());
    }

    @Test
    public void testParseYarnWithOptions() {
        String[] args = new String[]{"yarn", "-jm", "1024m", "-tm", "4096m"};
        List commandOptions = PythonShellParser.parseYarn((String[])args);
        Object[] expectedCommandOptions = new String[]{"yarn", "-m", "yarn-cluster", "-yjm", "1024m", "-ytm", "4096m"};
        Assert.assertArrayEquals((Object[])expectedCommandOptions, (Object[])commandOptions.toArray());
    }
}

