/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.python;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.flink.client.python.PythonEnvUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.python.PythonOptions;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.OperatingSystem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class PythonEnvUtilsTest {
    private String tmpDirPath;

    @Before
    public void prepareTestEnvironment() {
        File tmpDirFile = new File(System.getProperty("java.io.tmpdir"), "pyflink_" + UUID.randomUUID());
        tmpDirFile.mkdirs();
        this.tmpDirPath = tmpDirFile.getAbsolutePath();
    }

    @Test
    public void testPreparePythonEnvironment() throws IOException {
        Assume.assumeFalse((boolean)OperatingSystem.isWindows());
        File zipFile = new File(this.tmpDirPath + File.separator + "a.zip");
        File dirFile = new File(this.tmpDirPath + File.separator + "module_dir");
        File subdirFile = new File(this.tmpDirPath + File.separator + "subdir");
        File relativeFile = new File(this.tmpDirPath + File.separator + "subdir" + File.separator + "b.py");
        File schemeFile = new File(this.tmpDirPath + File.separator + "subdir" + File.separator + "c.egg");
        try (ZipArchiveOutputStream zipOut = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(zipFile));){
            ZipArchiveEntry entry = new ZipArchiveEntry("zipDir/zipfile0");
            zipOut.putArchiveEntry((ArchiveEntry)entry);
            zipOut.write(new byte[]{1, 1, 1, 1, 1});
            zipOut.closeArchiveEntry();
        }
        dirFile.mkdir();
        subdirFile.mkdir();
        relativeFile.createNewFile();
        schemeFile.createNewFile();
        String workingDir = new File("").getAbsolutePath();
        String absolutePath = relativeFile.getAbsolutePath();
        Path zipPath = new Path(zipFile.getAbsolutePath());
        Path dirPath = new Path(dirFile.getAbsolutePath());
        Path relativePath = new Path(Paths.get(workingDir, new String[0]).relativize(Paths.get(absolutePath, new String[0])).toString());
        Path schemePath = new Path("file://" + schemeFile.getAbsolutePath());
        ArrayList<Path> pyFilesList = new ArrayList<Path>();
        pyFilesList.add(zipPath);
        pyFilesList.add(dirPath);
        pyFilesList.add(relativePath);
        pyFilesList.add(schemePath);
        String pyFiles = pyFilesList.stream().map(Path::toString).collect(Collectors.joining(","));
        Configuration config = new Configuration();
        config.set(PythonOptions.PYTHON_FILES, (Object)pyFiles);
        PythonEnvUtils.PythonEnvironment env = PythonEnvUtils.preparePythonEnvironment((ReadableConfig)config, null, (String)this.tmpDirPath);
        String base = PythonEnvUtilsTest.replaceUUID(env.tempDirectory);
        HashSet<String> expectedPythonPaths = new HashSet<String>();
        expectedPythonPaths.add(String.join((CharSequence)File.separator, base, "{uuid}", "a"));
        expectedPythonPaths.add(String.join((CharSequence)File.separator, base, "{uuid}", "module_dir"));
        expectedPythonPaths.add(String.join((CharSequence)File.separator, base, "{uuid}"));
        expectedPythonPaths.add(String.join((CharSequence)File.separator, base, "{uuid}", "c.egg"));
        Set actualPaths = Arrays.stream(env.pythonPath.split(File.pathSeparator)).map(PythonEnvUtilsTest::replaceUUID).collect(Collectors.toSet());
        Assert.assertEquals(expectedPythonPaths, actualPaths);
    }

    @Test
    public void testStartPythonProcess() {
        PythonEnvUtils.PythonEnvironment pythonEnv = new PythonEnvUtils.PythonEnvironment();
        pythonEnv.tempDirectory = this.tmpDirPath;
        pythonEnv.pythonPath = this.tmpDirPath;
        ArrayList<String> commands = new ArrayList<String>();
        String pyPath = String.join((CharSequence)File.separator, this.tmpDirPath, "verifier.py");
        try {
            File pyFile = new File(pyPath);
            pyFile.createNewFile();
            pyFile.setExecutable(true);
            String pyProgram = "#!/usr/bin/python\n# -*- coding: UTF-8 -*-\nimport os\nimport sys\n\nif __name__=='__main__':\n\tfilename = sys.argv[1]\n\tfo = open(filename, \"w\")\n\tfo.write(os.getcwd())\n\tfo.close()";
            Files.write(pyFile.toPath(), pyProgram.getBytes(), StandardOpenOption.WRITE);
            String result = String.join((CharSequence)File.separator, this.tmpDirPath, "python_working_directory.txt");
            commands.add(pyPath);
            commands.add(result);
            Process pythonProcess = PythonEnvUtils.startPythonProcess((PythonEnvUtils.PythonEnvironment)pythonEnv, commands, (boolean)false);
            int exitCode = pythonProcess.waitFor();
            if (exitCode != 0) {
                throw new RuntimeException("Python process exits with code: " + exitCode);
            }
            String cmdResult = new String(Files.readAllBytes(new File(result).toPath()));
            Assert.assertEquals((Object)cmdResult, (Object)System.getProperty("user.dir"));
            pythonProcess.destroyForcibly();
            pyFile.delete();
            new File(result).delete();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("test start Python process failed " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetPythonExecutable() throws IOException {
        Configuration config = new Configuration();
        PythonEnvUtils.PythonEnvironment env = PythonEnvUtils.preparePythonEnvironment((ReadableConfig)config, null, (String)this.tmpDirPath);
        if (OperatingSystem.isWindows()) {
            Assert.assertEquals((Object)"python.exe", (Object)env.pythonExec);
        } else {
            Assert.assertEquals((Object)"python", (Object)env.pythonExec);
        }
        HashMap<String, String> systemEnv = new HashMap<String, String>(System.getenv());
        systemEnv.put("PYFLINK_CLIENT_EXECUTABLE", "python3");
        CommonTestUtils.setEnv(systemEnv);
        try {
            env = PythonEnvUtils.preparePythonEnvironment((ReadableConfig)config, null, (String)this.tmpDirPath);
            Assert.assertEquals((Object)"python3", (Object)env.pythonExec);
        }
        finally {
            systemEnv.remove("PYFLINK_CLIENT_EXECUTABLE");
            CommonTestUtils.setEnv(systemEnv);
        }
        config.set(PythonOptions.PYTHON_CLIENT_EXECUTABLE, (Object)"/usr/bin/python");
        env = PythonEnvUtils.preparePythonEnvironment((ReadableConfig)config, null, (String)this.tmpDirPath);
        Assert.assertEquals((Object)"/usr/bin/python", (Object)env.pythonExec);
    }

    @Test
    public void testPrepareEnvironmentWithEntryPointScript() throws IOException {
        File entryFile = new File(this.tmpDirPath + File.separator + "test.py");
        entryFile.createNewFile();
        String entryFilePath = entryFile.getAbsolutePath();
        Configuration config = new Configuration();
        PythonEnvUtils.PythonEnvironment env = PythonEnvUtils.preparePythonEnvironment((ReadableConfig)config, (String)entryFilePath, (String)this.tmpDirPath);
        HashSet<String> expectedPythonPaths = new HashSet<String>();
        expectedPythonPaths.add(new Path(String.join((CharSequence)File.separator, PythonEnvUtilsTest.replaceUUID(env.tempDirectory), "{uuid}")).toString());
        Set actualPaths = Arrays.stream(env.pythonPath.split(File.pathSeparator)).map(PythonEnvUtilsTest::replaceUUID).collect(Collectors.toSet());
        Assert.assertEquals(expectedPythonPaths, actualPaths);
    }

    @After
    public void cleanEnvironment() {
        FileUtils.deleteDirectoryQuietly((File)new File(this.tmpDirPath));
    }

    private static String replaceUUID(String originPath) {
        return originPath.replaceAll("[a-z0-9]{8}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{12}", "{uuid}");
    }
}

